/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.callback;

import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.wildfly.security.auth.callback.AbstractExtendedCallback;

public final class SSLCallback
extends AbstractExtendedCallback {
    private static final long serialVersionUID = 7854221380587494535L;
    private final SSLContext sslContext;
    private final SSLEngine sslEngine;
    private final SSLSocket sslSocket;

    public SSLCallback(SSLContext sslContext, SSLSocket sslSocket) {
        this.sslContext = sslContext;
        this.sslSocket = sslSocket;
        this.sslEngine = null;
    }

    public SSLCallback(SSLContext sslContext, SSLEngine sslEngine) {
        this.sslContext = sslContext;
        this.sslEngine = sslEngine;
        this.sslSocket = null;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public SSLSession getSslSession() {
        return this.sslEngine != null ? this.sslEngine.getSession() : this.sslSocket.getSession();
    }

    public SSLParameters getSslParameters() {
        return this.sslEngine != null ? this.sslEngine.getSSLParameters() : this.sslSocket.getSSLParameters();
    }

    public boolean isClientMode() {
        return this.sslEngine != null ? this.sslEngine.getUseClientMode() : this.sslSocket.getUseClientMode();
    }

    public boolean isClientAuthWanted() {
        return this.sslEngine != null ? this.sslEngine.getWantClientAuth() : this.sslSocket.getWantClientAuth();
    }

    public boolean isClientAuthNeeded() {
        return this.sslEngine != null ? this.sslEngine.getNeedClientAuth() : this.sslSocket.getNeedClientAuth();
    }

    public boolean isSessionCreationEnabled() {
        return this.sslEngine != null ? this.sslEngine.getEnableSessionCreation() : this.sslSocket.getEnableSessionCreation();
    }
}

