/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.scram;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Map;
import javax.crypto.Mac;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.wildfly.security.auth.callback.ChannelBindingCallback;
import org.wildfly.security.sasl.scram.ScramSaslClient;

public final class ScramSaslClientFactory
implements SaslClientFactory {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        Mac mac;
        MessageDigest messageDigest;
        String name;
        boolean plus = false;
        ChannelBindingCallback callback = new ChannelBindingCallback();
        try {
            cbh.handle(new Callback[]{callback});
        }
        catch (SaslException e) {
            throw e;
        }
        catch (IOException e) {
            throw new SaslException("Failed to determine channel binding status", e);
        }
        catch (UnsupportedCallbackException e) {
            // empty catch block
        }
        String bindingType = callback.getBindingType();
        byte[] bindingData = callback.getBindingData();
        boolean bindingOk = bindingType != null && bindingData != null;
        boolean bindingRequired = "true".equals(props.get("wildfly.sasl.channel-binding-required"));
        String[] stringArray = mechanisms;
        int n = stringArray.length;
        int n2 = 0;
        block34: while (true) {
            String mechanism;
            if (n2 >= n) {
                return null;
            }
            switch (mechanism = stringArray[n2]) {
                case "SCRAM-SHA-1-PLUS": {
                    if (!bindingOk) break;
                    plus = true;
                }
                case "SCRAM-SHA-1": {
                    if (bindingRequired && !plus) break;
                    name = mechanism;
                    try {
                        messageDigest = MessageDigest.getInstance("SHA-1");
                        mac = Mac.getInstance("HmacSHA1");
                        break block34;
                    }
                    catch (NoSuchAlgorithmException e) {
                        break;
                    }
                }
                case "SCRAM-SHA-256-PLUS": {
                    if (!bindingOk) break;
                    plus = true;
                }
                case "SCRAM-SHA-256": {
                    if (bindingRequired && !plus) break;
                    name = mechanism;
                    try {
                        messageDigest = MessageDigest.getInstance("SHA-256");
                        mac = Mac.getInstance("HmacSHA256");
                        break block34;
                    }
                    catch (NoSuchAlgorithmException e) {
                        break;
                    }
                }
                case "SCRAM-SHA-384-PLUS": {
                    if (!bindingOk) break;
                    plus = true;
                }
                case "SCRAM-SHA-384": {
                    if (bindingRequired && !plus) break;
                    name = mechanism;
                    try {
                        messageDigest = MessageDigest.getInstance("SHA-384");
                        mac = Mac.getInstance("HmacSHA384");
                        break block34;
                    }
                    catch (NoSuchAlgorithmException e) {
                        break;
                    }
                }
                case "SCRAM-SHA-512-PLUS": {
                    if (!bindingOk) break;
                    plus = true;
                }
                case "SCRAM-SHA-512": {
                    if (bindingRequired && !plus) break;
                    name = mechanism;
                    try {
                        messageDigest = MessageDigest.getInstance("SHA-512");
                        mac = Mac.getInstance("HmacSHA512");
                        break block34;
                    }
                    catch (NoSuchAlgorithmException e) {
                        // empty catch block
                    }
                }
            }
            ++n2;
        }
        Object propVal = props.get("wildfly.sasl.secure-rng");
        String rngName = propVal instanceof String ? (String)propVal : null;
        SecureRandom secureRandom = null;
        if (rngName != null) {
            try {
                secureRandom = SecureRandom.getInstance(rngName);
            }
            catch (NoSuchAlgorithmException mechanism) {
                // empty catch block
            }
        }
        ScramSaslClient client = new ScramSaslClient(name, messageDigest, mac, secureRandom, protocol, serverName, cbh, authorizationId, props, plus, bindingType, bindingData);
        client.init();
        return client;
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> props) {
        if (!"true".equals(props.get("wildfly.sasl.mechanism-query-all")) && "true".equals(props.get("wildfly.sasl.channel-binding-required"))) {
            return new String[]{"SCRAM-SHA-1-PLUS", "SCRAM-SHA-256-PLUS", "SCRAM-SHA-384-PLUS", "SCRAM-SHA-512-PLUS"};
        }
        return new String[]{"SCRAM-SHA-1", "SCRAM-SHA-1-PLUS", "SCRAM-SHA-256", "SCRAM-SHA-256-PLUS", "SCRAM-SHA-384", "SCRAM-SHA-384-PLUS", "SCRAM-SHA-512", "SCRAM-SHA-512-PLUS"};
    }
}

