/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocket;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.wildfly.security.auth.callback.SSLQueryCallbackHandler;
import org.wildfly.security.sasl.util.AbstractDelegatingSaslClientFactory;

public final class SSLSaslClientFactory
extends AbstractDelegatingSaslClientFactory
implements SaslClientFactory {
    private final SSLContext sslContext;
    private final SSLSocket sslSocket;
    private final SSLEngine sslEngine;

    public SSLSaslClientFactory(SaslClientFactory delegate, SSLContext sslContext, SSLEngine sslEngine) {
        super(delegate);
        this.sslContext = sslContext;
        this.sslEngine = sslEngine;
        this.sslSocket = null;
    }

    public SSLSaslClientFactory(SaslClientFactory delegate, SSLContext sslContext, SSLSocket sslSocket) {
        super(delegate);
        this.sslContext = sslContext;
        this.sslSocket = sslSocket;
        this.sslEngine = null;
    }

    @Override
    public SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        SSLQueryCallbackHandler newHandler = this.sslEngine != null ? new SSLQueryCallbackHandler(cbh, this.sslContext, this.sslEngine) : new SSLQueryCallbackHandler(cbh, this.sslContext, this.sslSocket);
        return super.createSaslClient(mechanisms, authorizationId, protocol, serverName, props, newHandler);
    }
}

