/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.provider;

import java.io.IOException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.callback.CallbackUtil;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.server.CredentialSupport;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.wildfly.security.password.interfaces.ClearPassword;

public class JaasSecurityRealm
implements SecurityRealm {
    private final String loginConfiguration;
    private CallbackHandler handler;

    public JaasSecurityRealm(String loginConfiguration) {
        this(loginConfiguration, null);
    }

    public JaasSecurityRealm(String loginConfiguration, CallbackHandler handler) {
        this.loginConfiguration = loginConfiguration;
        this.handler = handler;
    }

    @Override
    public RealmIdentity createRealmIdentity(String name) throws RealmUnavailableException {
        return new JaasRealmIdentity(new NamePrincipal(name));
    }

    @Override
    public CredentialSupport getCredentialSupport(Class<?> credentialType, String algorithmName) throws RealmUnavailableException {
        if (this.handler == null) {
            if (char[].class.isAssignableFrom(credentialType) || String.class.isAssignableFrom(credentialType) || ClearPassword.class.isAssignableFrom(credentialType)) {
                return CredentialSupport.VERIFIABLE_ONLY;
            }
            return CredentialSupport.UNSUPPORTED;
        }
        return CredentialSupport.POSSIBLY_VERIFIABLE;
    }

    private LoginContext createLoginContext(String loginConfig, Subject subject, CallbackHandler handler) throws RealmUnavailableException {
        if (WildFlySecurityManager.isChecking()) {
            try {
                return AccessController.doPrivileged(() -> new LoginContext(loginConfig, subject, handler));
            }
            catch (PrivilegedActionException pae) {
                throw ElytronMessages.log.failedToCreateLoginContext(pae.getCause());
            }
        }
        try {
            return new LoginContext(loginConfig, subject, handler);
        }
        catch (LoginException le) {
            throw ElytronMessages.log.failedToCreateLoginContext(le);
        }
    }

    private CallbackHandler createCallbackHandler(Principal principal, Object credential) throws RealmUnavailableException {
        if (this.handler == null) {
            return new DefaultCallbackHandler(principal, credential);
        }
        try {
            CallbackHandler callbackHandler = (CallbackHandler)this.handler.getClass().newInstance();
            Method setSecurityInfo = this.handler.getClass().getMethod("setSecurityInfo", Principal.class, Object.class);
            setSecurityInfo.invoke((Object)callbackHandler, principal, credential);
            return callbackHandler;
        }
        catch (Exception e) {
            throw ElytronMessages.log.failedToInstantiateCustomHandler(e);
        }
    }

    private class JaasAuthorizationIdentity
    implements AuthorizationIdentity {
        private static final String CALLER_PRINCIPAL_GROUP = "CallerPrincipal";
        private final Principal principal;
        private Principal callerPrincipal;
        private final Subject subject;

        private JaasAuthorizationIdentity(Principal principal, Subject subject) {
            this.principal = principal;
            this.subject = subject;
            this.callerPrincipal = this.getCallerPrincipal(subject);
        }

        private Principal getCallerPrincipal(Subject subject) {
            Set<Principal> principals;
            Principal callerPrincipal = null;
            if (subject != null && (principals = subject.getPrincipals()) != null && !principals.isEmpty()) {
                for (Principal principal : principals) {
                    Enumeration enumeration;
                    if (!(principal instanceof Group) || !principal.getName().equals(CALLER_PRINCIPAL_GROUP) || !(enumeration = ((Group)principal).members()).hasMoreElements()) continue;
                    callerPrincipal = (Principal)enumeration.nextElement();
                    break;
                }
            }
            return callerPrincipal;
        }
    }

    private class DefaultCallbackHandler
    implements CallbackHandler {
        private final Principal principal;
        private final Object credential;

        private DefaultCallbackHandler(Principal principal, Object credential) {
            this.principal = principal;
            this.credential = credential;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            Assert.checkNotNullParam((String)"callbacks", (Object)callbacks);
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    NameCallback nameCallback = (NameCallback)callback;
                    if (this.principal == null) continue;
                    nameCallback.setName(this.principal.getName());
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    PasswordCallback passwordCallback = (PasswordCallback)callback;
                    if (this.credential instanceof char[]) {
                        passwordCallback.setPassword((char[])this.credential);
                        continue;
                    }
                    if (this.credential instanceof String) {
                        passwordCallback.setPassword(((String)this.credential).toCharArray());
                        continue;
                    }
                    if (this.credential instanceof ClearPassword) {
                        passwordCallback.setPassword(((ClearPassword)this.credential).getPassword());
                        continue;
                    }
                    throw ElytronMessages.log.failedToConvertCredentialToPassword(callback);
                }
                CallbackUtil.unsupported(callback);
            }
        }
    }

    private class JaasRealmIdentity
    implements RealmIdentity {
        private final Principal principal;
        private Subject subject;

        private JaasRealmIdentity(Principal principal) {
            this.principal = principal;
        }

        @Override
        public String getName() {
            return this.principal.getName();
        }

        @Override
        public CredentialSupport getCredentialSupport(Class<?> credentialType, String algorithmName) throws RealmUnavailableException {
            return JaasSecurityRealm.this.getCredentialSupport(credentialType, algorithmName);
        }

        @Override
        public <C> C getCredential(Class<C> credentialType, String algorithmName) throws RealmUnavailableException {
            return null;
        }

        @Override
        public boolean verifyCredential(Object credential) throws RealmUnavailableException {
            boolean successfulLogin;
            this.subject = null;
            CallbackHandler callbackHandler = JaasSecurityRealm.this.createCallbackHandler(this.principal, credential);
            Subject subject = new Subject();
            LoginContext context = JaasSecurityRealm.this.createLoginContext(JaasSecurityRealm.this.loginConfiguration, subject, callbackHandler);
            try {
                context.login();
                successfulLogin = true;
                this.subject = subject;
            }
            catch (LoginException le) {
                ElytronMessages.log.debugJAASAuthenticationFailure(this.principal, le);
                successfulLogin = false;
            }
            return successfulLogin;
        }

        @Override
        public boolean exists() throws RealmUnavailableException {
            return true;
        }

        @Override
        public AuthorizationIdentity getAuthorizationIdentity() throws RealmUnavailableException {
            return new JaasAuthorizationIdentity(this.principal, this.subject);
        }
    }
}

