/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.security.PermissionCollection;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLServerSocketFactory;
import javax.security.sasl.SaslServerFactory;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.principal.AnonymousPrincipal;
import org.wildfly.security.auth.server.CredentialSupport;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.auth.server.PrincipalDecoder;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmInfo;
import org.wildfly.security.auth.server.RealmMapper;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.auth.server.ServerAuthenticationContext;
import org.wildfly.security.auth.server.SupportLevel;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.authz.PermissionMapper;
import org.wildfly.security.authz.RoleDecoder;
import org.wildfly.security.authz.RoleMapper;
import org.wildfly.security.permission.ElytronPermission;
import org.wildfly.security.util._private.UnmodifiableArrayList;

public final class SecurityDomain {
    static final ElytronPermission CREATE_SECURITY_DOMAIN = new ElytronPermission("createSecurityDomain");
    private final Map<String, RealmInfo> realmMap;
    private final String defaultRealmName;
    private final NameRewriter preRealmRewriter;
    private final RealmMapper realmMapper;
    private final NameRewriter postRealmRewriter;
    private final boolean anonymousAllowed;
    private final ThreadLocal<SecurityIdentity> currentSecurityIdentity;
    private final RoleMapper roleMapper;
    private final PrincipalDecoder principalDecoder;
    private final SecurityIdentity anonymousIdentity;
    private final PermissionMapper permissionMapper;

    SecurityDomain(Builder builder, HashMap<String, RealmInfo> realmMap) {
        this.realmMap = realmMap;
        this.defaultRealmName = builder.defaultRealmName;
        this.preRealmRewriter = builder.preRealmRewriter;
        this.realmMapper = builder.realmMapper;
        this.roleMapper = builder.roleMapper;
        this.permissionMapper = builder.permissionMapper;
        this.postRealmRewriter = builder.postRealmRewriter;
        this.principalDecoder = builder.principalDecoder;
        this.anonymousAllowed = false;
        RealmInfo realmInfo = new RealmInfo(SecurityRealm.EMPTY_REALM, "default", RoleMapper.IDENTITY_ROLE_MAPPER, NameRewriter.IDENTITY_REWRITER, RoleDecoder.DEFAULT);
        this.anonymousIdentity = new SecurityIdentity(this, AnonymousPrincipal.getInstance(), realmInfo, AuthorizationIdentity.EMPTY);
        this.currentSecurityIdentity = ThreadLocal.withInitial(() -> this.anonymousIdentity);
    }

    public static Builder builder() {
        return new Builder();
    }

    public ServerAuthenticationContext createNewAuthenticationContext() {
        return new ServerAuthenticationContext(this);
    }

    public RealmIdentity mapName(String name) throws RealmUnavailableException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        name = this.preRealmRewriter.rewriteName(name);
        if (name == null) {
            throw ElytronMessages.log.invalidName();
        }
        String realmName = this.mapRealmName(name);
        SecurityRealm securityRealm = this.getRealm(realmName);
        assert (securityRealm != null);
        if ((name = this.postRealmRewriter.rewriteName(name)) == null) {
            throw ElytronMessages.log.invalidName();
        }
        return securityRealm.createRealmIdentity(name);
    }

    public RealmIdentity mapPrincipal(Principal principal) throws RealmUnavailableException, IllegalArgumentException {
        Assert.checkNotNullParam((String)"principal", (Object)principal);
        String name = this.principalDecoder.getName(principal);
        if (name == null) {
            throw ElytronMessages.log.unrecognizedPrincipalType(principal);
        }
        return this.mapName(name);
    }

    public SSLServerSocketFactory getSslServerSocketFactory() {
        throw new UnsupportedOperationException();
    }

    public List<String> getSaslServerMechanismNames(SaslServerFactory saslServerFactory) {
        String[] names = saslServerFactory.getMechanismNames(Collections.singletonMap("wildfly.sasl.mechanism-query-all", "true"));
        if (names == null || names.length == 0) {
            return Collections.emptyList();
        }
        if (names.length == 1) {
            return Collections.singletonList(names[0]);
        }
        return new UnmodifiableArrayList<String>(names);
    }

    public boolean isAnonymousAllowed() {
        return this.anonymousAllowed;
    }

    SecurityRealm getRealm(String realmName) {
        return this.getRealmInfo(realmName).getSecurityRealm();
    }

    RealmInfo getRealmInfo(String realmName) {
        RealmInfo realmInfo = this.realmMap.get(realmName);
        if (realmInfo == null) {
            realmInfo = this.realmMap.get(this.defaultRealmName);
        }
        return realmInfo;
    }

    CredentialSupport getCredentialSupport(Class<?> credentialType, String algorithmName) {
        SupportLevel verifyMax = null;
        SupportLevel verifyMin = null;
        SupportLevel obtainMax = null;
        SupportLevel obtainMin = null;
        Iterator<RealmInfo> iterator = this.realmMap.values().iterator();
        if (iterator.hasNext()) {
            while (iterator.hasNext()) {
                RealmInfo realmInfo = iterator.next();
                SecurityRealm realm = realmInfo.getSecurityRealm();
                try {
                    CredentialSupport support = realm.getCredentialSupport(credentialType, algorithmName);
                    SupportLevel obtainable = support.obtainableSupportLevel();
                    SupportLevel verification = support.verificationSupportLevel();
                    if (obtainMin == null || obtainMax == null || verifyMin == null || verifyMax == null) {
                        obtainMin = obtainMax = obtainable;
                        verifyMin = verifyMax = verification;
                        continue;
                    }
                    if (obtainable.compareTo(obtainMin) < 0) {
                        obtainMin = obtainable;
                    }
                    if (obtainable.compareTo(obtainMax) > 0) {
                        obtainMax = obtainable;
                    }
                    if (verification.compareTo(verifyMin) < 0) {
                        verifyMin = verification;
                    }
                    if (verification.compareTo(verifyMax) <= 0) continue;
                    verifyMax = verification;
                }
                catch (RealmUnavailableException realmUnavailableException) {}
            }
            if (obtainMin == null || obtainMax == null || verifyMin == null || verifyMax == null) {
                return CredentialSupport.UNSUPPORTED;
            }
            return CredentialSupport.getCredentialSupport(this.minMax(obtainMin, obtainMax), this.minMax(verifyMin, verifyMax));
        }
        return CredentialSupport.UNSUPPORTED;
    }

    private SupportLevel minMax(SupportLevel min, SupportLevel max) {
        if (min == max) {
            return min;
        }
        if (max == SupportLevel.UNSUPPORTED) {
            return SupportLevel.UNSUPPORTED;
        }
        if (min == SupportLevel.SUPPORTED) {
            return SupportLevel.SUPPORTED;
        }
        return SupportLevel.POSSIBLY_SUPPORTED;
    }

    public SecurityIdentity getCurrentSecurityIdentity() {
        return this.currentSecurityIdentity.get();
    }

    public SecurityIdentity getAnonymousSecurityIdentity() {
        return this.anonymousIdentity;
    }

    SecurityIdentity getAndSetCurrentSecurityIdentity(SecurityIdentity newIdentity) {
        try {
            SecurityIdentity securityIdentity = this.currentSecurityIdentity.get();
            return securityIdentity;
        }
        finally {
            this.currentSecurityIdentity.set(newIdentity);
        }
    }

    void setCurrentSecurityIdentity(SecurityIdentity newIdentity) {
        this.currentSecurityIdentity.set(newIdentity);
    }

    Set<String> mapRoles(SecurityIdentity securityIdentity) {
        Assert.checkNotNullParam((String)"securityIdentity", (Object)securityIdentity);
        AuthorizationIdentity identity = securityIdentity.getAuthorizationIdentity();
        Attributes attributes = identity.getAttributes();
        RealmInfo realmInfo = securityIdentity.getRealmInfo();
        RoleDecoder roleDecoder = realmInfo.getRoleDecoder();
        Set<String> mappedRoles = roleDecoder.decodeRoles(attributes);
        RoleMapper realmRoleMapper = realmInfo.getRoleMapper();
        mappedRoles = realmRoleMapper.mapRoles(mappedRoles);
        return this.roleMapper.mapRoles(mappedRoles);
    }

    PermissionCollection mapPermissions(SecurityIdentity securityIdentity) {
        Assert.checkNotNullParam((String)"securityIdentity", (Object)securityIdentity);
        Principal principal = securityIdentity.getPrincipal();
        Set<String> roles = securityIdentity.getRoles();
        return this.permissionMapper.mapPermissions(principal, roles);
    }

    NameRewriter getPreRealmRewriter() {
        return this.preRealmRewriter;
    }

    String mapRealmName(String name) {
        String realm = this.realmMapper.getRealmMapping(name);
        return realm != null ? realm : this.defaultRealmName;
    }

    NameRewriter getPostRealmRewriter() {
        return this.postRealmRewriter;
    }

    RoleMapper getRoleMapper() {
        return this.roleMapper;
    }

    PrincipalDecoder getPrincipalDecoder() {
        return this.principalDecoder;
    }

    public static class RealmBuilder {
        private final String name;
        private final SecurityRealm realm;
        private RoleMapper roleMapper = RoleMapper.IDENTITY_ROLE_MAPPER;
        private NameRewriter nameRewriter = NameRewriter.IDENTITY_REWRITER;
        private RoleDecoder roleDecoder = RoleDecoder.DEFAULT;

        RealmBuilder(String name, SecurityRealm realm) {
            this.name = name;
            this.realm = realm;
        }

        public String getName() {
            return this.name;
        }

        public SecurityRealm getRealm() {
            return this.realm;
        }

        public RoleMapper getRoleMapper() {
            return this.roleMapper;
        }

        public void setRoleMapper(RoleMapper roleMapper) {
            Assert.checkNotNullParam((String)"roleMapper", (Object)roleMapper);
            this.roleMapper = roleMapper;
        }

        public NameRewriter getNameRewriter() {
            return this.nameRewriter;
        }

        public void setNameRewriter(NameRewriter nameRewriter) {
            Assert.checkNotNullParam((String)"nameRewriter", (Object)nameRewriter);
            this.nameRewriter = nameRewriter;
        }

        public RoleDecoder getRoleDecoder() {
            return this.roleDecoder;
        }

        public void setRoleDecoder(RoleDecoder roleDecoder) {
            this.roleDecoder = roleDecoder;
        }
    }

    public static final class Builder {
        private boolean built = false;
        private final HashMap<String, RealmBuilder> realms = new HashMap();
        private NameRewriter preRealmRewriter = NameRewriter.IDENTITY_REWRITER;
        private NameRewriter postRealmRewriter = NameRewriter.IDENTITY_REWRITER;
        private String defaultRealmName;
        private RealmMapper realmMapper = RealmMapper.DEFAULT_REALM_MAPPER;
        private RoleMapper roleMapper = RoleMapper.IDENTITY_ROLE_MAPPER;
        private PermissionMapper permissionMapper = PermissionMapper.EMPTY_PERMISSION_MAPPER;
        private PrincipalDecoder principalDecoder = PrincipalDecoder.DEFAULT;

        Builder() {
        }

        public Builder setPreRealmRewriter(NameRewriter rewriter) {
            Assert.checkNotNullParam((String)"rewriter", (Object)rewriter);
            this.assertNotBuilt();
            this.preRealmRewriter = rewriter;
            return this;
        }

        public Builder setPostRealmRewriter(NameRewriter rewriter) {
            Assert.checkNotNullParam((String)"rewriter", (Object)rewriter);
            this.assertNotBuilt();
            this.postRealmRewriter = rewriter;
            return this;
        }

        public Builder setRealmMapper(RealmMapper realmMapper) {
            Assert.checkNotNullParam((String)"realmMapper", (Object)realmMapper);
            this.assertNotBuilt();
            this.realmMapper = realmMapper;
            return this;
        }

        public Builder setRoleMapper(RoleMapper roleMapper) {
            Assert.checkNotNullParam((String)"roleMapper", (Object)roleMapper);
            this.assertNotBuilt();
            this.roleMapper = roleMapper;
            return this;
        }

        public Builder setPermissionMapper(PermissionMapper permissionMapper) {
            Assert.checkNotNullParam((String)"permissionMapper", (Object)permissionMapper);
            this.assertNotBuilt();
            this.permissionMapper = permissionMapper;
            return this;
        }

        public Builder setPrincipalDecoder(PrincipalDecoder principalDecoder) {
            Assert.checkNotNullParam((String)"principalDecoder", (Object)principalDecoder);
            this.assertNotBuilt();
            this.principalDecoder = principalDecoder;
            return this;
        }

        public RealmBuilder addRealm(String name, SecurityRealm realm) {
            Assert.checkNotNullParam((String)"name", (Object)name);
            Assert.checkNotNullParam((String)"realm", (Object)realm);
            this.assertNotBuilt();
            RealmBuilder realmBuilder = new RealmBuilder(name, realm);
            this.realms.put(name, realmBuilder);
            return realmBuilder;
        }

        public String getDefaultRealmName() {
            return this.defaultRealmName;
        }

        public Builder setDefaultRealmName(String defaultRealmName) {
            Assert.checkNotNullParam((String)"defaultRealmName", (Object)defaultRealmName);
            this.assertNotBuilt();
            this.defaultRealmName = defaultRealmName;
            return this;
        }

        public SecurityDomain build() {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(CREATE_SECURITY_DOMAIN);
            }
            String defaultRealmName = this.defaultRealmName;
            Assert.checkNotNullParam((String)"defaultRealmName", (Object)defaultRealmName);
            HashMap<String, RealmInfo> realmMap = new HashMap<String, RealmInfo>(this.realms.size());
            for (RealmBuilder realmBuilder : this.realms.values()) {
                realmMap.put(realmBuilder.getName(), new RealmInfo(realmBuilder));
            }
            if (!realmMap.containsKey(defaultRealmName)) {
                throw ElytronMessages.log.realmMapDoesNotContainDefault(defaultRealmName);
            }
            this.assertNotBuilt();
            this.built = true;
            return new SecurityDomain(this, realmMap);
        }

        private void assertNotBuilt() {
            if (this.built) {
                throw ElytronMessages.log.builderAlreadyBuilt();
            }
        }
    }
}

