/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.audit;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleListAttributeDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.audit.AuditLogHandler;
import org.jboss.as.controller.audit.InMemoryAuditLogHander;
import org.jboss.as.controller.audit.ManagedAuditLogger;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.management._private.DomainManagementResolver;
import org.jboss.as.domain.management.audit.AuditLogHandlerResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class InMemoryAuditLogHandlerResourceDefinition
extends AuditLogHandlerResourceDefinition {
    public static final SimpleAttributeDefinition MAX_OPERATION_COUNT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"max-history", (ModelType)ModelType.INT).setAllowNull(true)).setAllowExpression(true)).setDefaultValue(new ModelNode(10))).setValidator((ParameterValidator)new IntRangeValidator(0, true, true))).build();
    public static final AttributeDefinition HISTORY_ELEMENT = new ObjectTypeAttributeDefinition.Builder("operation", new AttributeDefinition[]{((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"operation-date", (ModelType)ModelType.STRING, (boolean)false).setStorageRuntime()).build(), ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"version", (ModelType)ModelType.STRING, (boolean)false).setStorageRuntime()).build(), ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"user", (ModelType)ModelType.STRING, (boolean)false).setStorageRuntime()).build(), ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"domain-uuid", (ModelType)ModelType.STRING, (boolean)false).setStorageRuntime()).build(), ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"access-mechanism", (ModelType)ModelType.STRING, (boolean)false).setStorageRuntime()).build(), ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"remote-address", (ModelType)ModelType.STRING, (boolean)false).setStorageRuntime()).build(), ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"outcome", (ModelType)ModelType.STRING, (boolean)false).setStorageRuntime()).build(), SimpleListAttributeDefinition.Builder.of((String)"operations", (AttributeDefinition)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"operation", (ModelType)ModelType.STRING, (boolean)false).setStorageRuntime()).build()).build()}).build();
    public static final String OPERATION_NAME = "show-logs";
    protected static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{MAX_OPERATION_COUNT};
    private static final Map<String, InMemoryAuditLogHander> histories = Collections.synchronizedMap(new HashMap());

    public InMemoryAuditLogHandlerResourceDefinition(ManagedAuditLogger auditLogger) {
        super(auditLogger, null, PathElement.pathElement((String)"in-memory-handler"), DomainManagementResolver.getResolver("core.management.in-memory-handler"), (OperationStepHandler)new InMemoryAuditLogHandlerAddHandler(auditLogger), (OperationStepHandler)new InMemoryAuditLogHandlerRemoveHandler(auditLogger));
    }

    @Override
    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        resourceRegistration.registerOperationHandler((OperationDefinition)new SimpleOperationDefinitionBuilder(OPERATION_NAME, this.getResourceDescriptionResolver()).setReadOnly().setRuntimeOnly().setReplyType(ModelType.LIST).setReplyValueType(ModelType.STRING).build(), (OperationStepHandler)new ShowInMemoryLogsHandler());
    }

    @Override
    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (AttributeDefinition def : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(def, null, (OperationStepHandler)new InMemoryMaxHistoryWriteHandler());
        }
    }

    public static ModelNode createServerAddOperation(PathAddress address, ModelNode fileHandler) {
        ModelNode add = Util.createAddOperation((PathAddress)address);
        for (AttributeDefinition def : ATTRIBUTES) {
            if (!fileHandler.get(def.getName()).isDefined()) continue;
            add.get(def.getName()).set(fileHandler.get(def.getName()));
        }
        return add;
    }

    protected static class InMemoryMaxHistoryWriteHandler
    extends AbstractWriteAttributeHandler<Void> {
        public InMemoryMaxHistoryWriteHandler() {
            super(new AttributeDefinition[]{MAX_OPERATION_COUNT});
        }

        protected boolean requiresRuntime(OperationContext context) {
            return true;
        }

        protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
            if ("max-history".equals(attributeName)) {
                String name = Util.getNameFromAddress((ModelNode)operation.require("address"));
                InMemoryAuditLogHander loghandler = (InMemoryAuditLogHander)histories.get(name);
                if (loghandler != null) {
                    loghandler.setMaxHistory(valueToRevert.asInt());
                }
            }
        }

        protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
            if ("max-history".equals(attributeName)) {
                String name = Util.getNameFromAddress((ModelNode)operation.require("address"));
                InMemoryAuditLogHander loghandler = (InMemoryAuditLogHander)histories.get(name);
                if (loghandler != null) {
                    loghandler.setMaxHistory(resolvedValue.asInt());
                    return true;
                }
            }
            return false;
        }
    }

    protected static class InMemoryAuditLogHandlerRemoveHandler
    extends AuditLogHandlerResourceDefinition.HandlerRemoveHandler {
        public InMemoryAuditLogHandlerRemoveHandler(ManagedAuditLogger auditLogger) {
            super(auditLogger);
        }

        @Override
        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            super.performRuntime(context, operation, model);
            String name = Util.getNameFromAddress((ModelNode)operation.require("address"));
            histories.remove(name);
        }
    }

    protected static class InMemoryAuditLogHandlerAddHandler
    extends AbstractAddStepHandler {
        private final ManagedAuditLogger auditLogger;

        private InMemoryAuditLogHandlerAddHandler(ManagedAuditLogger auditLogger) {
            this.auditLogger = auditLogger;
        }

        protected boolean requiresRuntime(OperationContext context) {
            return true;
        }

        protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            super.populateModel(operation, model);
            MAX_OPERATION_COUNT.validateAndSet(operation, model);
        }

        protected InMemoryAuditLogHander createHandler(OperationContext context, ModelNode operation) throws OperationFailedException {
            String name = Util.getNameFromAddress((ModelNode)operation.require("address"));
            int maxOperationCount = MAX_OPERATION_COUNT.resolveModelAttribute(context, operation).asInt();
            InMemoryAuditLogHander handler = new InMemoryAuditLogHander(name, maxOperationCount);
            histories.put(name, handler);
            return handler;
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            InMemoryAuditLogHander handler = this.createHandler(context, operation);
            this.auditLogger.getUpdater().addHandler((AuditLogHandler)handler);
            this.auditLogger.addFormatter(handler.getFormatter());
        }

        protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
            this.auditLogger.getUpdater().rollbackChanges();
        }
    }

    protected static class ShowInMemoryLogsHandler
    extends AbstractRuntimeOnlyHandler {
        protected ShowInMemoryLogsHandler() {
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            String name = Util.getNameFromAddress((ModelNode)operation.require("address"));
            InMemoryAuditLogHander loghandler = (InMemoryAuditLogHander)histories.get(name);
            if (loghandler != null) {
                ModelNode result = context.getResult().setEmptyList();
                List items = loghandler.getItems();
                for (int i = items.size() - 1; i >= 0; --i) {
                    ModelNode entry = (ModelNode)items.get(i);
                    ModelNode configurationChange = entry.clone();
                    result.add(configurationChange);
                }
            }
        }
    }
}

