/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.IOException;
import java.security.Principal;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import org.jboss.as.core.security.RealmGroup;
import org.jboss.as.core.security.RealmUser;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.connections.ldap.LdapConnectionManager;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.as.domain.management.security.BaseLdapGroupSearchResource;
import org.jboss.as.domain.management.security.LdapConnectionHandler;
import org.jboss.as.domain.management.security.LdapEntry;
import org.jboss.as.domain.management.security.LdapSearcherCache;
import org.jboss.as.domain.management.security.SubjectSupplemental;
import org.jboss.as.domain.management.security.SubjectSupplementalService;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class LdapSubjectSupplementalService
implements Service<SubjectSupplementalService>,
SubjectSupplementalService {
    private final InjectedValue<LdapConnectionManager> connectionManager = new InjectedValue();
    private final InjectedValue<LdapSearcherCache<LdapEntry, String>> userSearcherInjector = new InjectedValue();
    private final InjectedValue<LdapSearcherCache<LdapEntry[], LdapEntry>> groupSearcherInjector = new InjectedValue();
    private LdapSearcherCache<LdapEntry, String> userSearcher;
    private LdapSearcherCache<LdapEntry[], LdapEntry> groupSearcher;
    protected final int searchTimeLimit = 10000;
    private final String realmName;
    private final boolean shareConnection;
    private final boolean forceUserDnSearch;
    private final boolean iterative;
    private final BaseLdapGroupSearchResource.GroupName groupName;

    public LdapSubjectSupplementalService(String realmName, boolean shareConnection, boolean forceUserDnSearch, boolean iterative, BaseLdapGroupSearchResource.GroupName groupName) {
        this.realmName = realmName;
        this.shareConnection = shareConnection;
        this.forceUserDnSearch = forceUserDnSearch;
        this.iterative = iterative;
        this.groupName = groupName;
    }

    public SubjectSupplementalService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public void start(StartContext context) throws StartException {
        this.userSearcher = (LdapSearcherCache)this.userSearcherInjector.getOptionalValue();
        this.groupSearcher = (LdapSearcherCache)this.groupSearcherInjector.getValue();
        if (DomainManagementLogger.SECURITY_LOGGER.isTraceEnabled()) {
            DomainManagementLogger.SECURITY_LOGGER.tracef("LdapSubjectSupplementalService realmName=%s", this.realmName);
            DomainManagementLogger.SECURITY_LOGGER.tracef("LdapSubjectSupplementalService shareConnection=%b", this.shareConnection);
            DomainManagementLogger.SECURITY_LOGGER.tracef("LdapSubjectSupplementalService forceUserDnSearch=%b", this.forceUserDnSearch);
            DomainManagementLogger.SECURITY_LOGGER.tracef("LdapSubjectSupplementalService iterative=%b", this.iterative);
            DomainManagementLogger.SECURITY_LOGGER.tracef("LdapSubjectSupplementalService groupName=%s", (Object)this.groupName);
        }
    }

    public void stop(StopContext context) {
        this.groupSearcher = null;
        this.userSearcher = null;
    }

    public Injector<LdapConnectionManager> getConnectionManagerInjector() {
        return this.connectionManager;
    }

    public Injector<LdapSearcherCache<LdapEntry, String>> getLdapUserSearcherInjector() {
        return this.userSearcherInjector;
    }

    public Injector<LdapSearcherCache<LdapEntry[], LdapEntry>> getLdapGroupSearcherInjector() {
        return this.groupSearcherInjector;
    }

    @Override
    public SubjectSupplemental getSubjectSupplemental(Map<String, Object> sharedState) {
        return new LdapSubjectSupplemental(sharedState);
    }

    public static final class ServiceUtil {
        private static final String SERVICE_SUFFIX = "ldap-authorization";

        private ServiceUtil() {
        }

        public static ServiceName createServiceName(String realmName) {
            return SecurityRealm.ServiceUtil.createServiceName(realmName).append(new String[]{SERVICE_SUFFIX});
        }
    }

    public class LdapSubjectSupplemental
    implements SubjectSupplemental {
        private final Set<LdapEntry> searchedPerformed = new HashSet<LdapEntry>();
        private final Map<String, Object> sharedState;

        protected LdapSubjectSupplemental(Map<String, Object> sharedState) {
            this.sharedState = sharedState;
        }

        @Override
        public void supplementSubject(Subject subject) throws IOException {
            LdapConnectionHandler connectionHandler;
            Set<RealmUser> users = subject.getPrincipals(RealmUser.class);
            Set<Principal> principals = subject.getPrincipals();
            if (this.sharedState.containsKey(LdapConnectionHandler.class.getName())) {
                DomainManagementLogger.SECURITY_LOGGER.trace("Using existing LdapConnectionHandler from shared state.");
                connectionHandler = (LdapConnectionHandler)this.sharedState.remove(LdapConnectionHandler.class.getName());
            } else {
                DomainManagementLogger.SECURITY_LOGGER.trace("Creating new LdapConnectionHandler.");
                connectionHandler = LdapConnectionHandler.newInstance((LdapConnectionManager)LdapSubjectSupplementalService.this.connectionManager.getValue());
            }
            try {
                for (RealmUser current : users) {
                    DomainManagementLogger.SECURITY_LOGGER.tracef("Loading groups for '%s'", current);
                    principals.addAll(this.loadGroups(current, connectionHandler));
                }
            }
            catch (Exception e) {
                DomainManagementLogger.SECURITY_LOGGER.trace("Failure supplementing Subject", e);
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new IOException(e);
            }
            finally {
                connectionHandler.close();
            }
        }

        private Set<RealmGroup> loadGroups(RealmUser user, LdapConnectionHandler connectionHandler) throws IOException, NamingException {
            LdapEntry entry = null;
            if (!LdapSubjectSupplementalService.this.forceUserDnSearch && this.sharedState.containsKey(LdapEntry.class.getName())) {
                entry = (LdapEntry)this.sharedState.get(LdapEntry.class.getName());
                DomainManagementLogger.SECURITY_LOGGER.tracef("Loaded from sharedState '%s'", entry);
            }
            if (entry == null || !user.getName().equals(entry.getSimpleName())) {
                entry = (LdapEntry)LdapSubjectSupplementalService.this.userSearcher.search(connectionHandler, user.getName()).getResult();
                DomainManagementLogger.SECURITY_LOGGER.tracef("Performed userSearch '%s'", entry);
            }
            return this.loadGroups(entry, connectionHandler);
        }

        private Set<RealmGroup> loadGroups(LdapEntry entry, LdapConnectionHandler connectionHandler) throws IOException, NamingException {
            HashSet<RealmGroup> realmGroups = new HashSet<RealmGroup>();
            Stack<LdapEntry[]> entries = new Stack<LdapEntry[]>();
            entries.push(this.loadGroupEntries(entry, connectionHandler));
            while (!entries.isEmpty()) {
                LdapEntry[] found;
                for (LdapEntry current : found = (LdapEntry[])entries.pop()) {
                    RealmGroup group = new RealmGroup(LdapSubjectSupplementalService.this.realmName, LdapSubjectSupplementalService.this.groupName == BaseLdapGroupSearchResource.GroupName.SIMPLE ? current.getSimpleName() : current.getDistinguishedName());
                    DomainManagementLogger.SECURITY_LOGGER.tracef("Adding RealmGroup '%s'", group);
                    realmGroups.add(group);
                    if (!LdapSubjectSupplementalService.this.iterative) continue;
                    DomainManagementLogger.SECURITY_LOGGER.tracef("Performing iterative load for %s", current);
                    entries.push(this.loadGroupEntries(current, connectionHandler));
                }
            }
            return realmGroups;
        }

        private LdapEntry[] loadGroupEntries(LdapEntry entry, LdapConnectionHandler connectionHandler) throws IOException, NamingException {
            if (!this.searchedPerformed.add(entry)) {
                DomainManagementLogger.SECURITY_LOGGER.tracef("A search has already been performed for %s", entry);
                return new LdapEntry[0];
            }
            return (LdapEntry[])LdapSubjectSupplementalService.this.groupSearcher.search(connectionHandler, entry).getResult();
        }
    }
}

