/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.capability.registry;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.capability.registry.CapabilityContext;
import org.jboss.as.controller.capability.registry.CapabilityRegistration;
import org.jboss.as.controller.capability.registry.RegistrationPoint;

public class RuntimeCapabilityRegistration
extends CapabilityRegistration<RuntimeCapability> {
    private final Map<PathAddress, RegistrationPoint> registrationPoints = new LinkedHashMap<PathAddress, RegistrationPoint>();

    public RuntimeCapabilityRegistration(RuntimeCapability capability, CapabilityContext context, RegistrationPoint registrationPoint) {
        super(capability, context);
        this.registrationPoints.put(registrationPoint.getAddress(), registrationPoint);
    }

    public RuntimeCapabilityRegistration(RuntimeCapabilityRegistration toCopy) {
        super(toCopy.getCapability(), toCopy.getCapabilityContext());
        this.registrationPoints.putAll(toCopy.registrationPoints);
    }

    public synchronized RegistrationPoint getOldestRegistrationPoint() {
        return this.registrationPoints.size() == 0 ? null : this.registrationPoints.values().iterator().next();
    }

    public synchronized Set<RegistrationPoint> getRegistrationPoints() {
        return Collections.unmodifiableSet(new HashSet<RegistrationPoint>(this.registrationPoints.values()));
    }

    public synchronized boolean addRegistrationPoint(RegistrationPoint toAdd) {
        PathAddress addedAddress = toAdd.getAddress();
        if (this.registrationPoints.containsKey(addedAddress)) {
            return false;
        }
        this.registrationPoints.put(addedAddress, toAdd);
        return true;
    }

    public synchronized boolean removeRegistrationPoint(RegistrationPoint toAdd) {
        PathAddress addedAddress = toAdd.getAddress();
        if (!this.registrationPoints.containsKey(addedAddress)) {
            return false;
        }
        this.registrationPoints.remove(addedAddress);
        return true;
    }

    public synchronized int getRegistrationPointCount() {
        return this.registrationPoints.size();
    }
}

