/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.client.ajp;

import io.undertow.UndertowOptions;
import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientProvider;
import io.undertow.client.ClientStatistics;
import io.undertow.client.ajp.AjpClientConnection;
import io.undertow.conduits.ByteActivityCallback;
import io.undertow.conduits.BytesReceivedStreamSourceConduit;
import io.undertow.conduits.BytesSentStreamSinkConduit;
import io.undertow.protocols.ajp.AjpClientChannel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.xnio.ChannelListener;
import org.xnio.IoFuture;
import org.xnio.OptionMap;
import org.xnio.Pool;
import org.xnio.StreamConnection;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.conduits.StreamSourceConduit;
import org.xnio.ssl.XnioSsl;

public class AjpClientProvider
implements ClientProvider {
    @Override
    public Set<String> handlesSchemes() {
        return new HashSet<String>(Arrays.asList("ajp"));
    }

    @Override
    public void connect(ClientCallback<ClientConnection> listener, URI uri, XnioWorker worker, XnioSsl ssl, Pool<ByteBuffer> bufferPool, OptionMap options) {
        this.connect(listener, null, uri, worker, ssl, bufferPool, options);
    }

    @Override
    public void connect(ClientCallback<ClientConnection> listener, URI uri, XnioIoThread ioThread, XnioSsl ssl, Pool<ByteBuffer> bufferPool, OptionMap options) {
        this.connect(listener, null, uri, ioThread, ssl, bufferPool, options);
    }

    @Override
    public void connect(final ClientCallback<ClientConnection> listener, InetSocketAddress bindAddress, final URI uri, XnioWorker worker, final XnioSsl ssl, final Pool<ByteBuffer> bufferPool, final OptionMap options) {
        ChannelListener<StreamConnection> openListener = new ChannelListener<StreamConnection>(){

            public void handleEvent(StreamConnection connection) {
                AjpClientProvider.this.handleConnected(connection, listener, uri, ssl, (Pool<ByteBuffer>)bufferPool, options);
            }
        };
        IoFuture.Notifier<StreamConnection, Object> notifier = new IoFuture.Notifier<StreamConnection, Object>(){

            public void notify(IoFuture<? extends StreamConnection> ioFuture, Object o) {
                if (ioFuture.getStatus() == IoFuture.Status.FAILED) {
                    listener.failed(ioFuture.getException());
                }
            }
        };
        if (bindAddress == null) {
            worker.openStreamConnection((SocketAddress)new InetSocketAddress(uri.getHost(), uri.getPort() == -1 ? 8009 : uri.getPort()), (ChannelListener)openListener, options).addNotifier((IoFuture.Notifier)notifier, null);
        } else {
            worker.openStreamConnection((SocketAddress)bindAddress, (SocketAddress)new InetSocketAddress(uri.getHost(), uri.getPort() == -1 ? 8009 : uri.getPort()), (ChannelListener)openListener, null, options).addNotifier((IoFuture.Notifier)notifier, null);
        }
    }

    @Override
    public void connect(final ClientCallback<ClientConnection> listener, InetSocketAddress bindAddress, final URI uri, XnioIoThread ioThread, final XnioSsl ssl, final Pool<ByteBuffer> bufferPool, final OptionMap options) {
        ChannelListener<StreamConnection> openListener = new ChannelListener<StreamConnection>(){

            public void handleEvent(StreamConnection connection) {
                AjpClientProvider.this.handleConnected(connection, listener, uri, ssl, (Pool<ByteBuffer>)bufferPool, options);
            }
        };
        IoFuture.Notifier<StreamConnection, Object> notifier = new IoFuture.Notifier<StreamConnection, Object>(){

            public void notify(IoFuture<? extends StreamConnection> ioFuture, Object o) {
                if (ioFuture.getStatus() == IoFuture.Status.FAILED) {
                    listener.failed(ioFuture.getException());
                }
            }
        };
        if (bindAddress == null) {
            ioThread.openStreamConnection((SocketAddress)new InetSocketAddress(uri.getHost(), uri.getPort() == -1 ? 8009 : uri.getPort()), (ChannelListener)openListener, options).addNotifier((IoFuture.Notifier)notifier, null);
        } else {
            ioThread.openStreamConnection((SocketAddress)bindAddress, (SocketAddress)new InetSocketAddress(uri.getHost(), uri.getPort() == -1 ? 8009 : uri.getPort()), (ChannelListener)openListener, null, options).addNotifier((IoFuture.Notifier)notifier, null);
        }
    }

    private void handleConnected(StreamConnection connection, ClientCallback<ClientConnection> listener, URI uri, XnioSsl ssl, Pool<ByteBuffer> bufferPool, OptionMap options) {
        ClientStatisticsImpl clientStatistics;
        if (options.get(UndertowOptions.ENABLE_STATISTICS, false)) {
            clientStatistics = new ClientStatisticsImpl();
            connection.getSinkChannel().setConduit((StreamSinkConduit)new BytesSentStreamSinkConduit(connection.getSinkChannel().getConduit(), new ByteActivityCallback(){

                @Override
                public void activity(long bytes) {
                    clientStatistics.written = clientStatistics.written + bytes;
                }
            }));
            connection.getSourceChannel().setConduit((StreamSourceConduit)new BytesReceivedStreamSourceConduit(connection.getSourceChannel().getConduit(), new ByteActivityCallback(){

                @Override
                public void activity(long bytes) {
                    clientStatistics.read = clientStatistics.read + bytes;
                }
            }));
        } else {
            clientStatistics = null;
        }
        listener.completed(new AjpClientConnection(new AjpClientChannel(connection, bufferPool, options), options, bufferPool, clientStatistics));
    }

    private class ClientStatisticsImpl
    implements ClientStatistics {
        private long requestCount;
        private long read;
        private long written;

        private ClientStatisticsImpl() {
        }

        @Override
        public long getRequests() {
            return this.requestCount;
        }

        @Override
        public long getRead() {
            return this.read;
        }

        @Override
        public long getWritten() {
            return this.written;
        }

        @Override
        public void reset() {
            this.read = 0L;
            this.written = 0L;
            this.requestCount = 0L;
        }
    }
}

