/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.host.controller.logging.HostControllerLogger;
import org.jboss.dmr.ModelNode;

public class ServerRemoveHandler
extends AbstractRemoveStepHandler {
    public static final String OPERATION_NAME = "remove";
    public static final ServerRemoveHandler INSTANCE = new ServerRemoveHandler();

    private ServerRemoveHandler() {
    }

    protected void performRemove(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        String socketBindingGroupOverride = model.hasDefined("socket-binding-group") ? model.get("socket-binding-group").asString() : null;
        super.performRemove(context, operation, model);
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String group = model.get("group").asString();
        final String serverName = address.getLastElement().getValue();
        PathAddress running = address.subAddress(0, 1).append(new PathElement[]{PathElement.pathElement((String)"server", (String)serverName)});
        ModelNode runningServerRemove = new ModelNode();
        runningServerRemove.get("operation").set(OPERATION_NAME);
        runningServerRemove.get("address").set(running.toModelNode());
        context.addStep(runningServerRemove, new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                context.removeResource(PathAddress.EMPTY_ADDRESS);
            }
        }, OperationContext.Stage.MODEL, true);
        ModelNode verifyOp = new ModelNode();
        verifyOp.get("operation").set("verify-running-server");
        verifyOp.get("address").add("host", address.getElement(0).getValue());
        context.addStep(verifyOp, new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                PathAddress serverAddress = PathAddress.EMPTY_ADDRESS.append(new PathElement[]{PathElement.pathElement((String)"server", (String)serverName)});
                ProxyController controller = context.getResourceRegistration().getProxyController(serverAddress);
                if (controller != null) {
                    context.getFailureDescription().set(HostControllerLogger.ROOT_LOGGER.serverStillRunning(serverName));
                }
            }
        }, OperationContext.Stage.RUNTIME);
    }

    protected boolean requiresRuntime(OperationContext context) {
        return false;
    }
}

