/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.impl;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.KeySpec;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactorySpi;
import org.wildfly.security.password.impl.AbstractPasswordImpl;
import org.wildfly.security.password.impl.BCryptPasswordImpl;
import org.wildfly.security.password.impl.BSDUnixDESCryptPasswordImpl;
import org.wildfly.security.password.impl.ClearPasswordImpl;
import org.wildfly.security.password.impl.DigestPasswordImpl;
import org.wildfly.security.password.impl.OneTimePasswordImpl;
import org.wildfly.security.password.impl.SaltedSimpleDigestPasswordImpl;
import org.wildfly.security.password.impl.ScramDigestPasswordImpl;
import org.wildfly.security.password.impl.SimpleDigestPasswordImpl;
import org.wildfly.security.password.impl.SunUnixMD5CryptPasswordImpl;
import org.wildfly.security.password.impl.UnixDESCryptPasswordImpl;
import org.wildfly.security.password.impl.UnixMD5CryptPasswordImpl;
import org.wildfly.security.password.impl.UnixSHACryptPasswordImpl;
import org.wildfly.security.password.interfaces.BCryptPassword;
import org.wildfly.security.password.interfaces.BSDUnixDESCryptPassword;
import org.wildfly.security.password.interfaces.ClearPassword;
import org.wildfly.security.password.interfaces.DigestPassword;
import org.wildfly.security.password.interfaces.OneTimePassword;
import org.wildfly.security.password.interfaces.SaltedSimpleDigestPassword;
import org.wildfly.security.password.interfaces.ScramDigestPassword;
import org.wildfly.security.password.interfaces.SimpleDigestPassword;
import org.wildfly.security.password.interfaces.SunUnixMD5CryptPassword;
import org.wildfly.security.password.interfaces.UnixDESCryptPassword;
import org.wildfly.security.password.interfaces.UnixMD5CryptPassword;
import org.wildfly.security.password.interfaces.UnixSHACryptPassword;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.password.spec.DigestPasswordSpec;
import org.wildfly.security.password.spec.EncryptablePasswordSpec;
import org.wildfly.security.password.spec.HashPasswordSpec;
import org.wildfly.security.password.spec.IteratedSaltedHashPasswordSpec;
import org.wildfly.security.password.spec.OneTimePasswordSpec;
import org.wildfly.security.password.spec.SaltedHashPasswordSpec;

public final class PasswordFactorySpiImpl
extends PasswordFactorySpi {
    @Override
    protected Password engineGeneratePassword(String algorithm, KeySpec keySpec) throws InvalidKeySpecException {
        switch (algorithm) {
            case "clear": {
                if (keySpec instanceof ClearPasswordSpec) {
                    return new ClearPasswordImpl((char[])((ClearPasswordSpec)keySpec).getEncodedPassword().clone());
                }
                if (!(keySpec instanceof EncryptablePasswordSpec)) break;
                return new ClearPasswordImpl((char[])((EncryptablePasswordSpec)keySpec).getPassword().clone());
            }
            case "bcrypt": {
                if (keySpec instanceof IteratedSaltedHashPasswordSpec) {
                    try {
                        return new BCryptPasswordImpl((IteratedSaltedHashPasswordSpec)keySpec);
                    }
                    catch (IllegalArgumentException | NullPointerException e) {
                        throw new InvalidKeySpecException(e);
                    }
                }
                if (keySpec instanceof SaltedHashPasswordSpec) {
                    try {
                        return new BCryptPasswordImpl((SaltedHashPasswordSpec)keySpec);
                    }
                    catch (IllegalArgumentException | NullPointerException e) {
                        throw new InvalidKeySpecException(e);
                    }
                }
                if (keySpec instanceof ClearPasswordSpec) {
                    try {
                        return new BCryptPasswordImpl((ClearPasswordSpec)keySpec);
                    }
                    catch (IllegalArgumentException | NullPointerException e) {
                        throw new InvalidKeySpecException(e);
                    }
                }
                if (!(keySpec instanceof EncryptablePasswordSpec)) break;
                try {
                    return new BCryptPasswordImpl((EncryptablePasswordSpec)keySpec);
                }
                catch (IllegalArgumentException | NullPointerException e) {
                    throw new InvalidKeySpecException(e);
                }
            }
            case "crypt-md5": {
                if (keySpec instanceof SaltedHashPasswordSpec) {
                    try {
                        return new UnixMD5CryptPasswordImpl((SaltedHashPasswordSpec)keySpec);
                    }
                    catch (IllegalArgumentException | NullPointerException e) {
                        throw new InvalidKeySpecException(e);
                    }
                }
                if (keySpec instanceof ClearPasswordSpec) {
                    try {
                        return new UnixMD5CryptPasswordImpl((ClearPasswordSpec)keySpec);
                    }
                    catch (IllegalArgumentException | NullPointerException | NoSuchAlgorithmException e) {
                        throw new InvalidKeySpecException(e);
                    }
                }
                if (!(keySpec instanceof EncryptablePasswordSpec)) break;
                try {
                    return new UnixMD5CryptPasswordImpl((EncryptablePasswordSpec)keySpec);
                }
                catch (IllegalArgumentException | NullPointerException | NoSuchAlgorithmException e) {
                    throw new InvalidKeySpecException(e);
                }
            }
            case "sun-crypt-md5": 
            case "sun-crypt-md5-bare-salt": {
                if (keySpec instanceof IteratedSaltedHashPasswordSpec) {
                    try {
                        return new SunUnixMD5CryptPasswordImpl(algorithm, (IteratedSaltedHashPasswordSpec)keySpec);
                    }
                    catch (IllegalArgumentException | NullPointerException e) {
                        throw new InvalidKeySpecException(e);
                    }
                }
                if (keySpec instanceof SaltedHashPasswordSpec) {
                    try {
                        return new SunUnixMD5CryptPasswordImpl(algorithm, (SaltedHashPasswordSpec)keySpec);
                    }
                    catch (IllegalArgumentException | NullPointerException e) {
                        throw new InvalidKeySpecException(e);
                    }
                }
                if (keySpec instanceof ClearPasswordSpec) {
                    try {
                        return new SunUnixMD5CryptPasswordImpl((ClearPasswordSpec)keySpec);
                    }
                    catch (IllegalArgumentException | NullPointerException | NoSuchAlgorithmException e) {
                        throw new InvalidKeySpecException(e);
                    }
                }
                if (!(keySpec instanceof EncryptablePasswordSpec)) break;
                try {
                    return new SunUnixMD5CryptPasswordImpl(algorithm, (EncryptablePasswordSpec)keySpec);
                }
                catch (IllegalArgumentException | NullPointerException | NoSuchAlgorithmException e) {
                    throw new InvalidKeySpecException(e);
                }
            }
            case "crypt-sha-256": 
            case "crypt-sha-512": {
                if (keySpec instanceof IteratedSaltedHashPasswordSpec) {
                    try {
                        return new UnixSHACryptPasswordImpl(algorithm, (IteratedSaltedHashPasswordSpec)keySpec);
                    }
                    catch (IllegalArgumentException | NullPointerException e) {
                        throw new InvalidKeySpecException(e);
                    }
                }
                if (keySpec instanceof SaltedHashPasswordSpec) {
                    try {
                        return new UnixSHACryptPasswordImpl(algorithm, (SaltedHashPasswordSpec)keySpec);
                    }
                    catch (IllegalArgumentException | NullPointerException e) {
                        throw new InvalidKeySpecException(e);
                    }
                }
                if (keySpec instanceof ClearPasswordSpec) {
                    try {
                        return new UnixSHACryptPasswordImpl(algorithm, (ClearPasswordSpec)keySpec);
                    }
                    catch (IllegalArgumentException | NullPointerException | NoSuchAlgorithmException e) {
                        throw new InvalidKeySpecException(e);
                    }
                }
                if (!(keySpec instanceof EncryptablePasswordSpec)) break;
                try {
                    return new UnixSHACryptPasswordImpl(algorithm, (EncryptablePasswordSpec)keySpec);
                }
                catch (IllegalArgumentException | NullPointerException | NoSuchAlgorithmException e) {
                    throw new InvalidKeySpecException(e);
                }
            }
            case "digest-md5": 
            case "digest-sha": 
            case "digest-sha-256": 
            case "digest-sha-384": 
            case "digest-sha-512": {
                if (keySpec instanceof DigestPasswordSpec) {
                    return new DigestPasswordImpl(algorithm, (DigestPasswordSpec)keySpec);
                }
                if (!(keySpec instanceof EncryptablePasswordSpec)) break;
                return new DigestPasswordImpl(algorithm, (EncryptablePasswordSpec)keySpec);
            }
            case "simple-digest-md2": 
            case "simple-digest-md5": 
            case "simple-digest-sha-1": 
            case "simple-digest-sha-256": 
            case "simple-digest-sha-384": 
            case "simple-digest-sha-512": {
                if (keySpec instanceof HashPasswordSpec) {
                    try {
                        return new SimpleDigestPasswordImpl(algorithm, (HashPasswordSpec)keySpec);
                    }
                    catch (IllegalArgumentException | NullPointerException e) {
                        throw new InvalidKeySpecException(e);
                    }
                }
                if (keySpec instanceof ClearPasswordSpec) {
                    try {
                        return new SimpleDigestPasswordImpl(algorithm, (ClearPasswordSpec)keySpec);
                    }
                    catch (IllegalArgumentException | NullPointerException e) {
                        throw new InvalidKeySpecException(e);
                    }
                }
                if (!(keySpec instanceof EncryptablePasswordSpec)) break;
                try {
                    return new SimpleDigestPasswordImpl(algorithm, (EncryptablePasswordSpec)keySpec);
                }
                catch (IllegalArgumentException | NullPointerException e) {
                    throw new InvalidKeySpecException(e);
                }
            }
            case "password-salt-digest-md5": 
            case "password-salt-digest-sha-1": 
            case "password-salt-digest-sha-256": 
            case "password-salt-digest-sha-384": 
            case "password-salt-digest-sha-512": 
            case "salt-password-digest-md5": 
            case "salt-password-digest-sha-1": 
            case "salt-password-digest-sha-256": 
            case "salt-password-digest-sha-384": 
            case "salt-password-digest-sha-512": {
                if (keySpec instanceof SaltedHashPasswordSpec) {
                    try {
                        return new SaltedSimpleDigestPasswordImpl(algorithm, (SaltedHashPasswordSpec)keySpec);
                    }
                    catch (IllegalArgumentException | NullPointerException e) {
                        throw new InvalidKeySpecException(e);
                    }
                }
                if (keySpec instanceof ClearPasswordSpec) {
                    try {
                        return new SaltedSimpleDigestPasswordImpl(algorithm, (ClearPasswordSpec)keySpec);
                    }
                    catch (IllegalArgumentException | NullPointerException e) {
                        throw new InvalidKeySpecException(e);
                    }
                }
                if (!(keySpec instanceof EncryptablePasswordSpec)) break;
                try {
                    return new SaltedSimpleDigestPasswordImpl(algorithm, (EncryptablePasswordSpec)keySpec);
                }
                catch (IllegalArgumentException | NullPointerException e) {
                    throw new InvalidKeySpecException(e);
                }
            }
            case "crypt-des": {
                if (keySpec instanceof SaltedHashPasswordSpec) {
                    try {
                        return new UnixDESCryptPasswordImpl((SaltedHashPasswordSpec)keySpec);
                    }
                    catch (IllegalArgumentException | NullPointerException e) {
                        throw new InvalidKeySpecException(e);
                    }
                }
                if (keySpec instanceof ClearPasswordSpec) {
                    try {
                        return new UnixDESCryptPasswordImpl((ClearPasswordSpec)keySpec);
                    }
                    catch (IllegalArgumentException | NullPointerException e) {
                        throw new InvalidKeySpecException(e);
                    }
                }
                if (!(keySpec instanceof EncryptablePasswordSpec)) break;
                try {
                    return new UnixDESCryptPasswordImpl((EncryptablePasswordSpec)keySpec);
                }
                catch (IllegalArgumentException | NullPointerException | InvalidParameterSpecException e) {
                    throw new InvalidKeySpecException(e);
                }
            }
            case "bsd-crypt-des": {
                if (keySpec instanceof IteratedSaltedHashPasswordSpec) {
                    try {
                        return new BSDUnixDESCryptPasswordImpl((IteratedSaltedHashPasswordSpec)keySpec);
                    }
                    catch (IllegalArgumentException | NullPointerException e) {
                        throw new InvalidKeySpecException(e);
                    }
                }
                if (keySpec instanceof SaltedHashPasswordSpec) {
                    try {
                        return new BSDUnixDESCryptPasswordImpl((SaltedHashPasswordSpec)keySpec);
                    }
                    catch (IllegalArgumentException | NullPointerException e) {
                        throw new InvalidKeySpecException(e);
                    }
                }
                if (keySpec instanceof ClearPasswordSpec) {
                    try {
                        return new BSDUnixDESCryptPasswordImpl((ClearPasswordSpec)keySpec);
                    }
                    catch (IllegalArgumentException | NullPointerException e) {
                        throw new InvalidKeySpecException(e);
                    }
                }
                if (!(keySpec instanceof EncryptablePasswordSpec)) break;
                try {
                    return new BSDUnixDESCryptPasswordImpl((EncryptablePasswordSpec)keySpec);
                }
                catch (IllegalArgumentException | NullPointerException | InvalidParameterSpecException e) {
                    throw new InvalidKeySpecException(e);
                }
            }
            case "scram-sha-1": 
            case "scram-sha-256": 
            case "scram-sha-384": 
            case "scram-sha-512": {
                if (keySpec instanceof IteratedSaltedHashPasswordSpec) {
                    try {
                        return new ScramDigestPasswordImpl(algorithm, (IteratedSaltedHashPasswordSpec)keySpec);
                    }
                    catch (IllegalArgumentException | NullPointerException e) {
                        throw new InvalidKeySpecException(e);
                    }
                }
                if (keySpec instanceof SaltedHashPasswordSpec) {
                    try {
                        return new ScramDigestPasswordImpl(algorithm, (SaltedHashPasswordSpec)keySpec);
                    }
                    catch (IllegalArgumentException | NullPointerException e) {
                        throw new InvalidKeySpecException(e);
                    }
                }
                if (keySpec instanceof ClearPasswordSpec) {
                    try {
                        return new ScramDigestPasswordImpl(algorithm, (ClearPasswordSpec)keySpec);
                    }
                    catch (IllegalArgumentException | NullPointerException e) {
                        throw new InvalidKeySpecException(e);
                    }
                }
                if (!(keySpec instanceof EncryptablePasswordSpec)) break;
                try {
                    return new ScramDigestPasswordImpl(algorithm, (EncryptablePasswordSpec)keySpec);
                }
                catch (IllegalArgumentException | NullPointerException e) {
                    throw new InvalidKeySpecException(e);
                }
            }
            case "otp-md5": 
            case "otp-sha1": {
                if (!(keySpec instanceof OneTimePasswordSpec)) break;
                return new OneTimePasswordImpl(algorithm, (OneTimePasswordSpec)keySpec);
            }
        }
        throw ElytronMessages.log.invalidKeySpecUnknownAlgorithmOrIncompatiblePasswordSpec();
    }

    @Override
    protected <S extends KeySpec> S engineGetKeySpec(String algorithm, Password password, Class<S> keySpecType) throws InvalidKeySpecException {
        AbstractPasswordImpl abstractPassword;
        if (password instanceof AbstractPasswordImpl && algorithm.equals((abstractPassword = (AbstractPasswordImpl)password).getAlgorithm())) {
            return abstractPassword.getKeySpec(keySpecType);
        }
        throw new InvalidKeySpecException();
    }

    @Override
    protected boolean engineIsTranslatablePassword(String algorithm, Password password) {
        AbstractPasswordImpl abstractPassword;
        if (password instanceof AbstractPasswordImpl && algorithm.equals((abstractPassword = (AbstractPasswordImpl)password).getAlgorithm())) {
            return true;
        }
        switch (algorithm) {
            case "clear": {
                return password instanceof ClearPassword;
            }
            case "bcrypt": {
                return password instanceof BCryptPassword;
            }
            case "crypt-md5": {
                return password instanceof UnixMD5CryptPassword;
            }
            case "sun-crypt-md5": 
            case "sun-crypt-md5-bare-salt": {
                return password instanceof SunUnixMD5CryptPassword && algorithm.equals(password.getAlgorithm());
            }
            case "crypt-sha-256": 
            case "crypt-sha-512": {
                return password instanceof UnixSHACryptPassword && algorithm.equals(password.getAlgorithm());
            }
            case "digest-md5": 
            case "digest-sha": 
            case "digest-sha-256": 
            case "digest-sha-512": {
                return password instanceof DigestPassword && algorithm.equals(password.getAlgorithm());
            }
            case "simple-digest-md2": 
            case "simple-digest-md5": 
            case "simple-digest-sha-1": 
            case "simple-digest-sha-256": 
            case "simple-digest-sha-384": 
            case "simple-digest-sha-512": {
                return password instanceof SimpleDigestPassword && algorithm.equals(password.getAlgorithm());
            }
            case "password-salt-digest-md5": 
            case "password-salt-digest-sha-1": 
            case "password-salt-digest-sha-256": 
            case "password-salt-digest-sha-384": 
            case "password-salt-digest-sha-512": 
            case "salt-password-digest-md5": 
            case "salt-password-digest-sha-1": 
            case "salt-password-digest-sha-256": 
            case "salt-password-digest-sha-384": 
            case "salt-password-digest-sha-512": {
                return password instanceof SaltedSimpleDigestPassword && algorithm.equals(password.getAlgorithm());
            }
            case "crypt-des": {
                return password instanceof UnixDESCryptPassword;
            }
            case "bsd-crypt-des": {
                return password instanceof BSDUnixDESCryptPassword;
            }
            case "scram-sha-1": 
            case "scram-sha-256": {
                return password instanceof ScramDigestPassword && algorithm.equals(password.getAlgorithm());
            }
            case "otp-md5": 
            case "otp-sha1": {
                return password instanceof OneTimePassword && algorithm.equals(password.getAlgorithm());
            }
        }
        return false;
    }

    @Override
    protected Password engineTranslatePassword(String algorithm, Password password) throws InvalidKeyException {
        AbstractPasswordImpl abstractPassword;
        if (password instanceof AbstractPasswordImpl && algorithm.equals((abstractPassword = (AbstractPasswordImpl)password).getAlgorithm())) {
            return abstractPassword;
        }
        switch (algorithm) {
            case "clear": {
                if (password instanceof ClearPasswordImpl) {
                    return password;
                }
                if (!(password instanceof ClearPassword)) break;
                return new ClearPasswordImpl((ClearPassword)password);
            }
            case "bcrypt": {
                if (password instanceof BCryptPasswordImpl) {
                    return password;
                }
                if (!(password instanceof BCryptPassword)) break;
                return new BCryptPasswordImpl((BCryptPassword)password);
            }
            case "crypt-md5": {
                if (password instanceof UnixMD5CryptPasswordImpl) {
                    return password;
                }
                if (!(password instanceof UnixMD5CryptPassword)) break;
                return new UnixMD5CryptPasswordImpl((UnixMD5CryptPassword)password);
            }
            case "sun-crypt-md5": 
            case "sun-crypt-md5-bare-salt": {
                if (password instanceof SunUnixMD5CryptPasswordImpl && algorithm.equals(password.getAlgorithm())) {
                    return password;
                }
                if (!(password instanceof SunUnixMD5CryptPassword) || !algorithm.equals(password.getAlgorithm())) break;
                return new SunUnixMD5CryptPasswordImpl((SunUnixMD5CryptPassword)password);
            }
            case "crypt-sha-256": 
            case "crypt-sha-512": {
                if (password instanceof UnixSHACryptPasswordImpl && algorithm.equals(password.getAlgorithm())) {
                    return password;
                }
                if (!(password instanceof UnixSHACryptPassword) || !algorithm.equals(password.getAlgorithm())) break;
                return new UnixSHACryptPasswordImpl((UnixSHACryptPassword)password);
            }
            case "digest-md5": 
            case "digest-sha": 
            case "digest-sha-256": 
            case "digest-sha-512": {
                if (password instanceof DigestPasswordImpl && algorithm.equals(password.getAlgorithm())) {
                    return password;
                }
                if (!(password instanceof DigestPassword) || !algorithm.equals(password.getAlgorithm())) break;
                return new SimpleDigestPasswordImpl((SimpleDigestPassword)password);
            }
            case "simple-digest-md2": 
            case "simple-digest-md5": 
            case "simple-digest-sha-1": 
            case "simple-digest-sha-256": 
            case "simple-digest-sha-384": 
            case "simple-digest-sha-512": {
                if (password instanceof SimpleDigestPasswordImpl && algorithm.equals(password.getAlgorithm())) {
                    return password;
                }
                if (!(password instanceof SimpleDigestPassword) || !algorithm.equals(password.getAlgorithm())) break;
                return new SimpleDigestPasswordImpl((SimpleDigestPassword)password);
            }
            case "password-salt-digest-md5": 
            case "password-salt-digest-sha-1": 
            case "password-salt-digest-sha-256": 
            case "password-salt-digest-sha-384": 
            case "password-salt-digest-sha-512": 
            case "salt-password-digest-md5": 
            case "salt-password-digest-sha-1": 
            case "salt-password-digest-sha-256": 
            case "salt-password-digest-sha-384": 
            case "salt-password-digest-sha-512": {
                if (password instanceof SaltedSimpleDigestPasswordImpl && algorithm.equals(password.getAlgorithm())) {
                    return password;
                }
                if (!(password instanceof SaltedSimpleDigestPassword) || !algorithm.equals(password.getAlgorithm())) break;
                return new SaltedSimpleDigestPasswordImpl((SaltedSimpleDigestPassword)password);
            }
            case "crypt-des": {
                if (password instanceof UnixDESCryptPasswordImpl) {
                    return password;
                }
                if (!(password instanceof UnixDESCryptPassword)) break;
                return new UnixDESCryptPasswordImpl((UnixDESCryptPassword)password);
            }
            case "bsd-crypt-des": {
                if (password instanceof BSDUnixDESCryptPasswordImpl) {
                    return password;
                }
                if (!(password instanceof BSDUnixDESCryptPassword)) break;
                return new BSDUnixDESCryptPasswordImpl((BSDUnixDESCryptPassword)password);
            }
            case "scram-sha-1": 
            case "scram-sha-256": {
                if (password instanceof ScramDigestPasswordImpl && algorithm.equals(password.getAlgorithm())) {
                    return password;
                }
                if (!(password instanceof ScramDigestPassword) || !algorithm.equals(password.getAlgorithm())) break;
                return new ScramDigestPasswordImpl((ScramDigestPassword)password);
            }
            case "otp-md5": 
            case "otp-sha1": {
                if (password instanceof OneTimePasswordImpl && algorithm.equals(password.getAlgorithm())) {
                    return password;
                }
                if (!(password instanceof OneTimePassword) || !algorithm.equals(password.getAlgorithm())) break;
                return new OneTimePasswordImpl((OneTimePassword)password);
            }
        }
        throw ElytronMessages.log.invalidKeyUnknownUnknownPasswordTypeOrAlgorithm();
    }

    @Override
    protected boolean engineVerify(String algorithm, Password password, char[] guess) throws InvalidKeyException {
        AbstractPasswordImpl abstractPassword;
        if (password instanceof AbstractPasswordImpl && algorithm.equals((abstractPassword = (AbstractPasswordImpl)password).getAlgorithm())) {
            return abstractPassword.verify(guess);
        }
        throw new InvalidKeyException();
    }

    @Override
    protected <S extends KeySpec> boolean engineConvertibleToKeySpec(String algorithm, Password password, Class<S> keySpecType) {
        AbstractPasswordImpl abstractPassword;
        if (password instanceof AbstractPasswordImpl && algorithm.equals((abstractPassword = (AbstractPasswordImpl)password).getAlgorithm())) {
            return abstractPassword.convertibleTo(keySpecType);
        }
        return false;
    }
}

