/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.scram;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Random;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.security.sasl.SaslException;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.TwoWayPassword;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.sasl.util.StringPrep;
import org.wildfly.security.util.ByteIterator;
import org.wildfly.security.util.ByteStringBuilder;

class ScramUtil {
    private static final byte[] randomCharDictionary;

    ScramUtil() {
    }

    public static byte[] generateNonce(int length, Random random) {
        byte[] chars = new byte[length];
        for (int i = 0; i < length; ++i) {
            chars[i] = randomCharDictionary[random.nextInt(93)];
        }
        return chars;
    }

    public static byte[] generateSalt(int length, Random random) {
        byte[] bytes = new byte[length];
        random.nextBytes(bytes);
        return bytes;
    }

    public static int parsePosInt(ByteIterator i) {
        int a;
        if (!i.hasNext()) {
            throw ElytronMessages.log.emptyNumber();
        }
        int c = i.next();
        if (c >= 49 && c <= 57) {
            a = c - 48;
        } else {
            throw ElytronMessages.log.invalidNumericCharacter();
        }
        while (i.hasNext()) {
            c = i.next();
            if (c >= 48 && c <= 57) {
                if ((a = (a << 3) + (a << 1) + (c - 48)) >= 0) continue;
                throw ElytronMessages.log.tooBigNumber();
            }
            throw ElytronMessages.log.invalidNumericCharacter();
        }
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] calculateHi(Mac mac, char[] password, byte[] salt, int saltOffs, int saltLen, int iterationCount) throws InvalidKeyException {
        try {
            byte[] h;
            ByteStringBuilder b = new ByteStringBuilder();
            StringPrep.encode(password, b, 8191L);
            mac.init(new SecretKeySpec(b.toArray(), mac.getAlgorithm()));
            mac.update(salt, saltOffs, saltLen);
            mac.update((byte)0);
            mac.update((byte)0);
            mac.update((byte)0);
            mac.update((byte)1);
            byte[] u = h = mac.doFinal();
            for (int i = 2; i <= iterationCount; ++i) {
                u = mac.doFinal(u);
                ScramUtil.xor(h, u);
            }
            byte[] byArray = h;
            return byArray;
        }
        finally {
            mac.reset();
        }
    }

    static void xor(byte[] hash, byte[] input) {
        assert (hash.length == input.length);
        for (int i = 0; i < hash.length; ++i) {
            int n = i;
            hash[n] = (byte)(hash[n] ^ input[i]);
        }
    }

    static char[] getTwoWayPasswordChars(String mechName, TwoWayPassword password) throws SaslException {
        if (password == null) {
            throw ElytronMessages.log.saslNoPasswordGiven(mechName);
        }
        try {
            PasswordFactory pf = PasswordFactory.getInstance(password.getAlgorithm());
            return pf.getKeySpec(password, ClearPasswordSpec.class).getEncodedPassword();
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw ElytronMessages.log.saslCannotGetTwoWayPasswordChars(mechName, e);
        }
    }

    static {
        int c;
        byte[] dict = new byte[93];
        int i = 0;
        for (c = 33; c < 44; c = (int)((byte)(c + 1))) {
            dict[i++] = c;
        }
        for (c = 45; c < 127; c = (int)((byte)(c + 1))) {
            dict[i++] = c;
        }
        assert (i == dict.length);
        randomCharDictionary = dict;
    }
}

