/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.capability.registry;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.capability.registry.CapabilityContext;
import org.jboss.as.controller.capability.registry.RuntimeCapabilityRegistration;
import org.jboss.as.controller.capability.registry.RuntimeCapabilityRegistry;
import org.jboss.as.controller.capability.registry.RuntimeRequirementRegistration;
import org.jboss.msc.service.ServiceName;

public class DelegatingRuntimeCapabilityRegistry
implements RuntimeCapabilityRegistry {
    private final CapabilityRegistryDelegateProvider delegateProvider;

    public DelegatingRuntimeCapabilityRegistry(final RuntimeCapabilityRegistry delegate) {
        this(new CapabilityRegistryDelegateProvider(){

            @Override
            public RuntimeCapabilityRegistry getDelegateCapabilityRegistry() {
                return delegate;
            }
        });
    }

    public DelegatingRuntimeCapabilityRegistry(CapabilityRegistryDelegateProvider delegateProvider) {
        this.delegateProvider = delegateProvider;
    }

    @Override
    public void registerCapability(RuntimeCapabilityRegistration capability) {
        this.getDelegate().registerCapability(capability);
    }

    @Override
    public void registerAdditionalCapabilityRequirement(RuntimeRequirementRegistration requirementRegistration) {
        this.getDelegate().registerAdditionalCapabilityRequirement(requirementRegistration);
    }

    @Override
    public void removeCapabilityRequirement(RuntimeRequirementRegistration requirementRegistration) {
        this.getDelegate().removeCapabilityRequirement(requirementRegistration);
    }

    @Override
    public RuntimeCapabilityRegistration removeCapability(String capability, CapabilityContext context, PathAddress registrationPoint) {
        return (RuntimeCapabilityRegistration)this.getDelegate().removeCapability(capability, context, registrationPoint);
    }

    @Override
    public boolean hasCapability(String capabilityName, String dependentName, CapabilityContext context) {
        return this.getDelegate().hasCapability(capabilityName, dependentName, context);
    }

    @Override
    public <T> T getCapabilityRuntimeAPI(String capabilityName, CapabilityContext context, Class<T> apiType) {
        return this.getDelegate().getCapabilityRuntimeAPI(capabilityName, context, apiType);
    }

    @Override
    public ServiceName getCapabilityServiceName(String capabilityName, CapabilityContext context, Class<?> serviceType) {
        return this.getDelegate().getCapabilityServiceName(capabilityName, context, serviceType);
    }

    private RuntimeCapabilityRegistry getDelegate() {
        return this.delegateProvider.getDelegateCapabilityRegistry();
    }

    public static interface CapabilityRegistryDelegateProvider {
        public RuntimeCapabilityRegistry getDelegateCapabilityRegistry();
    }
}

