/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ConfigurationChangesCollector;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.access.AuthorizationResult;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.management._private.DomainManagementResolver;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ConfigurationChangeResourceDefinition
extends SimpleResourceDefinition {
    public static final SimpleAttributeDefinition MAX_HISTORY = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"max-history", (ModelType)ModelType.INT).setDefaultValue(new ModelNode(10))).build();
    public static final PathElement PATH = PathElement.pathElement((String)"service", (String)"configuration-changes");
    public static final ConfigurationChangeResourceDefinition INSTANCE = new ConfigurationChangeResourceDefinition();
    public static final String OPERATION_NAME = "list-changes";

    private ConfigurationChangeResourceDefinition() {
        super(new SimpleResourceDefinition.Parameters(PATH, DomainManagementResolver.getResolver("core", "management", "service", "configuration-changes")).setAddHandler((OperationStepHandler)new ConfigurationChangeResourceAddHandler()).setRemoveHandler((OperationStepHandler)new ConfigurationChangeResourceRemoveHandler()));
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        resourceRegistration.registerOperationHandler(ConfigurationChangesHandler.DEFINITION, (OperationStepHandler)ConfigurationChangesHandler.INSTANCE);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)MAX_HISTORY, null, (OperationStepHandler)new MaxHistoryWriteHandler((ConfigurationChangesCollector)ConfigurationChangesCollector.INSTANCE));
    }

    private static class ConfigurationChangesHandler
    extends AbstractRuntimeOnlyHandler {
        private static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("list-changes", DomainManagementResolver.getResolver("core", "management", "service", "configuration-changes")).setReplyType(ModelType.STRING).setRuntimeOnly().build();
        private static final ConfigurationChangesHandler INSTANCE = new ConfigurationChangesHandler((ConfigurationChangesCollector)ConfigurationChangesCollector.INSTANCE);
        private static final Set<Action.ActionEffect> ADDRESS_EFFECT = EnumSet.of(Action.ActionEffect.ADDRESS);
        private final ConfigurationChangesCollector collector;

        private ConfigurationChangesHandler(ConfigurationChangesCollector collector) {
            this.collector = collector;
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            if (this.collector != null) {
                ModelNode result = context.getResult().setEmptyList();
                for (ModelNode change : this.collector.getChanges()) {
                    ModelNode configurationChange = change.clone();
                    this.secureHistory(context, configurationChange);
                    result.add(configurationChange);
                }
            }
        }

        private void secureHistory(OperationContext context, ModelNode configurationChange) throws OperationFailedException {
            if (configurationChange.has("operations")) {
                List operations = configurationChange.get("operations").asList();
                ModelNode authorizedOperations = configurationChange.get("operations").setEmptyList();
                for (ModelNode operation : operations) {
                    authorizedOperations.add(this.secureOperation(context, operation));
                }
            }
        }

        private ModelNode secureOperation(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModelNode address = operation.get("address");
            ModelNode fakeOperation = new ModelNode();
            fakeOperation.get("operation").set("read-resource");
            fakeOperation.get("address").set(address);
            AuthorizationResult authResult = context.authorize(fakeOperation, ADDRESS_EFFECT);
            if (authResult.getDecision() == AuthorizationResult.Decision.PERMIT) {
                return this.secureOperationParameters(context, operation);
            }
            ModelNode securedOperation = new ModelNode();
            securedOperation.get("operation").set(operation.get("operation"));
            securedOperation.get("address").set(ControllerLogger.MGMT_OP_LOGGER.permissionDenied());
            return securedOperation;
        }

        private ModelNode secureOperationParameters(OperationContext context, ModelNode op) throws OperationFailedException {
            OperationEntry operationEntry;
            Set<Action.ActionEffect> effects;
            ModelNode operation = op.clone();
            if (context.authorize(operation, effects = this.getEffects(operationEntry = context.getRootResourceRegistration().getOperationEntry(PathAddress.pathAddress((ModelNode)operation.get("address")), operation.get("operation").asString()))).getDecision() == AuthorizationResult.Decision.PERMIT) {
                return operation;
            }
            ModelNode securedOperation = new ModelNode();
            securedOperation.get("operation").set(operation.get("operation"));
            securedOperation.get("address").set(operation.get("address"));
            return securedOperation;
        }

        private Set<Action.ActionEffect> getEffects(OperationEntry operationEntry) {
            HashSet<Action.ActionEffect> effects = new HashSet<Action.ActionEffect>(5);
            effects.add(Action.ActionEffect.ADDRESS);
            if (operationEntry != null) {
                effects.add(Action.ActionEffect.READ_RUNTIME);
                if (!operationEntry.getFlags().contains(OperationEntry.Flag.RUNTIME_ONLY)) {
                    effects.add(Action.ActionEffect.READ_CONFIG);
                }
                if (!operationEntry.getFlags().contains(OperationEntry.Flag.READ_ONLY)) {
                    effects.add(Action.ActionEffect.WRITE_RUNTIME);
                    if (!operationEntry.getFlags().contains(OperationEntry.Flag.RUNTIME_ONLY)) {
                        effects.add(Action.ActionEffect.WRITE_CONFIG);
                    }
                }
            }
            return effects;
        }
    }

    private static class MaxHistoryWriteHandler
    extends AbstractWriteAttributeHandler<Integer> {
        private static final MaxHistoryWriteHandler INSTANCE = new MaxHistoryWriteHandler((ConfigurationChangesCollector)ConfigurationChangesCollector.INSTANCE);
        private final ConfigurationChangesCollector collector;

        private MaxHistoryWriteHandler(ConfigurationChangesCollector collector) {
            super(new AttributeDefinition[0]);
            this.collector = collector;
        }

        protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Integer> handbackHolder) throws OperationFailedException {
            MAX_HISTORY.validateAndSet(operation, context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS).getModel());
            this.collector.setMaxHistory(resolvedValue.asInt());
            return true;
        }

        protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Integer handback) throws OperationFailedException {
            MAX_HISTORY.validateAndSet(operation, context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS).getModel());
            this.collector.setMaxHistory(valueToRestore.asInt());
        }
    }

    private static class ConfigurationChangeResourceRemoveHandler
    extends AbstractRemoveStepHandler {
        public ConfigurationChangeResourceRemoveHandler() {
            ConfigurationChangesCollector.INSTANCE.deactivate();
        }
    }

    private static class ConfigurationChangeResourceAddHandler
    extends AbstractAddStepHandler {
        public ConfigurationChangeResourceAddHandler() {
            super(new AttributeDefinition[]{MAX_HISTORY});
        }

        protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            super.populateModel(context, operation, resource);
            ModelNode maxHistory = MAX_HISTORY.resolveModelAttribute(context, operation);
            MAX_HISTORY.validateAndSet(operation, context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS).getModel());
            ConfigurationChangesCollector.INSTANCE.setMaxHistory(maxHistory.asInt());
        }
    }
}

