/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.metadata;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.patching.IoUtils;
import org.jboss.as.patching.installation.InstalledIdentity;
import org.jboss.as.patching.metadata.Patch;
import org.jboss.as.patching.metadata.PatchMetadataResolver;
import org.jboss.as.patching.metadata.PatchXmlUtils;
import org.jboss.as.patching.metadata.PatchXml_1_0;
import org.jboss.as.patching.metadata.RollbackPatch;
import org.jboss.as.patching.metadata.RollbackPatchXml_1_0;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLMapper;

public class PatchXml {
    public static final String PATCH_XML = "patch.xml";
    public static final String ROLLBACK_XML = "rollback.xml";
    private static final XMLMapper MAPPER = XMLMapper.Factory.create();
    private static final PatchXml_1_0 XML1_0 = new PatchXml_1_0();
    private static final RollbackPatchXml_1_0 ROLLBACK_1_0 = new RollbackPatchXml_1_0();
    private static final XMLInputFactory INPUT_FACTORY = XMLInputFactory.newInstance();
    private static final XMLOutputFactory OUTPUT_FACTORY = XMLOutputFactory.newFactory();

    private PatchXml() {
    }

    public static void marshal(Writer writer, Patch patch) throws XMLStreamException {
        XMLOutputFactory outputFactory = OUTPUT_FACTORY;
        XMLStreamWriter streamWriter = outputFactory.createXMLStreamWriter(writer);
        PatchXml_1_0 xmlWriter = XML1_0;
        MAPPER.deparseDocument((XMLElementWriter)xmlWriter, (Object)patch, streamWriter);
        streamWriter.close();
    }

    public static void marshal(OutputStream os, Patch patch) throws XMLStreamException {
        PatchXml.marshal(os, patch, (XMLElementWriter<? extends Patch>)(patch instanceof RollbackPatch ? ROLLBACK_1_0 : XML1_0));
    }

    public static void marshal(OutputStream os, RollbackPatch patch) throws XMLStreamException {
        PatchXml.marshal(os, patch, ROLLBACK_1_0);
    }

    protected static void marshal(OutputStream os, Patch patch, XMLElementWriter<? extends Patch> xmlWriter) throws XMLStreamException {
        XMLOutputFactory outputFactory = OUTPUT_FACTORY;
        XMLStreamWriter streamWriter = outputFactory.createXMLStreamWriter(os);
        MAPPER.deparseDocument(xmlWriter, (Object)patch, streamWriter);
        streamWriter.close();
    }

    public static PatchMetadataResolver parse(InputStream stream) throws XMLStreamException {
        return PatchXml.parse(stream, null);
    }

    public static PatchMetadataResolver parse(InputStream stream, InstalledIdentity originalIdentity) throws XMLStreamException {
        return PatchXml.parse(PatchXml.getXMLInputFactory().createXMLStreamReader(stream), originalIdentity);
    }

    public static PatchMetadataResolver parse(Reader stream) throws XMLStreamException {
        return PatchXml.parse(stream, null);
    }

    public static PatchMetadataResolver parse(Reader reader, InstalledIdentity originalIdentity) throws XMLStreamException {
        return PatchXml.parse(PatchXml.getXMLInputFactory().createXMLStreamReader(reader), originalIdentity);
    }

    private static XMLInputFactory getXMLInputFactory() throws XMLStreamException {
        XMLInputFactory inputFactory = INPUT_FACTORY;
        PatchXml.setIfSupported(inputFactory, "javax.xml.stream.isValidating", Boolean.FALSE);
        PatchXml.setIfSupported(inputFactory, "javax.xml.stream.supportDTD", Boolean.FALSE);
        return inputFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static PatchMetadataResolver parse(XMLStreamReader reader, InstalledIdentity originalIdentity) throws XMLStreamException {
        try {
            Result result = new Result(originalIdentity);
            MAPPER.parseDocument(result, reader);
            PatchMetadataResolver patchMetadataResolver = (PatchMetadataResolver)result.getResult();
            return patchMetadataResolver;
        }
        finally {
            reader.close();
        }
    }

    public static PatchMetadataResolver parse(File patchXml) throws IOException, XMLStreamException {
        return PatchXml.parse(patchXml, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PatchMetadataResolver parse(File patchXml, InstalledIdentity original) throws IOException, XMLStreamException {
        FileInputStream is = new FileInputStream(patchXml);
        try {
            PatchMetadataResolver patchMetadataResolver = PatchXml.parse(is, original);
            return patchMetadataResolver;
        }
        finally {
            IoUtils.safeClose(is);
        }
    }

    private static void setIfSupported(XMLInputFactory inputFactory, String property, Object value) {
        if (inputFactory.isPropertySupported(property)) {
            inputFactory.setProperty(property, value);
        }
    }

    static {
        MAPPER.registerRootElement(new QName(Namespace.PATCH_1_0.getNamespace(), PatchXmlUtils.Element.PATCH.name), (XMLElementReader)XML1_0);
        MAPPER.registerRootElement(new QName(Namespace.PATCH_1_1.getNamespace(), PatchXmlUtils.Element.PATCH.name), (XMLElementReader)XML1_0);
        MAPPER.registerRootElement(new QName(Namespace.ROLLBACK_1_0.getNamespace(), PatchXmlUtils.Element.PATCH.name), (XMLElementReader)ROLLBACK_1_0);
        MAPPER.registerRootElement(new QName(Namespace.ROLLBACK_1_1.getNamespace(), PatchXmlUtils.Element.PATCH.name), (XMLElementReader)ROLLBACK_1_0);
    }

    public static class Result<T> {
        private T result;
        private final InstalledIdentity originalIdentity;

        Result() {
            this(null);
        }

        Result(InstalledIdentity originalIdentity) {
            this.originalIdentity = originalIdentity;
        }

        public T getResult() {
            return this.result;
        }

        public void setResult(T result) {
            this.result = result;
        }

        public InstalledIdentity getOriginalIdentity() {
            return this.originalIdentity;
        }
    }

    public static enum Namespace {
        PATCH_1_0("urn:jboss:patch:1.0"),
        PATCH_1_1("urn:jboss:patch:1.1"),
        ROLLBACK_1_0("urn:jboss:patch:rollback:1.0"),
        ROLLBACK_1_1("urn:jboss:patch:rollback:1.1"),
        PATCH_BUNDLE_1_0("urn:jboss:patch:bundle:1.0"),
        UNKNOWN(null);

        private final String namespace;
        static Map<String, Namespace> elements;

        private Namespace(String namespace) {
            this.namespace = namespace;
        }

        public String getNamespace() {
            return this.namespace;
        }

        static Namespace forUri(String name) {
            Namespace element = elements.get(name);
            return element == null ? UNKNOWN : element;
        }

        static {
            elements = new HashMap<String, Namespace>();
            for (Namespace element : Namespace.values()) {
                if (element == UNKNOWN) continue;
                elements.put(element.namespace, element);
            }
        }
    }
}

