/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming.deployment;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.naming.logging.NamingLogger;
import org.jboss.as.naming.service.BinderService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class RuntimeBindReleaseService
implements Service<References> {
    private final References references = new References();

    public References getValue() throws IllegalStateException, IllegalArgumentException {
        return this.references;
    }

    public void start(StartContext context) throws StartException {
    }

    public void stop(StopContext context) {
        this.references.releaseAll();
    }

    public static class References {
        private volatile List<BinderService> services;

        private References() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(BinderService service) {
            References references = this;
            synchronized (references) {
                if (this.services == null) {
                    this.services = new ArrayList<BinderService>();
                }
                this.services.add(service);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean contains(ServiceName serviceName) {
            References references = this;
            synchronized (references) {
                if (this.services != null) {
                    for (BinderService service : this.services) {
                        if (!serviceName.equals(service.getServiceName())) continue;
                        return true;
                    }
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void releaseAll() {
            References references = this;
            synchronized (references) {
                if (this.services != null) {
                    for (BinderService service : this.services) {
                        try {
                            service.release();
                        }
                        catch (Throwable e) {
                            NamingLogger.ROOT_LOGGER.failedToReleaseBinderService(e);
                        }
                    }
                    this.services = null;
                }
            }
        }
    }
}

