/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.installation;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.jboss.as.patching.DirectoryStructure;
import org.jboss.as.patching.IoUtils;
import org.jboss.as.patching.installation.InstallationManager;
import org.jboss.as.patching.installation.LayerInfo;
import org.jboss.as.patching.installation.PatchableTarget;
import org.jboss.as.patching.metadata.Patch;
import org.jboss.as.patching.runner.PatchUtils;

class MutableTargetImpl
implements InstallationManager.MutablePatchingTarget {
    private final DirectoryStructure structure;
    private final PatchableTarget.TargetInfo current;
    private final List<String> patchIds;
    private final Properties properties;
    private String cumulativeID;
    private boolean modified = false;
    private String version;

    MutableTargetImpl(PatchableTarget.TargetInfo current) {
        this(current, null);
    }

    MutableTargetImpl(PatchableTarget.TargetInfo current, String currentVersion) {
        this.current = current;
        this.structure = current.getDirectoryStructure();
        this.cumulativeID = current.getCumulativePatchID();
        this.patchIds = new ArrayList<String>(current.getPatchIDs());
        this.properties = new Properties(current.getProperties());
        this.version = currentVersion;
    }

    @Override
    public boolean isApplied(String patchId) {
        if (this.cumulativeID.equals(patchId)) {
            return true;
        }
        return this.patchIds.contains(patchId);
    }

    @Override
    public void rollback(String patchId) {
        if (!this.patchIds.remove(patchId)) {
            if (patchId.equals(this.cumulativeID)) {
                this.cumulativeID = "base";
            } else {
                throw new IllegalStateException("cannot rollback not-applied patch " + patchId);
            }
        }
        this.modified = true;
    }

    @Override
    public void apply(String patchId, Patch.PatchType patchType) {
        if (patchType == Patch.PatchType.CUMULATIVE) {
            if (!this.patchIds.isEmpty()) {
                throw new IllegalStateException("cannot apply cumulative patch if there are other patches applied " + this.patchIds);
            }
            this.cumulativeID = patchId;
        } else {
            this.patchIds.add(0, patchId);
        }
        this.modified = true;
    }

    @Override
    public String getCumulativePatchID() {
        return this.current.getCumulativePatchID();
    }

    @Override
    public List<String> getPatchIDs() {
        return this.current.getPatchIDs();
    }

    @Override
    public Properties getProperties() {
        return this.current.getProperties();
    }

    @Override
    public DirectoryStructure getDirectoryStructure() {
        return this.structure;
    }

    public String getVersion() {
        return this.version;
    }

    public void setResultingVersion(String version) {
        this.version = version;
    }

    protected Properties getMutableProperties() {
        return this.properties;
    }

    protected void persist() throws IOException {
        if (this.modified) {
            this.persist(this.cumulativeID, this.patchIds, this.properties);
        }
    }

    protected void restore() throws IOException {
        if (this.modified) {
            this.persist(this.current.getCumulativePatchID(), this.current.getPatchIDs(), this.current.getProperties());
        }
    }

    protected void persist(String cumulativeID, List<String> patches, Properties properties) throws IOException {
        assert (cumulativeID != null);
        IoUtils.mkdir(this.structure.getInstallationInfo().getParentFile(), new String[0]);
        ArrayList<String> consolidate = new ArrayList<String>();
        consolidate.addAll(patches);
        if (!"base".equals(cumulativeID)) {
            consolidate.add(cumulativeID);
        }
        if (this.structure.getModuleRoot() != null) {
            File overlays = new File(this.structure.getModuleRoot(), ".overlays");
            File refs = new File(overlays, ".overlays");
            PatchUtils.writeRefs(refs, consolidate);
        }
        properties.put("cumulative-patch-id", cumulativeID);
        properties.put("patches", PatchUtils.asString(patches));
        if (this.version != null) {
            properties.put("current-version", this.version);
        }
        PatchUtils.writeProperties(this.structure.getInstallationInfo(), properties);
    }

    @Override
    public PatchableTarget.TargetInfo getModifiedState() {
        if (this.modified) {
            return new LayerInfo.TargetInfoImpl(this.properties, this.cumulativeID, this.patchIds, this.structure);
        }
        return this.current;
    }
}

