/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.AbstractAttributeDefinitionBuilder;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.MapAttributeDefinition;
import org.jboss.as.controller.ObjectListAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PrimitiveListAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleListAttributeDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.MinMaxValidator;
import org.jboss.as.controller.operations.validation.ObjectTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ObjectTypeAttributeDefinition
extends SimpleAttributeDefinition {
    private final AttributeDefinition[] valueTypes;
    private final String suffix;

    protected ObjectTypeAttributeDefinition(Builder builder) {
        this(builder, builder.suffix, builder.valueTypes);
    }

    protected ObjectTypeAttributeDefinition(AbstractAttributeDefinitionBuilder<?, ? extends ObjectTypeAttributeDefinition> builder, String suffix, AttributeDefinition[] valueTypes) {
        super((AbstractAttributeDefinitionBuilder<?, ? extends SimpleAttributeDefinition>)builder);
        this.valueTypes = valueTypes;
        this.suffix = suffix == null ? "" : suffix;
    }

    @Override
    protected ModelNode convertParameterExpressions(ModelNode parameter) {
        ModelNode result = parameter;
        if (parameter.isDefined()) {
            boolean changeMade = false;
            ModelNode updated = new ModelNode().setEmptyObject();
            for (AttributeDefinition ad : this.valueTypes) {
                String fieldName = ad.getName();
                if (!parameter.has(fieldName)) continue;
                ModelNode orig = parameter.get(fieldName);
                if (!orig.isDefined()) {
                    updated.get(fieldName);
                    continue;
                }
                ModelNode converted = ad.convertParameterExpressions(orig);
                changeMade |= !orig.equals(converted);
                updated.get(fieldName).set(converted);
            }
            if (changeMade) {
                result = updated;
            }
        }
        return result;
    }

    AttributeDefinition[] getValueTypes() {
        return this.valueTypes;
    }

    @Override
    public ModelNode parse(String value, XMLStreamReader reader) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addCapabilityRequirements(OperationContext context, ModelNode attributeValue) {
        if (attributeValue.isDefined()) {
            for (AttributeDefinition fieldType : this.valueTypes) {
                if (!attributeValue.hasDefined(fieldType.getName())) continue;
                fieldType.addCapabilityRequirements(context, attributeValue.get(fieldType.getName()));
            }
        }
    }

    @Override
    public void removeCapabilityRequirements(OperationContext context, ModelNode attributeValue) {
        if (attributeValue.isDefined()) {
            for (AttributeDefinition fieldType : this.valueTypes) {
                if (!attributeValue.hasDefined(fieldType.getName())) continue;
                fieldType.removeCapabilityRequirements(context, attributeValue.get(fieldType.getName()));
            }
        }
    }

    @Override
    public ModelNode addResourceAttributeDescription(ResourceBundle bundle, String prefix, ModelNode resourceDescription) {
        ModelNode result = super.addResourceAttributeDescription(bundle, prefix, resourceDescription);
        this.addValueTypeDescription(result, prefix, bundle, null, null);
        return result;
    }

    @Override
    public ModelNode addOperationParameterDescription(ModelNode resourceDescription, String operationName, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle) {
        ModelNode result = super.addOperationParameterDescription(resourceDescription, operationName, resolver, locale, bundle);
        this.addValueTypeDescription(result, this.getName(), bundle, resolver, locale);
        return result;
    }

    @Override
    public ModelNode addResourceAttributeDescription(ModelNode resourceDescription, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle) {
        ModelNode result = super.addResourceAttributeDescription(resourceDescription, resolver, locale, bundle);
        this.addValueTypeDescription(result, this.getName(), bundle, resolver, locale);
        return result;
    }

    @Override
    public ModelNode addOperationParameterDescription(ResourceBundle bundle, String prefix, ModelNode operationDescription) {
        ModelNode result = super.addOperationParameterDescription(bundle, prefix, operationDescription);
        this.addValueTypeDescription(result, prefix, bundle, null, null);
        return result;
    }

    @Override
    public ModelNode resolveValue(ExpressionResolver resolver, ModelNode value) throws OperationFailedException {
        ModelNode superResult;
        ModelNode modelNode = superResult = value.getType() == ModelType.OBJECT ? value : super.resolveValue(resolver, value);
        if (superResult.getType() != ModelType.OBJECT) {
            return superResult;
        }
        ModelNode clone = superResult == value ? value.clone() : superResult;
        ModelNode result = new ModelNode();
        for (AttributeDefinition field : this.valueTypes) {
            String fieldName = field.getName();
            if (clone.has(fieldName)) {
                result.get(fieldName).set(field.resolveValue(resolver, clone.get(fieldName)));
                continue;
            }
            ModelNode val = field.resolveValue(resolver, new ModelNode());
            if (!val.isDefined()) continue;
            result.get(fieldName).set(val);
        }
        this.getValidator().validateResolvedParameter(this.getName(), result);
        return result;
    }

    protected void addValueTypeDescription(ModelNode node, String prefix, ResourceBundle bundle, ResourceDescriptionResolver resolver, Locale locale) {
        for (AttributeDefinition valueType : this.valueTypes) {
            boolean suffixUnusable;
            ModelNode valueTypeDesc = this.getValueTypeDescription(valueType, false);
            boolean prefixUnusable = prefix == null || prefix.isEmpty();
            boolean bl = suffixUnusable = this.suffix == null || this.suffix.isEmpty();
            String p = prefixUnusable && !suffixUnusable ? this.suffix : (!prefixUnusable && suffixUnusable ? prefix : String.format("%s.%s", prefix, this.suffix));
            if (resolver != null) {
                String key = String.format("%s.%s", p, valueType.getName());
                valueTypeDesc.get("description").set(resolver.getResourceAttributeDescription(key, locale, bundle));
            } else {
                valueTypeDesc.get("description").set(valueType.getAttributeTextDescription(bundle, p));
            }
            ModelNode childType = node.get(new String[]{"value-type", valueType.getName()}).set(valueTypeDesc);
            if (valueType instanceof ObjectTypeAttributeDefinition) {
                ((ObjectTypeAttributeDefinition)ObjectTypeAttributeDefinition.class.cast(valueType)).addValueTypeDescription(childType, p, bundle, resolver, locale);
            }
            if (valueType instanceof SimpleListAttributeDefinition) {
                ((SimpleListAttributeDefinition)SimpleListAttributeDefinition.class.cast(valueType)).addValueTypeDescription(childType, p, bundle);
                continue;
            }
            if (valueType instanceof MapAttributeDefinition) {
                ((MapAttributeDefinition)MapAttributeDefinition.class.cast(valueType)).addValueTypeDescription(childType, bundle);
                continue;
            }
            if (valueType instanceof PrimitiveListAttributeDefinition) {
                ((PrimitiveListAttributeDefinition)PrimitiveListAttributeDefinition.class.cast(valueType)).addValueTypeDescription(childType, bundle);
                continue;
            }
            if (!(valueType instanceof ObjectListAttributeDefinition)) continue;
            ((ObjectListAttributeDefinition)ObjectListAttributeDefinition.class.cast(valueType)).addValueTypeDescription(childType, p, bundle, false, resolver, locale);
        }
    }

    private ModelNode getValueTypeDescription(AttributeDefinition valueType, boolean forOperation) {
        ParameterValidator validator;
        String[] requires;
        String[] alternatives;
        MeasurementUnit measurementUnit;
        ModelNode result = new ModelNode();
        result.get("type").set(valueType.getType());
        result.get("description");
        result.get("expressions-allowed").set(valueType.isAllowExpression());
        if (forOperation) {
            result.get("required").set(!valueType.isAllowNull());
        }
        result.get("nillable").set(valueType.isAllowNull());
        ModelNode defaultValue = valueType.getDefaultValue();
        if (!forOperation && defaultValue != null && defaultValue.isDefined()) {
            result.get("default").set(defaultValue);
        }
        if ((measurementUnit = valueType.getMeasurementUnit()) != null && measurementUnit != MeasurementUnit.NONE) {
            result.get("unit").set(measurementUnit.getName());
        }
        if ((alternatives = valueType.getAlternatives()) != null) {
            for (String alternative : alternatives) {
                result.get("alternatives").add(alternative);
            }
        }
        if ((requires = valueType.getRequires()) != null) {
            for (String required : requires) {
                result.get("requires").add(required);
            }
        }
        if ((validator = valueType.getValidator()) instanceof MinMaxValidator) {
            Long max;
            MinMaxValidator minMax = (MinMaxValidator)((Object)validator);
            Long min = minMax.getMin();
            if (min != null) {
                switch (valueType.getType()) {
                    case STRING: 
                    case LIST: 
                    case OBJECT: 
                    case BYTES: {
                        result.get("min-length").set(min.longValue());
                        break;
                    }
                    default: {
                        result.get("min").set(min.longValue());
                    }
                }
            }
            if ((max = minMax.getMax()) != null) {
                switch (valueType.getType()) {
                    case STRING: 
                    case LIST: 
                    case OBJECT: 
                    case BYTES: {
                        result.get("max-length").set(max.longValue());
                        break;
                    }
                    default: {
                        result.get("max").set(max.longValue());
                    }
                }
            }
        }
        return result;
    }

    @Override
    protected void addAllowedValuesToDescription(ModelNode result, ParameterValidator validator) {
    }

    public static final class Builder
    extends AbstractAttributeDefinitionBuilder<Builder, ObjectTypeAttributeDefinition> {
        private String suffix;
        private final AttributeDefinition[] valueTypes;

        public Builder(String name, AttributeDefinition ... valueTypes) {
            super(name, ModelType.OBJECT, true);
            this.valueTypes = valueTypes;
            this.setAttributeParser(AttributeParser.OBJECT_PARSER);
        }

        public static Builder of(String name, AttributeDefinition ... valueTypes) {
            return new Builder(name, valueTypes);
        }

        public static Builder of(String name, AttributeDefinition[] valueTypes, AttributeDefinition[] moreValueTypes) {
            ArrayList<AttributeDefinition> list = new ArrayList<AttributeDefinition>(Arrays.asList(valueTypes));
            list.addAll(Arrays.asList(moreValueTypes));
            AttributeDefinition[] allValueTypes = new AttributeDefinition[list.size()];
            list.toArray(allValueTypes);
            return new Builder(name, allValueTypes);
        }

        @Override
        public ObjectTypeAttributeDefinition build() {
            if (this.validator == null) {
                this.validator = new ObjectTypeValidator(this.allowNull, this.valueTypes);
            }
            return new ObjectTypeAttributeDefinition(this);
        }

        public Builder setSuffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        @Override
        public Builder setAllowNull(boolean allowNull) {
            return (Builder)super.setAllowNull(allowNull);
        }
    }
}

