/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.registry;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.registry.AliasEntry;
import org.jboss.as.controller.registry.WildcardReadResourceDescriptionAddressHack;
import org.jboss.dmr.ModelNode;

public class AliasStepHandler
implements OperationStepHandler {
    private final AliasEntry aliasEntry;

    AliasStepHandler(AliasEntry aliasEntry) {
        this.aliasEntry = aliasEntry;
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        String op = operation.require("operation").asString();
        PathAddress addr = context.getCurrentAddress();
        WildcardReadResourceDescriptionAddressHack.attachAliasAddress(context, operation);
        PathAddress mapped = this.aliasEntry.convertToTargetAddress(addr);
        OperationStepHandler targetHandler = context.getRootResourceRegistration().getOperationHandler(mapped, op);
        if (targetHandler == null) {
            throw ControllerLogger.ROOT_LOGGER.aliasStepHandlerOperationNotFound(op, addr, mapped);
        }
        ModelNode copy = operation.clone();
        copy.get("address").set(mapped.toModelNode());
        context.addStep(copy, targetHandler, OperationContext.Stage.MODEL, true);
    }
}

