/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.deployments.resources;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleListAttributeDefinition;
import org.jboss.as.controller.SimpleMapAttributeDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.logging.LoggingExtension;
import org.jboss.as.logging.deployments.resources.LoggingConfigurationReadStepHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.logmanager.config.HandlerConfiguration;
import org.jboss.logmanager.config.LogContextConfiguration;
import org.jboss.logmanager.config.PropertyConfigurable;

class HandlerResourceDefinition
extends SimpleResourceDefinition {
    static final String NAME = "handler";
    public static final PathElement PATH = PathElement.pathElement((String)"handler");
    static final SimpleAttributeDefinition CLASS_NAME = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"class-name", (ModelType)ModelType.STRING).setStorageRuntime()).build();
    static final SimpleAttributeDefinition MODULE = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"module", (ModelType)ModelType.STRING, (boolean)true).setStorageRuntime()).build();
    static final SimpleAttributeDefinition ENCODING = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"encoding", (ModelType)ModelType.STRING, (boolean)true).setStorageRuntime()).build();
    static final SimpleAttributeDefinition LEVEL = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"level", (ModelType)ModelType.STRING, (boolean)true).setStorageRuntime()).build();
    static final SimpleAttributeDefinition HANDLER = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"handler", (ModelType)ModelType.STRING, (boolean)true).setStorageRuntime()).build();
    static final SimpleListAttributeDefinition HANDLERS = ((SimpleListAttributeDefinition.Builder)SimpleListAttributeDefinition.Builder.of((String)"handlers", (AttributeDefinition)HANDLER).setAllowNull(true).setStorageRuntime()).build();
    static final SimpleAttributeDefinition FORMATTER = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"formatter", (ModelType)ModelType.STRING, (boolean)true).setStorageRuntime()).build();
    static final SimpleAttributeDefinition FILTER = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"filter", (ModelType)ModelType.STRING, (boolean)true).setStorageRuntime()).build();
    static final SimpleMapAttributeDefinition PROPERTIES = ((SimpleMapAttributeDefinition.Builder)new SimpleMapAttributeDefinition.Builder("properties", ModelType.STRING, true).setStorageRuntime()).build();
    static final SimpleAttributeDefinition ERROR_MANAGER = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"error-manager", (ModelType)ModelType.STRING, (boolean)true).setStorageRuntime()).build();

    public HandlerResourceDefinition() {
        super(PATH, LoggingExtension.getResourceDescriptionResolver("deployment", NAME));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)CLASS_NAME, (OperationStepHandler)new HandlerConfigurationReadStepHandler(){

            @Override
            protected void updateModel(HandlerConfiguration configuration, ModelNode model) {
                1.setModelValue(model, configuration.getClassName());
            }
        });
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)MODULE, (OperationStepHandler)new HandlerConfigurationReadStepHandler(){

            @Override
            protected void updateModel(HandlerConfiguration configuration, ModelNode model) {
                2.setModelValue(model, configuration.getModuleName());
            }
        });
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)ENCODING, (OperationStepHandler)new HandlerConfigurationReadStepHandler(){

            @Override
            protected void updateModel(HandlerConfiguration configuration, ModelNode model) {
                3.setModelValue(model, configuration.getEncoding());
            }
        });
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)LEVEL, (OperationStepHandler)new HandlerConfigurationReadStepHandler(){

            @Override
            protected void updateModel(HandlerConfiguration configuration, ModelNode model) {
                4.setModelValue(model, configuration.getLevel());
            }
        });
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)FORMATTER, (OperationStepHandler)new HandlerConfigurationReadStepHandler(){

            @Override
            protected void updateModel(HandlerConfiguration configuration, ModelNode model) {
                5.setModelValue(model, configuration.getFormatterName());
            }
        });
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)FILTER, (OperationStepHandler)new HandlerConfigurationReadStepHandler(){

            @Override
            protected void updateModel(HandlerConfiguration configuration, ModelNode model) {
                6.setModelValue(model, configuration.getFilter());
            }
        });
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)HANDLERS, (OperationStepHandler)new HandlerConfigurationReadStepHandler(){

            @Override
            protected void updateModel(HandlerConfiguration configuration, ModelNode model) {
                ModelNode handlers = model.setEmptyList();
                configuration.getHandlerNames().forEach(arg_0 -> ((ModelNode)handlers).add(arg_0));
            }
        });
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)PROPERTIES, (OperationStepHandler)new HandlerConfigurationReadStepHandler(){

            @Override
            protected void updateModel(HandlerConfiguration configuration, ModelNode model) {
                8.addProperties((PropertyConfigurable)configuration, model);
            }
        });
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)ERROR_MANAGER, (OperationStepHandler)new HandlerConfigurationReadStepHandler(){

            @Override
            protected void updateModel(HandlerConfiguration configuration, ModelNode model) {
                9.setModelValue(model, configuration.getErrorManagerName());
            }
        });
    }

    static abstract class HandlerConfigurationReadStepHandler
    extends LoggingConfigurationReadStepHandler {
        HandlerConfigurationReadStepHandler() {
        }

        @Override
        protected void updateModel(LogContextConfiguration logContextConfiguration, String name, ModelNode model) {
            HandlerConfiguration handlerConfiguration = logContextConfiguration.getHandlerConfiguration(name);
            this.updateModel(handlerConfiguration, model);
        }

        protected abstract void updateModel(HandlerConfiguration var1, ModelNode var2);
    }
}

