/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.filters;

import io.undertow.server.handlers.proxy.mod_cluster.ModCluster;
import io.undertow.server.handlers.proxy.mod_cluster.ModClusterStatus;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.filters.ModClusterBalancerResource;
import org.wildfly.extension.undertow.filters.ModClusterService;
import org.wildfly.extension.undertow.logging.UndertowLogger;

public class ModClusterResource
implements Resource {
    private final Resource delegate;
    private final String name;

    public ModClusterResource(Resource delegate, String name) {
        this.delegate = delegate;
        this.name = name;
    }

    public ModelNode getModel() {
        return this.delegate.getModel();
    }

    public void writeModel(ModelNode newModel) {
        this.delegate.writeModel(newModel);
    }

    public boolean isModelDefined() {
        return this.delegate.isModelDefined();
    }

    public boolean hasChild(PathElement element) {
        if ("balancer".equals(element.getKey())) {
            return this.getChildrenNames("balancer").contains(element.getValue());
        }
        return this.delegate.hasChild(element);
    }

    public Resource getChild(PathElement element) {
        if ("balancer".equals(element.getKey())) {
            if (this.getChildrenNames("balancer").contains(element.getValue())) {
                return new ModClusterBalancerResource(element.getValue(), this.name);
            }
            return null;
        }
        return this.delegate.getChild(element);
    }

    public Resource requireChild(PathElement element) {
        if ("balancer".equals(element.getKey())) {
            if (this.getChildrenNames("balancer").contains(element.getValue())) {
                return new ModClusterBalancerResource(element.getValue(), this.name);
            }
            throw new Resource.NoSuchResourceException(element);
        }
        return this.delegate.requireChild(element);
    }

    public boolean hasChildren(String childType) {
        if ("balancer".equals(childType)) {
            return !this.getChildrenNames("balancer").isEmpty();
        }
        return this.delegate.hasChildren(childType);
    }

    public Resource navigate(PathAddress address) {
        if (address.size() > 0 && "balancer".equals(address.getElement(0).getKey())) {
            Resource modClusterBalancerResource = this.requireChild(address.getElement(0));
            if (address.size() == 1) {
                return modClusterBalancerResource;
            }
            return modClusterBalancerResource.navigate(address.subAddress(1));
        }
        return this.delegate.navigate(address);
    }

    public Set<String> getChildTypes() {
        LinkedHashSet<String> result = new LinkedHashSet<String>(this.delegate.getChildTypes());
        result.add("balancer");
        return result;
    }

    public Set<String> getChildrenNames(String childType) {
        if ("balancer".equals(childType)) {
            ModClusterService service = ModClusterResource.service(this.name);
            if (service == null) {
                return Collections.emptySet();
            }
            ModCluster modCluster = service.getModCluster();
            ModClusterStatus status = modCluster.getController().getStatus();
            LinkedHashSet<String> result = new LinkedHashSet<String>();
            for (ModClusterStatus.LoadBalancer balancer : status.getLoadBalancers()) {
                result.add(balancer.getName());
            }
            return result;
        }
        return this.delegate.getChildrenNames(childType);
    }

    public Set<Resource.ResourceEntry> getChildren(String childType) {
        if ("balancer".equals(childType)) {
            Set<String> names = this.getChildrenNames(childType);
            LinkedHashSet<Resource.ResourceEntry> result = new LinkedHashSet<Resource.ResourceEntry>(names.size());
            for (String name : names) {
                result.add(new ModClusterBalancerResource(name, this.name));
            }
            return result;
        }
        return this.delegate.getChildren(childType);
    }

    public void registerChild(PathElement address, Resource resource) {
        String type = address.getKey();
        if ("balancer".equals(type)) {
            throw UndertowLogger.ROOT_LOGGER.cannotRegisterResourceOfType(type);
        }
        this.delegate.registerChild(address, resource);
    }

    public void registerChild(PathElement address, int index, Resource resource) {
        String type = address.getKey();
        if ("balancer".equals(type)) {
            throw UndertowLogger.ROOT_LOGGER.cannotRegisterResourceOfType(type);
        }
        this.delegate.registerChild(address, index, resource);
    }

    public Resource removeChild(PathElement address) {
        String type = address.getKey();
        if ("balancer".equals(type)) {
            throw UndertowLogger.ROOT_LOGGER.cannotRemoveResourceOfType(type);
        }
        return this.delegate.removeChild(address);
    }

    public boolean isRuntime() {
        return this.delegate.isRuntime();
    }

    public boolean isProxy() {
        return this.delegate.isProxy();
    }

    public Set<String> getOrderedChildTypes() {
        return Collections.emptySet();
    }

    public Resource clone() {
        return new ModClusterResource(this.delegate.clone(), this.name);
    }

    static ModClusterService service(String name) {
        ServiceContainer serviceContainer = CurrentServiceContainer.getServiceContainer();
        if (serviceContainer == null) {
            return null;
        }
        ServiceController cluster = serviceContainer.getService(UndertowService.FILTER.append(new String[]{name}));
        if (cluster == null) {
            return null;
        }
        return (ModClusterService)cluster.getService();
    }
}

