/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.console.alias;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.aesh.console.Config;
import org.jboss.aesh.console.alias.Alias;
import org.jboss.aesh.util.LoggerUtil;

public class AliasManager {
    private final List<Alias> aliases;
    private final Pattern aliasPattern = Pattern.compile("^(alias)\\s+(\\w+)\\s*=\\s*(.*)$");
    private final Pattern listAliasPattern = Pattern.compile("^(alias)((\\s+\\w+)+)$");
    private final Pattern aliasHelpPattern = Pattern.compile("^(alias)\\s+\\-\\-help$");
    private final Pattern unaliasHelpPattern = Pattern.compile("^(unalias)\\s+\\-\\-help$");
    private static final String ALIAS = "alias";
    private static final String ALIAS_SPACE = "alias ";
    private static final String UNALIAS = "unalias";
    private File aliasFile;
    private final String name;
    private boolean persistAlias = false;
    private static final Logger LOGGER = LoggerUtil.getLogger(AliasManager.class.getName());

    public AliasManager(File aliasFile, boolean persistAlias, String name) throws IOException {
        this.persistAlias = persistAlias;
        this.name = name;
        this.aliases = new ArrayList<Alias>();
        if (aliasFile != null) {
            this.aliasFile = aliasFile;
            if (this.aliasFile.isFile()) {
                this.readAliasesFromFile();
            }
        }
    }

    private void readAliasesFromFile() throws IOException {
        try (BufferedReader br = new BufferedReader(new FileReader(this.aliasFile));){
            String line;
            while ((line = br.readLine()) != null) {
                if (!line.startsWith(ALIAS)) continue;
                try {
                    this.parseAlias(line);
                }
                catch (Exception ignored) {}
            }
        }
    }

    public void persist() {
        if (this.persistAlias && this.aliasFile != null) {
            try {
                boolean keepGoing = true;
                if (this.aliasFile.isFile()) {
                    keepGoing = this.aliasFile.delete();
                }
                if (keepGoing) {
                    this.aliasFile.mkdirs();
                    keepGoing = this.aliasFile.createNewFile();
                }
                if (keepGoing) {
                    FileWriter fw = new FileWriter(this.aliasFile);
                    LOGGER.info("created fileWriter");
                    Collections.sort(this.aliases);
                    for (Alias a : this.aliases) {
                        LOGGER.info("writing to file: alias " + a.toString());
                        fw.write(ALIAS_SPACE + a.toString() + Config.getLineSeparator());
                    }
                    fw.flush();
                    fw.close();
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Could not persist to alias file:", e);
            }
        }
    }

    void addAlias(String name, String value) {
        Alias alias = new Alias(name, value);
        if (this.aliases.contains(alias)) {
            this.aliases.remove(alias);
        }
        this.aliases.add(alias);
    }

    public String printAllAliases() {
        StringBuilder sb = new StringBuilder();
        Collections.sort(this.aliases);
        for (Alias a : this.aliases) {
            sb.append(ALIAS_SPACE).append(a.toString()).append(Config.getLineSeparator());
        }
        return sb.toString();
    }

    public Alias getAlias(String name) {
        int index = this.aliases.indexOf(new Alias(name, null));
        if (index > -1) {
            return this.aliases.get(index);
        }
        return null;
    }

    public List<String> findAllMatchingNames(String name) {
        ArrayList<String> names = new ArrayList<String>();
        for (Alias a : this.aliases) {
            if (!a.getName().startsWith(name)) continue;
            names.add(a.getName());
        }
        return names;
    }

    public List<String> getAllNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (Alias a : this.aliases) {
            names.add(a.getName());
        }
        return names;
    }

    public String removeAlias(String buffer) {
        if (buffer.trim().equals(UNALIAS)) {
            return this.unaliasUsage();
        }
        if (this.unaliasHelpPattern.matcher(buffer).matches()) {
            return this.unaliasUsage();
        }
        buffer = buffer.substring(UNALIAS.length()).trim();
        for (String s : buffer.split(" ")) {
            if (s == null) continue;
            Alias a = this.getAlias(s.trim());
            if (a != null) {
                this.aliases.remove(a);
                continue;
            }
            return this.name + ": unalias: " + s + ": not found" + Config.getLineSeparator();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String parseAlias(String buffer) {
        if (buffer.trim().equals(ALIAS)) {
            return this.printAllAliases();
        }
        if (this.aliasHelpPattern.matcher(buffer).matches()) {
            return this.aliasUsage();
        }
        Matcher aliasMatcher = this.aliasPattern.matcher(buffer);
        if (aliasMatcher.matches()) {
            String name = aliasMatcher.group(2);
            String value = aliasMatcher.group(3);
            if (value.startsWith("'")) {
                if (!value.endsWith("'")) return this.aliasUsage();
                value = value.substring(1, value.length() - 1);
            } else if (value.startsWith("\"")) {
                if (!value.endsWith("\"")) return this.aliasUsage();
                value = value.substring(1, value.length() - 1);
            }
            if (name.contains(" ")) {
                return this.aliasUsage();
            }
            this.addAlias(name, value);
            return null;
        }
        Matcher listMatcher = this.listAliasPattern.matcher(buffer);
        if (!listMatcher.matches()) return null;
        StringBuilder sb = new StringBuilder();
        for (String s : listMatcher.group(2).trim().split(" ")) {
            if (s == null) continue;
            Alias a = this.getAlias(s.trim());
            if (a != null) {
                sb.append(ALIAS_SPACE).append(a.getName()).append("='").append(a.getValue()).append("'").append(Config.getLineSeparator());
                continue;
            }
            sb.append(this.name).append(": alias: ").append(s).append(" : not found").append(Config.getLineSeparator());
        }
        return sb.toString();
    }

    private String aliasUsage() {
        return "alias: usage: alias [name[=value] ... ]" + Config.getLineSeparator();
    }

    private String unaliasUsage() {
        return "unalias: usage: unalias name [name ...]" + Config.getLineSeparator();
    }
}

