/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.deployment;

import io.undertow.websockets.jsr.JsrWebSocketLogger;
import io.undertow.websockets.jsr.WebSocketDeploymentInfo;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.websocket.ClientEndpoint;
import javax.websocket.Endpoint;
import javax.websocket.server.ServerApplicationConfig;
import javax.websocket.server.ServerEndpoint;
import javax.websocket.server.ServerEndpointConfig;
import org.jboss.as.ee.utils.ClassLoadingUtils;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.modules.Module;
import org.wildfly.extension.undertow.deployment.UndertowAttachments;
import org.wildfly.extension.undertow.logging.UndertowLogger;

public class UndertowJSRWebSocketDeploymentProcessor
implements DeploymentUnitProcessor {
    private static final DotName SERVER_ENDPOINT = DotName.createSimple((String)ServerEndpoint.class.getName());
    private static final DotName CLIENT_ENDPOINT = DotName.createSimple((String)ClientEndpoint.class.getName());
    private static final DotName SERVER_APPLICATION_CONFIG = DotName.createSimple((String)ServerApplicationConfig.class.getName());
    private static final DotName ENDPOINT = DotName.createSimple((String)Endpoint.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        if (module == null) {
            return;
        }
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            Set epClasses;
            Set subclasses;
            Class moduleClass;
            List clientEndpoints;
            Thread.currentThread().setContextClassLoader((ClassLoader)module.getClassLoader());
            WarMetaData metaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
            if (metaData == null) {
                return;
            }
            if (!metaData.getMergedJBossWebMetaData().isEnableWebSockets()) {
                return;
            }
            HashSet annotatedEndpoints = new HashSet();
            HashSet<Class<? extends Endpoint>> endpoints = new HashSet<Class<? extends Endpoint>>();
            HashSet<Class<? extends ServerApplicationConfig>> config = new HashSet<Class<? extends ServerApplicationConfig>>();
            CompositeIndex index = (CompositeIndex)deploymentUnit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
            List serverEndpoints = index.getAnnotations(SERVER_ENDPOINT);
            if (serverEndpoints != null) {
                for (AnnotationInstance endpoint : serverEndpoints) {
                    if (!(endpoint.target() instanceof ClassInfo)) continue;
                    ClassInfo clazz = (ClassInfo)endpoint.target();
                    try {
                        Class moduleClass2 = ClassLoadingUtils.loadClass((String)clazz.name().toString(), (Module)module);
                        if (Modifier.isAbstract(moduleClass2.getModifiers())) continue;
                        annotatedEndpoints.add(moduleClass2);
                    }
                    catch (ClassNotFoundException e) {
                        UndertowLogger.ROOT_LOGGER.couldNotLoadWebSocketEndpoint(clazz.name().toString(), e);
                    }
                }
            }
            if ((clientEndpoints = index.getAnnotations(CLIENT_ENDPOINT)) != null) {
                for (AnnotationInstance endpoint : clientEndpoints) {
                    if (!(endpoint.target() instanceof ClassInfo)) continue;
                    ClassInfo clazz = (ClassInfo)endpoint.target();
                    try {
                        moduleClass = ClassLoadingUtils.loadClass((String)clazz.name().toString(), (Module)module);
                        if (Modifier.isAbstract(moduleClass.getModifiers())) continue;
                        annotatedEndpoints.add(moduleClass);
                    }
                    catch (ClassNotFoundException e) {
                        UndertowLogger.ROOT_LOGGER.couldNotLoadWebSocketEndpoint(clazz.name().toString(), e);
                    }
                }
            }
            if ((subclasses = index.getAllKnownImplementors(SERVER_APPLICATION_CONFIG)) != null) {
                for (ClassInfo clazz : subclasses) {
                    try {
                        moduleClass = ClassLoadingUtils.loadClass((String)clazz.name().toString(), (Module)module);
                        if (Modifier.isAbstract(moduleClass.getModifiers())) continue;
                        config.add(moduleClass);
                    }
                    catch (ClassNotFoundException e) {
                        UndertowLogger.ROOT_LOGGER.couldNotLoadWebSocketConfig(clazz.name().toString(), e);
                    }
                }
            }
            if ((epClasses = index.getAllKnownSubclasses(ENDPOINT)) != null) {
                for (ClassInfo clazz : epClasses) {
                    try {
                        Class moduleClass3 = ClassLoadingUtils.loadClass((String)clazz.name().toString(), (Module)module);
                        if (Modifier.isAbstract(moduleClass3.getModifiers())) continue;
                        endpoints.add(moduleClass3);
                    }
                    catch (ClassNotFoundException e) {
                        UndertowLogger.ROOT_LOGGER.couldNotLoadWebSocketConfig(clazz.name().toString(), e);
                    }
                }
            }
            WebSocketDeploymentInfo webSocketDeploymentInfo = new WebSocketDeploymentInfo();
            this.doDeployment(webSocketDeploymentInfo, annotatedEndpoints, config, endpoints);
            this.installWebsockets(phaseContext, webSocketDeploymentInfo);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }

    private void installWebsockets(DeploymentPhaseContext phaseContext, WebSocketDeploymentInfo webSocketDeploymentInfo) {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        deploymentUnit.putAttachment(UndertowAttachments.WEB_SOCKET_DEPLOYMENT_INFO, (Object)webSocketDeploymentInfo);
    }

    private void doDeployment(WebSocketDeploymentInfo container, Set<Class<?>> annotatedEndpoints, Set<Class<? extends ServerApplicationConfig>> serverApplicationConfigClasses, Set<Class<? extends Endpoint>> endpoints) throws DeploymentUnitProcessingException {
        HashSet<Class<? extends Endpoint>> allScannedEndpointImplementations = new HashSet<Class<? extends Endpoint>>(endpoints);
        HashSet allScannedAnnotatedEndpoints = new HashSet(annotatedEndpoints);
        HashSet newAnnotatatedEndpoints = new HashSet();
        HashSet serverEndpointConfigurations = new HashSet();
        HashSet<ServerApplicationConfig> configInstances = new HashSet<ServerApplicationConfig>();
        for (Class<? extends ServerApplicationConfig> clazz : serverApplicationConfigClasses) {
            try {
                configInstances.add(clazz.newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                JsrWebSocketLogger.ROOT_LOGGER.couldNotInitializeConfiguration(clazz, (Throwable)e);
            }
        }
        if (!configInstances.isEmpty()) {
            for (ServerApplicationConfig serverApplicationConfig : configInstances) {
                Set endpointConfigs;
                Set returnedEndpoints = serverApplicationConfig.getAnnotatedEndpointClasses(allScannedAnnotatedEndpoints);
                if (returnedEndpoints != null) {
                    newAnnotatatedEndpoints.addAll(returnedEndpoints);
                }
                if ((endpointConfigs = serverApplicationConfig.getEndpointConfigs(allScannedEndpointImplementations)) == null) continue;
                serverEndpointConfigurations.addAll(endpointConfigs);
            }
        } else {
            newAnnotatatedEndpoints.addAll(allScannedAnnotatedEndpoints);
        }
        for (Class<Object> clazz : newAnnotatatedEndpoints) {
            container.addEndpoint(clazz);
        }
        for (ServerEndpointConfig serverEndpointConfig : serverEndpointConfigurations) {
            container.addEndpoint(serverEndpointConfig);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

