/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.spdy;

import io.undertow.protocols.spdy.SpdyPushBackParser;
import io.undertow.protocols.spdy.SpdySetting;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

class SpdySettingsParser
extends SpdyPushBackParser {
    private int length = -1;
    private int count = 0;
    private final List<SpdySetting> settings = new ArrayList<SpdySetting>();

    public SpdySettingsParser(int frameLength) {
        super(frameLength);
    }

    @Override
    protected void handleData(ByteBuffer resource) {
        if (this.length == -1) {
            if (resource.remaining() < 4) {
                return;
            }
            this.length = (resource.get() & 0xFF) << 24;
            this.length += (resource.get() & 0xFF) << 16;
            this.length += (resource.get() & 0xFF) << 8;
            this.length += resource.get() & 0xFF;
        }
        while (this.count < this.length) {
            if (resource.remaining() < 8) {
                return;
            }
            int flags = resource.get() & 0xFF;
            int id = (resource.get() & 0xFF) << 16;
            id += (resource.get() & 0xFF) << 8;
            id += resource.get() & 0xFF;
            int value = (resource.get() & 0xFF) << 24;
            value += (resource.get() & 0xFF) << 16;
            value += (resource.get() & 0xFF) << 8;
            value += resource.get() & 0xFF;
            boolean found = false;
            for (SpdySetting existing : this.settings) {
                if (existing.getId() != id) continue;
                found = true;
                break;
            }
            if (!found) {
                this.settings.add(new SpdySetting(flags, id, value));
            }
            ++this.count;
        }
    }

    public List<SpdySetting> getSettings() {
        return this.settings;
    }
}

