/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.capability;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.as.controller.capability.AbstractCapability;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.msc.service.ServiceName;

public class RuntimeCapability<T>
extends AbstractCapability {
    private final Class<?> serviceValueType;
    private final ServiceName serviceName;
    private final T runtimeAPI;

    public static String buildDynamicCapabilityName(String baseName, String dynamicNameElement) {
        assert (baseName != null);
        assert (dynamicNameElement != null);
        return baseName + "." + dynamicNameElement;
    }

    @Deprecated
    public static <T> RuntimeCapability<T> fromBaseCapability(RuntimeCapability<T> base, String dynamicElement) {
        return base.fromBaseCapability(dynamicElement);
    }

    @Deprecated
    public RuntimeCapability(String name, T runtimeAPI, Set<String> requirements, Set<String> optionalRequirements) {
        super(name, false, requirements, optionalRequirements, null, null, null);
        this.runtimeAPI = runtimeAPI;
        this.serviceValueType = null;
        this.serviceName = null;
    }

    @Deprecated
    public RuntimeCapability(String name, T runtimeAPI, Set<String> requirements) {
        this(name, runtimeAPI, requirements, null);
    }

    @Deprecated
    public RuntimeCapability(String name, T runtimeAPI, String ... requirements) {
        super(name, false, new HashSet<String>(Arrays.asList(requirements)), null, null, null, null);
        this.runtimeAPI = runtimeAPI;
        this.serviceValueType = null;
        this.serviceName = null;
    }

    private RuntimeCapability(Builder<T> builder) {
        super(((Builder)builder).baseName, ((Builder)builder).dynamic, ((Builder)builder).requirements, ((Builder)builder).optionalRequirements, ((Builder)builder).runtimeOnlyRequirements, ((Builder)builder).dynamicRequirements, ((Builder)builder).dynamicOptionalRequirements);
        this.runtimeAPI = ((Builder)builder).runtimeAPI;
        this.serviceValueType = ((Builder)builder).serviceValueType;
        this.serviceName = ServiceName.parse((String)((Builder)builder).baseName);
    }

    private RuntimeCapability(String baseName, String dynamicElement, Class<?> serviceValueType, T runtimeAPI, Set<String> requirements, Set<String> optionalRequirements, Set<String> runtimeOnlyRequirements, Set<String> dynamicRequirements, Set<String> dynamicOptionalRequirements) {
        super(RuntimeCapability.buildDynamicCapabilityName(baseName, dynamicElement), false, requirements, optionalRequirements, runtimeOnlyRequirements, dynamicRequirements, dynamicOptionalRequirements);
        this.runtimeAPI = runtimeAPI;
        this.serviceValueType = serviceValueType;
        this.serviceName = dynamicElement == null ? ServiceName.parse((String)baseName) : ServiceName.parse((String)baseName).append(new String[]{dynamicElement});
    }

    public ServiceName getCapabilityServiceName() {
        return this.getCapabilityServiceName((Class)null);
    }

    public ServiceName getCapabilityServiceName(Class<?> serviceValueType) {
        if (this.serviceValueType == null || serviceValueType != null && !serviceValueType.isAssignableFrom(this.serviceValueType)) {
            throw ControllerLogger.MGMT_OP_LOGGER.invalidCapabilityServiceType(this.getName(), serviceValueType);
        }
        return this.serviceName;
    }

    public ServiceName getCapabilityServiceName(String dynamicNameElement) {
        return this.getCapabilityServiceName(dynamicNameElement, null);
    }

    public ServiceName getCapabilityServiceName(String dynamicNameElement, Class<?> serviceValueType) {
        return this.fromBaseCapability(dynamicNameElement).getCapabilityServiceName(serviceValueType);
    }

    public Class<?> getCapabilityServiceValueType() {
        return this.serviceValueType;
    }

    public T getRuntimeAPI() {
        return this.runtimeAPI;
    }

    public RuntimeCapability<T> fromBaseCapability(String dynamicElement) {
        assert (this.isDynamicallyNamed());
        assert (dynamicElement != null);
        assert (dynamicElement.length() > 0);
        return new RuntimeCapability<T>(this.getName(), dynamicElement, this.serviceValueType, this.runtimeAPI, this.getRequirements(), this.getOptionalRequirements(), this.getRuntimeOnlyRequirements(), this.getDynamicRequirements(), this.getDynamicOptionalRequirements());
    }

    public static class Builder<T> {
        private final String baseName;
        private final T runtimeAPI;
        private final boolean dynamic;
        private Class<?> serviceValueType;
        private Set<String> requirements;
        private Set<String> optionalRequirements;
        private Set<String> runtimeOnlyRequirements;
        private Set<String> dynamicRequirements;
        private Set<String> dynamicOptionalRequirements;

        public static Builder<Void> of(String name) {
            return new Builder<Object>(name, false, null);
        }

        public static Builder<Void> of(String name, boolean dynamic) {
            return new Builder<Object>(name, dynamic, null);
        }

        public static Builder<Void> of(String name, Class<?> serviceValueType) {
            return new Builder<Object>(name, false, null).setServiceType(serviceValueType);
        }

        public static Builder<Void> of(String name, boolean dynamic, Class<?> serviceValueType) {
            return new Builder<Object>(name, dynamic, null).setServiceType(serviceValueType);
        }

        public static <T> Builder<T> of(String name, T runtimeAPI) {
            return new Builder<T>(name, false, runtimeAPI);
        }

        public static <T> Builder<T> of(String name, boolean dynamic, T runtimeAPI) {
            return new Builder<T>(name, dynamic, runtimeAPI);
        }

        private Builder(String baseName, boolean dynamic, T runtimeAPI) {
            assert (baseName != null);
            assert (baseName.length() > 0);
            this.baseName = baseName;
            this.runtimeAPI = runtimeAPI;
            this.dynamic = dynamic;
        }

        public Builder<T> setServiceType(Class<?> type) {
            this.serviceValueType = type;
            return this;
        }

        public Builder<T> addRequirements(String ... requirements) {
            assert (requirements != null);
            if (this.requirements == null) {
                this.requirements = new HashSet<String>(requirements.length);
            }
            Collections.addAll(this.requirements, requirements);
            return this;
        }

        @Deprecated
        public Builder<T> addOptionalRequirements(String ... requirements) {
            assert (requirements != null);
            if (this.optionalRequirements == null) {
                this.optionalRequirements = new HashSet<String>(requirements.length);
            }
            Collections.addAll(this.optionalRequirements, requirements);
            return this;
        }

        @Deprecated
        public Builder<T> addRuntimeOnlyRequirements(String ... requirements) {
            assert (requirements != null);
            if (this.runtimeOnlyRequirements == null) {
                this.runtimeOnlyRequirements = new HashSet<String>(requirements.length);
            }
            Collections.addAll(this.runtimeOnlyRequirements, requirements);
            return this;
        }

        @Deprecated
        public Builder<T> addDynamicRequirements(String ... requirements) {
            assert (requirements != null);
            if (this.dynamicRequirements == null) {
                this.dynamicRequirements = new HashSet<String>(requirements.length);
            }
            Collections.addAll(this.dynamicRequirements, requirements);
            return this;
        }

        @Deprecated
        public Builder<T> addDynamicOptionalRequirements(String ... requirements) {
            assert (requirements != null);
            if (this.dynamicOptionalRequirements == null) {
                this.dynamicOptionalRequirements = new HashSet<String>(requirements.length);
            }
            Collections.addAll(this.dynamicOptionalRequirements, requirements);
            return this;
        }

        public RuntimeCapability<T> build() {
            return new RuntimeCapability(this);
        }
    }
}

