/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dmr;

import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.ModelValue;
import org.jboss.dmr.StringModelValue;
import org.jboss.dmr.ValueExpression;

final class ExpressionValue
extends ModelValue {
    public static final String TYPE_KEY = "EXPRESSION_VALUE";
    private final ValueExpression valueExpression;

    ExpressionValue(String expressionString) {
        this(new ValueExpression(expressionString));
    }

    ExpressionValue(ValueExpression valueExpression) {
        super(ModelType.EXPRESSION);
        this.valueExpression = valueExpression;
    }

    @Override
    void writeExternal(DataOutput out) throws IOException {
        out.write(ModelType.EXPRESSION.typeChar);
        out.writeUTF(this.valueExpression.getExpressionString());
    }

    @Override
    String asString() {
        return this.valueExpression.getExpressionString();
    }

    @Override
    ValueExpression asExpression() {
        return this.valueExpression;
    }

    @Override
    void format(PrintWriter writer, int indent, boolean multiLine) {
        writer.append("expression ");
        writer.append(ExpressionValue.quote(this.valueExpression.getExpressionString()));
    }

    @Override
    void formatAsJSON(PrintWriter writer, int indent, boolean multiLine) {
        writer.append('{');
        if (multiLine) {
            ExpressionValue.indent(writer.append('\n'), indent + 1);
        } else {
            writer.append(' ');
        }
        writer.append(ExpressionValue.jsonEscape(TYPE_KEY));
        writer.append(" : ");
        writer.append(ExpressionValue.jsonEscape(this.asString()));
        if (multiLine) {
            ExpressionValue.indent(writer.append('\n'), indent);
        } else {
            writer.append(' ');
        }
        writer.append('}');
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ExpressionValue && this.equals((ExpressionValue)other);
    }

    public boolean equals(ExpressionValue other) {
        return this == other || other != null && this.valueExpression.equals(other.valueExpression);
    }

    @Override
    public int hashCode() {
        return this.valueExpression.hashCode();
    }

    @Override
    ModelValue resolve() {
        return new StringModelValue(this.valueExpression.resolveString());
    }
}

