/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReadResourceNameOperationStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.constraint.ApplicationTypeConfig;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.ApplicationTypeAccessConstraintDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.KnownModelVersion;
import org.jboss.as.logging.LoggerOperations;
import org.jboss.as.logging.Logging;
import org.jboss.as.logging.LoggingExtension;
import org.jboss.as.logging.LoggingOperations;
import org.jboss.as.logging.LoggingResourceTransformer;
import org.jboss.as.logging.PropertyAttributeDefinition;
import org.jboss.as.logging.TransformerResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class LoggerResourceDefinition
extends TransformerResourceDefinition {
    public static final String CHANGE_LEVEL_OPERATION_NAME = "change-log-level";
    public static final String LEGACY_ADD_HANDLER_OPERATION_NAME = "assign-handler";
    public static final String LEGACY_REMOVE_HANDLER_OPERATION_NAME = "unassign-handler";
    public static final String LOGGER = "logger";
    static final PathElement LOGGER_PATH = PathElement.pathElement((String)"logger");
    static final ResourceDescriptionResolver LOGGER_RESOLVER = LoggingExtension.getResourceDescriptionResolver("logger");
    static final OperationDefinition CHANGE_LEVEL_OPERATION = new SimpleOperationDefinitionBuilder("change-log-level", LOGGER_RESOLVER).setDeprecated(ModelVersion.create((int)1, (int)2, (int)0)).setParameters(new AttributeDefinition[]{CommonAttributes.LEVEL}).build();
    static final OperationDefinition LEGACY_ADD_HANDLER_OPERATION = new SimpleOperationDefinitionBuilder("assign-handler", LOGGER_RESOLVER).setParameters(new AttributeDefinition[]{CommonAttributes.HANDLER_NAME}).setDeprecated(ModelVersion.create((int)1, (int)2, (int)0)).build();
    static final OperationDefinition LEGACY_REMOVE_HANDLER_OPERATION = new SimpleOperationDefinitionBuilder("unassign-handler", LOGGER_RESOLVER).setParameters(new AttributeDefinition[]{CommonAttributes.HANDLER_NAME}).setDeprecated(ModelVersion.create((int)1, (int)2, (int)0)).build();
    static final OperationDefinition ADD_HANDLER_OPERATION = new SimpleOperationDefinitionBuilder("add-handler", LOGGER_RESOLVER).setParameters(new AttributeDefinition[]{CommonAttributes.HANDLER_NAME}).build();
    static final OperationDefinition REMOVE_HANDLER_OPERATION = new SimpleOperationDefinitionBuilder("remove-handler", LOGGER_RESOLVER).setParameters(new AttributeDefinition[]{CommonAttributes.HANDLER_NAME}).build();
    public static final PropertyAttributeDefinition USE_PARENT_HANDLERS = ((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)PropertyAttributeDefinition.Builder.of("use-parent-handlers", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(true))).setPropertyName("useParentHandlers").build();
    public static final SimpleAttributeDefinition CATEGORY = SimpleAttributeDefinitionBuilder.create((String)"category", (ModelType)ModelType.STRING, (boolean)true).build();
    static final AttributeDefinition[] WRITABLE_ATTRIBUTES = new AttributeDefinition[]{CommonAttributes.FILTER_SPEC, CommonAttributes.LEVEL, CommonAttributes.HANDLERS, USE_PARENT_HANDLERS};
    static final AttributeDefinition[] LEGACY_ATTRIBUTES = new AttributeDefinition[]{CommonAttributes.FILTER};
    static final AttributeDefinition[] EXPRESSION_ATTRIBUTES = new AttributeDefinition[]{CommonAttributes.FILTER, CommonAttributes.FILTER_SPEC, CommonAttributes.LEVEL, CommonAttributes.HANDLERS, USE_PARENT_HANDLERS};
    private final AttributeDefinition[] writableAttributes;
    private final OperationStepHandler writeHandler;
    private final List<AccessConstraintDefinition> accessConstraints;

    public LoggerResourceDefinition(boolean includeLegacy) {
        super(LOGGER_PATH, LoggingExtension.getResourceDescriptionResolver(LOGGER), includeLegacy ? new LoggerOperations.LoggerAddOperationStepHandler(Logging.join(WRITABLE_ATTRIBUTES, LEGACY_ATTRIBUTES)) : new LoggerOperations.LoggerAddOperationStepHandler(WRITABLE_ATTRIBUTES), LoggerOperations.REMOVE_LOGGER);
        this.writableAttributes = includeLegacy ? Logging.join(WRITABLE_ATTRIBUTES, LEGACY_ATTRIBUTES) : WRITABLE_ATTRIBUTES;
        this.writeHandler = new LoggerOperations.LoggerWriteAttributeHandler(this.writableAttributes);
        ApplicationTypeConfig atc = new ApplicationTypeConfig("logging", LOGGER);
        this.accessConstraints = new ApplicationTypeAccessConstraintDefinition(atc).wrapAsList();
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (AttributeDefinition def : this.writableAttributes) {
            if (def.getName().equals(CommonAttributes.FILTER.getName())) {
                resourceRegistration.registerReadWriteAttribute(def, (OperationStepHandler)LoggingOperations.ReadFilterOperationStepHandler.INSTANCE, this.writeHandler);
                continue;
            }
            resourceRegistration.registerReadWriteAttribute(def, null, this.writeHandler);
        }
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)CATEGORY, (OperationStepHandler)ReadResourceNameOperationStepHandler.INSTANCE);
    }

    public void registerOperations(ManagementResourceRegistration registration) {
        super.registerOperations(registration);
        registration.registerOperationHandler(CHANGE_LEVEL_OPERATION, LoggerOperations.CHANGE_LEVEL);
        registration.registerOperationHandler(ADD_HANDLER_OPERATION, LoggerOperations.ADD_HANDLER);
        registration.registerOperationHandler(REMOVE_HANDLER_OPERATION, LoggerOperations.REMOVE_HANDLER);
        registration.registerOperationHandler(LEGACY_ADD_HANDLER_OPERATION, LoggerOperations.ADD_HANDLER);
        registration.registerOperationHandler(LEGACY_REMOVE_HANDLER_OPERATION, LoggerOperations.REMOVE_HANDLER);
    }

    public List<AccessConstraintDefinition> getAccessConstraints() {
        return this.accessConstraints;
    }

    @Override
    public void registerTransformers(KnownModelVersion modelVersion, ResourceTransformationDescriptionBuilder rootResourceBuilder, ResourceTransformationDescriptionBuilder loggingProfileBuilder) {
        if (modelVersion.hasTransformers()) {
            PathElement pathElement = this.getPathElement();
            ResourceTransformationDescriptionBuilder resourceBuilder = rootResourceBuilder.addChildResource(pathElement);
            switch (modelVersion) {
                case VERSION_1_3_0: {
                    resourceBuilder.setCustomResourceTransformer((ResourceTransformer)new LoggingResourceTransformer(new AttributeDefinition[]{CATEGORY}));
                    ResourceTransformationDescriptionBuilder loggingProfileResourceBuilder = loggingProfileBuilder.addChildResource(pathElement);
                    loggingProfileResourceBuilder.setCustomResourceTransformer((ResourceTransformer)new LoggingResourceTransformer(new AttributeDefinition[]{CATEGORY}));
                    break;
                }
            }
        }
    }
}

