/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.validation;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jboss.as.patching.logging.PatchLogger;
import org.jboss.as.patching.runner.PatchUtils;

public class PatchingFileRenamingCollector {
    private static final PatchLogger log = PatchLogger.ROOT_LOGGER;
    private final File renamingFailureMarker;

    public PatchingFileRenamingCollector(File renamingFailureMarker) {
        this.renamingFailureMarker = renamingFailureMarker;
    }

    public void renameFiles() throws IOException {
        List<String> failures = PatchUtils.readRefs(this.renamingFailureMarker);
        for (String path : failures) {
            File toBeRenamed = new File(path);
            if (!toBeRenamed.exists() || toBeRenamed.renameTo(PatchUtils.getRenamedFileName(toBeRenamed))) continue;
            log.cannotDeleteFile(path);
        }
        this.renamingFailureMarker.delete();
    }
}

