/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.common;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.dmr.ModelNode;
import org.jboss.metadata.parser.jsp.TldMetaDataParser;
import org.jboss.metadata.parser.util.NoopXMLResolver;
import org.jboss.metadata.web.spec.TldMetaData;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;

public class SharedTldsMetaDataBuilder {
    public static final AttachmentKey<List<TldMetaData>> ATTACHMENT_KEY = AttachmentKey.create(List.class);
    private static final String[] JSTL_TAGLIBS = new String[]{"c-1_0-rt.tld", "c-1_0.tld", "c.tld", "fmt-1_0-rt.tld", "fmt-1_0.tld", "fmt.tld", "fn.tld", "permittedTaglibs.tld", "scriptfree.tld", "sql-1_0-rt.tld", "sql-1_0.tld", "sql.tld", "x-1_0-rt.tld", "x-1_0.tld", "x.tld"};
    private final ArrayList<TldMetaData> jstlTlds = new ArrayList();
    private final ModelNode containerConfig;

    public SharedTldsMetaDataBuilder(ModelNode containerConfig) {
        this.containerConfig = containerConfig;
        this.init();
    }

    private void init() {
        try {
            ModuleClassLoader jstl = Module.getModuleFromCallerModuleLoader((ModuleIdentifier)ModuleIdentifier.create((String)"javax.servlet.jstl.api")).getClassLoader();
            for (String tld : JSTL_TAGLIBS) {
                InputStream is = jstl.getResourceAsStream("META-INF/" + tld);
                if (is == null) continue;
                TldMetaData tldMetaData = this.parseTLD(tld, is);
                this.jstlTlds.add(tldMetaData);
            }
        }
        catch (ModuleLoadException moduleLoadException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List<TldMetaData> getSharedTlds(DeploymentUnit deploymentUnit) {
        ArrayList<TldMetaData> metadata = new ArrayList<TldMetaData>();
        metadata.addAll(this.jstlTlds);
        List additionalSharedTlds = (List)deploymentUnit.getAttachment(ATTACHMENT_KEY);
        if (additionalSharedTlds != null) {
            metadata.addAll(additionalSharedTlds);
        }
        return metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TldMetaData parseTLD(String tld, InputStream is) throws Exception {
        try {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            inputFactory.setXMLResolver(NoopXMLResolver.create());
            XMLStreamReader xmlReader = inputFactory.createXMLStreamReader(is);
            TldMetaData tldMetaData = TldMetaDataParser.parse((XMLStreamReader)xmlReader);
            return tldMetaData;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

