/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.servlet.api.CrawlerSessionManagerConfig;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.RestartParentResourceAddHandler;
import org.jboss.as.controller.RestartParentResourceRemoveHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.undertow.ServletContainerAdd;
import org.wildfly.extension.undertow.ServletContainerDefinition;
import org.wildfly.extension.undertow.UndertowExtension;
import org.wildfly.extension.undertow.UndertowService;

class CrawlerSessionManagementDefinition
extends PersistentResourceDefinition {
    static final CrawlerSessionManagementDefinition INSTANCE = new CrawlerSessionManagementDefinition();
    protected static final SimpleAttributeDefinition USER_AGENTS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("user-agents", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowExpression(true)).build();
    protected static final SimpleAttributeDefinition SESSION_TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("session-timeout", ModelType.INT, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowExpression(true)).build();
    protected static final SimpleAttributeDefinition[] ATTRIBUTES = new SimpleAttributeDefinition[]{USER_AGENTS, SESSION_TIMEOUT};
    static final Map<String, AttributeDefinition> ATTRIBUTES_MAP = new HashMap<String, AttributeDefinition>();

    private CrawlerSessionManagementDefinition() {
        super(UndertowExtension.CRAWLER_SESSION_MANAGEMENT, (ResourceDescriptionResolver)UndertowExtension.getResolver(UndertowExtension.CRAWLER_SESSION_MANAGEMENT.getKeyValuePair()), (OperationStepHandler)new CrawlerSessionManagementAdd(), (OperationStepHandler)new CrawlerSessionManagementRemove());
    }

    public Collection<AttributeDefinition> getAttributes() {
        return ATTRIBUTES_MAP.values();
    }

    public CrawlerSessionManagerConfig getConfig(OperationContext context, ModelNode model) throws OperationFailedException {
        if (!model.isDefined()) {
            return null;
        }
        ModelNode agents = USER_AGENTS.resolveModelAttribute(context, model);
        ModelNode timeout = SESSION_TIMEOUT.resolveModelAttribute(context, model);
        if (timeout.isDefined() && agents.isDefined()) {
            return new CrawlerSessionManagerConfig(timeout.asInt(), agents.asString());
        }
        if (timeout.isDefined()) {
            return new CrawlerSessionManagerConfig(timeout.asInt());
        }
        if (agents.isDefined()) {
            return new CrawlerSessionManagerConfig(agents.asString());
        }
        return new CrawlerSessionManagerConfig();
    }

    static {
        for (SimpleAttributeDefinition attr : ATTRIBUTES) {
            ATTRIBUTES_MAP.put(attr.getName(), (AttributeDefinition)attr);
        }
    }

    private static class CrawlerSessionManagementRemove
    extends RestartParentResourceRemoveHandler {
        protected CrawlerSessionManagementRemove() {
            super(ServletContainerDefinition.INSTANCE.getPathElement().getKey());
        }

        protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel) throws OperationFailedException {
            ServletContainerAdd.INSTANCE.installRuntimeServices(context, parentModel, parentAddress.getLastElement().getValue());
        }

        protected ServiceName getParentServiceName(PathAddress parentAddress) {
            return UndertowService.SERVLET_CONTAINER.append(new String[]{parentAddress.getLastElement().getValue()});
        }
    }

    private static class CrawlerSessionManagementAdd
    extends RestartParentResourceAddHandler {
        protected CrawlerSessionManagementAdd() {
            super(ServletContainerDefinition.INSTANCE.getPathElement().getKey());
        }

        protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            for (SimpleAttributeDefinition def : ATTRIBUTES) {
                def.validateAndSet(operation, model);
            }
        }

        protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel) throws OperationFailedException {
            ServletContainerAdd.INSTANCE.installRuntimeServices(context, parentModel, parentAddress.getLastElement().getValue());
        }

        protected ServiceName getParentServiceName(PathAddress parentAddress) {
            return UndertowService.SERVLET_CONTAINER.append(new String[]{parentAddress.getLastElement().getValue()});
        }
    }
}

