/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.registry.DelegatingResource;
import org.jboss.as.controller.registry.PlaceholderResource;
import org.jboss.as.controller.registry.Resource;
import org.jboss.msc.service.ServiceController;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.security.credential.store.CredentialStore;
import org.wildfly.security.credential.store.CredentialStoreException;

class CredentialStoreResource
extends DelegatingResource {
    private ServiceController<CredentialStore> credentialStoreServiceController;

    CredentialStoreResource(Resource delegate) {
        super(delegate);
    }

    public void setCredentialStoreServiceController(ServiceController<CredentialStore> credentialStoreServiceController) {
        this.credentialStoreServiceController = credentialStoreServiceController;
    }

    public Set<String> getChildTypes() {
        if (this.containsAliases()) {
            return Collections.singleton("alias");
        }
        return Collections.emptySet();
    }

    public boolean hasChildren(String childType) {
        return "alias".equals(childType) && this.containsAliases();
    }

    public boolean hasChild(PathElement element) {
        if ("alias".equals(element.getKey())) {
            try {
                CredentialStore credentialStore;
                CredentialStore credentialStore2 = credentialStore = this.credentialStoreServiceController != null ? (CredentialStore)this.credentialStoreServiceController.getValue() : null;
                if (credentialStore != null && credentialStore.getAliases().contains(this.toLower(element.getValue()))) {
                    return true;
                }
            }
            catch (CredentialStoreException e) {
                ElytronSubsystemMessages.ROOT_LOGGER.credentialStoreIssueEncountered((Exception)((Object)e));
            }
            return false;
        }
        return super.hasChild(element);
    }

    public Resource getChild(PathElement element) {
        if ("alias".equals(element.getKey())) {
            try {
                CredentialStore credentialStore;
                CredentialStore credentialStore2 = credentialStore = this.credentialStoreServiceController != null ? (CredentialStore)this.credentialStoreServiceController.getValue() : null;
                if (credentialStore != null && credentialStore.getAliases().contains(this.toLower(element.getValue()))) {
                    return Resource.Factory.create((boolean)true);
                }
            }
            catch (CredentialStoreException e) {
                ElytronSubsystemMessages.ROOT_LOGGER.credentialStoreIssueEncountered((Exception)((Object)e));
            }
            return null;
        }
        return super.getChild(element);
    }

    public Resource requireChild(PathElement element) {
        Resource resource = this.getChild(element);
        if (resource == null) {
            throw new Resource.NoSuchResourceException(element);
        }
        return resource;
    }

    public Set<String> getChildrenNames(String childType) {
        if ("alias".equals(childType)) {
            try {
                CredentialStore credentialStore;
                CredentialStore credentialStore2 = credentialStore = this.credentialStoreServiceController != null ? (CredentialStore)this.credentialStoreServiceController.getValue() : null;
                if (credentialStore != null && credentialStore.isInitialized()) {
                    return credentialStore.getAliases();
                }
            }
            catch (CredentialStoreException e) {
                ElytronSubsystemMessages.ROOT_LOGGER.credentialStoreIssueEncountered((Exception)((Object)e));
            }
            return Collections.emptySet();
        }
        return super.getChildrenNames(childType);
    }

    public Set<Resource.ResourceEntry> getChildren(String childType) {
        if ("alias".equals(childType)) {
            try {
                CredentialStore credentialStore;
                CredentialStore credentialStore2 = credentialStore = this.credentialStoreServiceController != null ? (CredentialStore)this.credentialStoreServiceController.getValue() : null;
                if (credentialStore != null && credentialStore.isInitialized() && credentialStore.getAliases().size() > 0) {
                    Set aliases = credentialStore.getAliases();
                    LinkedHashSet<Resource.ResourceEntry> children = new LinkedHashSet<Resource.ResourceEntry>(aliases.size());
                    children.addAll(aliases.stream().map(alias -> new PlaceholderResource.PlaceholderResourceEntry("alias", alias)).collect(Collectors.toList()));
                    return children;
                }
            }
            catch (CredentialStoreException e) {
                ElytronSubsystemMessages.ROOT_LOGGER.credentialStoreIssueEncountered((Exception)((Object)e));
            }
            return Collections.emptySet();
        }
        return super.getChildren(childType);
    }

    public Resource navigate(PathAddress address) {
        return Resource.Tools.navigate((Resource)this, (PathAddress)address);
    }

    public Resource clone() {
        CredentialStoreResource credentialStoreResource = new CredentialStoreResource(super.clone());
        credentialStoreResource.setCredentialStoreServiceController(this.credentialStoreServiceController);
        return credentialStoreResource;
    }

    private boolean containsAliases() {
        try {
            CredentialStore credentialStore = this.credentialStoreServiceController != null ? (CredentialStore)this.credentialStoreServiceController.getValue() : null;
            return credentialStore != null && credentialStore.isInitialized() && credentialStore.getAliases().size() > 0;
        }
        catch (CredentialStoreException e) {
            return false;
        }
    }

    private String toLower(String parameter) {
        return parameter != null ? parameter.toLowerCase(Locale.ROOT) : null;
    }

    public Resource removeChild(PathElement element) {
        if (!"alias".equals(element.getKey())) {
            return super.removeChild(element);
        }
        return null;
    }

    public void registerChild(PathElement element, int index, Resource resource) {
        if (!"alias".equals(element.getKey())) {
            super.registerChild(element, index, resource);
        } else if (this.getChild(element) != null) {
            throw ControllerLogger.ROOT_LOGGER.duplicateResource(element.getValue());
        }
    }

    public void registerChild(PathElement element, Resource resource) {
        if (!"alias".equals(element.getKey())) {
            super.registerChild(element, resource);
        } else if (this.getChild(element) != null) {
            throw ControllerLogger.ROOT_LOGGER.duplicateResource(element.getValue());
        }
    }
}

