/*
 * Decompiled with CFR 0.152.
 */
package org.xnio;

import java.io.IOException;
import java.util.Collections;
import org.wildfly.client.config.ClientConfiguration;
import org.wildfly.client.config.ConfigXMLParseException;
import org.wildfly.client.config.ConfigurationXMLStreamReader;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Xnio;
import org.xnio.XnioWorker;

final class XnioXmlParser {
    private static final String NS_XNIO_3_5 = "urn:xnio:3.5";

    XnioXmlParser() {
    }

    static XnioWorker parseWorker(Xnio xnio) throws ConfigXMLParseException, IOException {
        return XnioXmlParser.parseWorker(xnio, ClientConfiguration.getInstance());
    }

    static XnioWorker parseWorker(Xnio xnio, ClientConfiguration clientConfiguration) throws ConfigXMLParseException, IOException {
        OptionMap.Builder mapBuilder = OptionMap.builder();
        if (clientConfiguration == null) {
            return null;
        }
        mapBuilder.set(Options.THREAD_DAEMON, true);
        ConfigurationXMLStreamReader reader = clientConfiguration.readConfiguration(Collections.singleton(NS_XNIO_3_5));
        XnioXmlParser.parseWorkerElement(reader, mapBuilder);
        return xnio.createWorker(mapBuilder.getMap());
    }

    private static void parseWorkerElement(ConfigurationXMLStreamReader reader, OptionMap.Builder mapBuilder) throws ConfigXMLParseException {
        XnioXmlParser.requireNoAttributes(reader);
        int foundBits = 0;
        foundBits = XnioXmlParser.setBit(foundBits, 1);
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    XnioXmlParser.checkElementNamespace(reader);
                    switch (reader.getLocalName()) {
                        case "daemon-threads": {
                            if (XnioXmlParser.isSet(foundBits, 0)) {
                                throw reader.unexpectedElement();
                            }
                            foundBits = XnioXmlParser.setBit(foundBits, 0);
                            XnioXmlParser.parseDaemonThreads(reader, mapBuilder);
                            break block0;
                        }
                        case "worker-name": {
                            if (XnioXmlParser.isSet(foundBits, 1)) {
                                throw reader.unexpectedElement();
                            }
                            foundBits = XnioXmlParser.setBit(foundBits, 1);
                            XnioXmlParser.parseWorkerName(reader, mapBuilder);
                            break block0;
                        }
                        case "pool-size": {
                            if (XnioXmlParser.isSet(foundBits, 2)) {
                                throw reader.unexpectedElement();
                            }
                            foundBits = XnioXmlParser.setBit(foundBits, 2);
                            XnioXmlParser.parsePoolSize(reader, mapBuilder);
                            break block0;
                        }
                        case "task-keepalive": {
                            if (XnioXmlParser.isSet(foundBits, 3)) {
                                throw reader.unexpectedElement();
                            }
                            foundBits = XnioXmlParser.setBit(foundBits, 3);
                            XnioXmlParser.parseTaskKeepalive(reader, mapBuilder);
                            break block0;
                        }
                        case "io-threads": {
                            if (XnioXmlParser.isSet(foundBits, 4)) {
                                throw reader.unexpectedElement();
                            }
                            foundBits = XnioXmlParser.setBit(foundBits, 3);
                            XnioXmlParser.parseIoThreads(reader, mapBuilder);
                            break block0;
                        }
                        case "stack-size": {
                            if (XnioXmlParser.isSet(foundBits, 5)) {
                                throw reader.unexpectedElement();
                            }
                            foundBits = XnioXmlParser.setBit(foundBits, 3);
                            XnioXmlParser.parseStackSize(reader, mapBuilder);
                            break block0;
                        }
                    }
                    throw reader.unexpectedElement();
                }
            }
        }
        throw reader.unexpectedDocumentEnd();
    }

    private static void parseDaemonThreads(ConfigurationXMLStreamReader reader, OptionMap.Builder mapBuilder) throws ConfigXMLParseException {
        XnioXmlParser.requireSingleAttribute(reader, "value");
        boolean daemon = reader.getBooleanAttributeValue(0);
        if (!reader.hasNext()) {
            throw reader.unexpectedDocumentEnd();
        }
        if (reader.nextTag() != 2) {
            throw reader.unexpectedElement();
        }
        mapBuilder.set(Options.THREAD_DAEMON, daemon);
    }

    private static void parseWorkerName(ConfigurationXMLStreamReader reader, OptionMap.Builder mapBuilder) throws ConfigXMLParseException {
        XnioXmlParser.requireSingleAttribute(reader, "value");
        String name = reader.getAttributeValue(0);
        if (!reader.hasNext()) {
            throw reader.unexpectedDocumentEnd();
        }
        if (reader.nextTag() != 2) {
            throw reader.unexpectedElement();
        }
        mapBuilder.set(Options.WORKER_NAME, name);
    }

    private static void parsePoolSize(ConfigurationXMLStreamReader reader, OptionMap.Builder mapBuilder) throws ConfigXMLParseException {
        XnioXmlParser.requireSingleAttribute(reader, "max-threads");
        int threadCount = reader.getIntAttributeValue(0);
        if (!reader.hasNext()) {
            throw reader.unexpectedDocumentEnd();
        }
        if (reader.nextTag() != 2) {
            throw reader.unexpectedElement();
        }
        mapBuilder.set(Options.WORKER_TASK_CORE_THREADS, threadCount);
        mapBuilder.set(Options.WORKER_TASK_MAX_THREADS, threadCount);
    }

    private static void parseTaskKeepalive(ConfigurationXMLStreamReader reader, OptionMap.Builder mapBuilder) throws ConfigXMLParseException {
        XnioXmlParser.requireSingleAttribute(reader, "value");
        int duration = reader.getIntAttributeValue(0);
        if (!reader.hasNext()) {
            throw reader.unexpectedDocumentEnd();
        }
        if (reader.nextTag() != 2) {
            throw reader.unexpectedElement();
        }
        mapBuilder.set(Options.WORKER_TASK_KEEPALIVE, duration);
    }

    private static void parseIoThreads(ConfigurationXMLStreamReader reader, OptionMap.Builder mapBuilder) throws ConfigXMLParseException {
        XnioXmlParser.requireSingleAttribute(reader, "value");
        int threadCount = reader.getIntAttributeValue(0);
        if (!reader.hasNext()) {
            throw reader.unexpectedDocumentEnd();
        }
        if (reader.nextTag() != 2) {
            throw reader.unexpectedElement();
        }
        mapBuilder.set(Options.WORKER_IO_THREADS, threadCount);
    }

    private static void parseStackSize(ConfigurationXMLStreamReader reader, OptionMap.Builder mapBuilder) throws ConfigXMLParseException {
        XnioXmlParser.requireSingleAttribute(reader, "value");
        long stackSize = reader.getLongAttributeValue(0);
        if (!reader.hasNext()) {
            throw reader.unexpectedDocumentEnd();
        }
        if (reader.nextTag() != 2) {
            throw reader.unexpectedElement();
        }
        mapBuilder.set(Options.STACK_SIZE, stackSize);
    }

    private static void checkElementNamespace(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        if (!reader.getNamespaceURI().equals(NS_XNIO_3_5)) {
            throw reader.unexpectedElement();
        }
    }

    private static void checkAttributeNamespace(ConfigurationXMLStreamReader reader, int idx) throws ConfigXMLParseException {
        String attributeNamespace = reader.getAttributeNamespace(idx);
        if (attributeNamespace != null && !attributeNamespace.isEmpty()) {
            throw reader.unexpectedAttribute(idx);
        }
    }

    private static void requireNoAttributes(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        if (attributeCount > 0) {
            throw reader.unexpectedAttribute(0);
        }
    }

    private static void requireSingleAttribute(ConfigurationXMLStreamReader reader, String attributeName) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        if (attributeCount < 1) {
            throw reader.missingRequiredAttribute("", attributeName);
        }
        XnioXmlParser.checkAttributeNamespace(reader, 0);
        if (!reader.getAttributeLocalName(0).equals(attributeName)) {
            throw reader.unexpectedAttribute(0);
        }
        if (attributeCount > 1) {
            throw reader.unexpectedAttribute(1);
        }
    }

    private static boolean isSet(int var, int bit) {
        return (var & 1 << bit) != 0;
    }

    private static int setBit(int var, int bit) {
        return var | 1 << bit;
    }
}

