/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller.validation;

import java.lang.reflect.Array;
import java.util.EnumSet;
import java.util.Set;
import org.jboss.as.clustering.controller.validation.AbstractParameterValidatorBuilder;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;

public class EnumValidatorBuilder<E extends Enum<E>>
extends AbstractParameterValidatorBuilder {
    private final Class<E> enumClass;
    private final Set<E> allowed;

    public EnumValidatorBuilder(Class<E> enumClass) {
        this(enumClass, EnumSet.allOf(enumClass));
    }

    public EnumValidatorBuilder(Class<E> enumClass, Set<E> allowed) {
        this.enumClass = enumClass;
        this.allowed = allowed;
    }

    @Override
    public ParameterValidator build() {
        return new EnumValidator(this.enumClass, this.allowsUndefined, this.allowsExpressions, this.allowed.toArray((Enum[])Array.newInstance(this.enumClass, this.allowed.size())));
    }
}

