/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.client.config;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;
import org.wildfly.client.config.ConfigXMLParseException;
import org.wildfly.client.config.ConfigurationXMLStreamReader;
import org.wildfly.client.config.SelectingXMLStreamReader;
import org.wildfly.client.config.XIncludeXMLStreamReader;
import org.wildfly.client.config._private.ConfigMessages;

public class ClientConfiguration {
    private final XMLInputFactory xmlInputFactory;
    private final URI configurationUri;

    ClientConfiguration(XMLInputFactory xmlInputFactory, URI configurationUri) {
        this.xmlInputFactory = xmlInputFactory;
        this.configurationUri = configurationUri;
    }

    XMLInputFactory getXmlInputFactory() {
        return this.xmlInputFactory;
    }

    public URI getConfigurationUri() {
        return this.configurationUri;
    }

    public ConfigurationXMLStreamReader readConfiguration(Set<String> recognizedNamespaces) throws ConfigXMLParseException {
        XIncludeXMLStreamReader reader = new XIncludeXMLStreamReader(ConfigurationXMLStreamReader.openUri(this.configurationUri, this.xmlInputFactory));
        try {
            if (reader.hasNext()) {
                switch (reader.nextTag()) {
                    case 1: {
                        String namespaceURI = reader.getNamespaceURI();
                        String localName = reader.getLocalName();
                        if (namespaceURI != null && namespaceURI.length() > 0 || !"configuration".equals(localName)) {
                            if (namespaceURI == null) {
                                throw ConfigMessages.msg.unexpectedElement(localName, reader.getLocation());
                            }
                            throw ConfigMessages.msg.unexpectedElement(localName, namespaceURI, reader.getLocation());
                        }
                        return new SelectingXMLStreamReader(true, reader, recognizedNamespaces);
                    }
                }
                throw ConfigMessages.msg.unexpectedContent(ConfigurationXMLStreamReader.eventToString(reader.getEventType()), reader.getLocation());
            }
            reader.close();
            return null;
        }
        catch (Throwable t) {
            try {
                reader.close();
            }
            catch (Throwable t2) {
                t.addSuppressed(t2);
            }
            throw t;
        }
    }

    public static ClientConfiguration getInstance(URI configurationUri) {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newFactory();
        xmlInputFactory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
        xmlInputFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        return new ClientConfiguration(xmlInputFactory, configurationUri);
    }

    public static ClientConfiguration getInstance() {
        URL resource;
        String wildFlyConfig = System.getProperty("wildfly.config.url");
        if (wildFlyConfig != null) {
            URI uri;
            try {
                uri = new URI(wildFlyConfig);
                if (!uri.isAbsolute()) {
                    uri = new URI("file", "", System.getProperty("user.dir"), null).resolve(uri);
                }
            }
            catch (URISyntaxException e) {
                return null;
            }
            return ClientConfiguration.getInstance(uri);
        }
        SecurityManager sm = System.getSecurityManager();
        ClassLoader classLoader = sm != null ? AccessController.doPrivileged(ClientConfiguration::getContextClassLoader) : ClientConfiguration.getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClientConfiguration.class.getClassLoader();
        }
        if ((resource = classLoader.getResource("wildfly-config.xml")) == null && (resource = classLoader.getResource("META-INF/wildfly-config.xml")) == null) {
            return null;
        }
        try {
            return new ClientConfiguration(XMLInputFactory.newFactory(), resource.toURI());
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    private static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }
}

