/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PropertiesAttributeDefinition;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.security.Attribute;
import org.jboss.as.security.ComplexAttributes;
import org.jboss.as.security.Element;
import org.jboss.as.security.JASPIMappingModuleDefinition;
import org.jboss.as.security.JSSEResourceDefinition;
import org.jboss.as.security.LoginModuleResourceDefinition;
import org.jboss.as.security.MappingModuleDefinition;
import org.jboss.as.security.ModulesMap;
import org.jboss.as.security.Namespace;
import org.jboss.as.security.SecurityDomainResourceDefinition;
import org.jboss.as.security.SecuritySubsystemRootResourceDefinition;
import org.jboss.as.security.VaultResourceDefinition;
import org.jboss.as.security.logging.SecurityLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class SecuritySubsystemParser
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>>,
ModulesMap {
    public static final SecuritySubsystemParser INSTANCE = new SecuritySubsystemParser();
    private Map<String, Integer> moduleNames;

    protected SecuritySubsystemParser() {
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"security")});
        ModelNode subsystemNode = Util.createAddOperation((PathAddress)address);
        operations.add(subsystemNode);
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        EnumSet<Element> visited = EnumSet.noneOf(Element.class);
        while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!visited.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            this.readElement(reader, element, operations, address, subsystemNode);
        }
    }

    protected void readElement(XMLExtendedStreamReader reader, Element element, List<ModelNode> operations, PathAddress subsystemPath, ModelNode subsystemNode) throws XMLStreamException {
        switch (element) {
            case SECURITY_MANAGEMENT: {
                this.parseSecurityManagement(reader, subsystemNode);
                break;
            }
            case SECURITY_DOMAINS: {
                List<ModelNode> securityDomainsUpdates = this.parseSecurityDomains(reader, subsystemPath);
                if (securityDomainsUpdates == null) break;
                operations.addAll(securityDomainsUpdates);
                break;
            }
            case SECURITY_PROPERTIES: {
                reader.discardRemainder();
                break;
            }
            case VAULT: {
                Namespace schemaVer = Namespace.forUri(reader.getNamespaceURI());
                if (schemaVer == Namespace.SECURITY_1_0) {
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                int count = reader.getAttributeCount();
                ModelNode vault = this.createAddOperation(subsystemPath, "vault", "classic");
                if (count > 1) {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)count);
                }
                block9: for (int i = 0; i < count; ++i) {
                    ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                    String value = reader.getAttributeValue(i);
                    Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                    switch (attribute) {
                        case CODE: {
                            vault.get("code").set(value);
                            continue block9;
                        }
                        default: {
                            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                        }
                    }
                }
                this.parseProperties(Element.VAULT_OPTION.getLocalName(), reader, vault, VaultResourceDefinition.OPTIONS);
                operations.add(vault);
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }
    }

    private void parseSecurityManagement(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case DEEP_COPY_SUBJECT_MODE: {
                    SecuritySubsystemRootResourceDefinition.DEEP_COPY_SUBJECT_MODE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block4;
                }
                case INITIALIZE_JACC: {
                    SecuritySubsystemRootResourceDefinition.INITIALIZE_JACC.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private List<ModelNode> parseSecurityDomains(XMLExtendedStreamReader reader, PathAddress parentAddress) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ArrayList<ModelNode> list = new ArrayList<ModelNode>();
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SECURITY_DOMAIN: {
                    this.parseSecurityDomain(list, reader, parentAddress);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return list;
    }

    private void parseSecurityDomain(List<ModelNode> list, XMLExtendedStreamReader reader, PathAddress parentAddress) throws XMLStreamException {
        ModelNode op = Util.createAddOperation();
        list.add(op);
        PathElement secDomainPath = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block14: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    if (value == null || value.length() == 0) {
                        throw ParseUtils.invalidAttributeValue((XMLExtendedStreamReader)reader, (int)i);
                    }
                    secDomainPath = PathElement.pathElement((String)"security-domain", (String)value);
                    continue block14;
                }
                case CACHE_TYPE: {
                    SecurityDomainResourceDefinition.CACHE_TYPE.parseAndSetParameter(value, op, (XMLStreamReader)reader);
                    continue block14;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        PathAddress address = parentAddress.append(new PathElement[]{secDomainPath});
        op.get("address").set(address.toModelNode());
        EnumSet<Element> visited = EnumSet.noneOf(Element.class);
        this.moduleNames = new HashMap<String, Integer>();
        block15: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!visited.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case AUTHENTICATION: {
                    if (visited.contains((Object)Element.AUTHENTICATION_JASPI)) {
                        throw SecurityLogger.ROOT_LOGGER.xmlStreamExceptionAuth(reader.getLocation());
                    }
                    this.parseAuthentication(list, address, reader);
                    continue block15;
                }
                case AUTHORIZATION: {
                    this.parseAuthorization(list, address, reader);
                    continue block15;
                }
                case ACL: {
                    this.parseACL(list, address, reader);
                    continue block15;
                }
                case AUDIT: {
                    this.parseAudit(list, address, reader);
                    continue block15;
                }
                case IDENTITY_TRUST: {
                    this.parseIdentityTrust(list, address, reader);
                    continue block15;
                }
                case MAPPING: {
                    this.parseMapping(list, address, reader);
                    continue block15;
                }
                case AUTHENTICATION_JASPI: {
                    if (visited.contains((Object)Element.AUTHENTICATION)) {
                        throw SecurityLogger.ROOT_LOGGER.xmlStreamExceptionAuth(reader.getLocation());
                    }
                    this.parseAuthenticationJaspi(list, address, reader);
                    continue block15;
                }
                case JSSE: {
                    this.parseJSSE(list, address, reader);
                    continue block15;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        this.moduleNames.clear();
    }

    private void parseAuthentication(List<ModelNode> list, PathAddress parentAddress, XMLExtendedStreamReader reader) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        PathAddress address = parentAddress.append("authentication", "classic");
        ModelNode op = Util.createAddOperation((PathAddress)address);
        list.add(op);
        this.parseLoginModules(reader, address, list);
    }

    private void parseLoginModules(XMLExtendedStreamReader reader, PathAddress parentAddress, List<ModelNode> list) throws XMLStreamException {
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case LOGIN_MODULE: {
                    EnumSet<Attribute> required = EnumSet.of(Attribute.CODE, Attribute.FLAG);
                    EnumSet<Attribute> notAllowed = EnumSet.of(Attribute.TYPE, Attribute.LOGIN_MODULE_STACK_REF);
                    this.parseCommonModule(reader, parentAddress, "login-module", required, notAllowed, list);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private ModelNode appendAddOperation(List<ModelNode> list, PathAddress parentAddress, String name, String value) {
        ModelNode op = this.createAddOperation(parentAddress, name, value);
        list.add(op);
        return op;
    }

    private ModelNode createAddOperation(PathAddress parentAddress, String name, String value) {
        return Util.createAddOperation((PathAddress)parentAddress.append(name, value));
    }

    private void parseAuthorization(List<ModelNode> list, PathAddress parentAddress, XMLExtendedStreamReader reader) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        PathAddress address = parentAddress.append("authorization", "classic");
        ModelNode op = Util.createAddOperation((PathAddress)address);
        list.add(op);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case POLICY_MODULE: {
                    EnumSet<Attribute> required = EnumSet.of(Attribute.CODE, Attribute.FLAG);
                    EnumSet<Attribute> notAllowed = EnumSet.of(Attribute.TYPE, Attribute.LOGIN_MODULE_STACK_REF);
                    this.parseCommonModule(reader, address, "policy-module", required, notAllowed, list);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseACL(List<ModelNode> list, PathAddress parentAddress, XMLExtendedStreamReader reader) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        PathAddress address = parentAddress.append("acl", "classic");
        ModelNode op = Util.createAddOperation((PathAddress)address);
        list.add(op);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ACL_MODULE: {
                    EnumSet<Attribute> required = EnumSet.of(Attribute.CODE, Attribute.FLAG);
                    EnumSet<Attribute> notAllowed = EnumSet.of(Attribute.TYPE, Attribute.LOGIN_MODULE_STACK_REF);
                    this.parseCommonModule(reader, address, "acl-module", required, notAllowed, list);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseAudit(List<ModelNode> list, PathAddress parentAddress, XMLExtendedStreamReader reader) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        PathAddress address = parentAddress.append("audit", "classic");
        ModelNode op = Util.createAddOperation((PathAddress)address);
        list.add(op);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROVIDER_MODULE: {
                    EnumSet<Attribute> required = EnumSet.of(Attribute.CODE);
                    EnumSet<Attribute> notAllowed = EnumSet.of(Attribute.TYPE, Attribute.FLAG, Attribute.LOGIN_MODULE_STACK_REF);
                    this.parseCommonModule(reader, address, "provider-module", required, notAllowed, list);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseIdentityTrust(List<ModelNode> list, PathAddress parentAddress, XMLExtendedStreamReader reader) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        PathAddress address = parentAddress.append("identity-trust", "classic");
        ModelNode op = Util.createAddOperation((PathAddress)address);
        list.add(op);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case TRUST_MODULE: {
                    EnumSet<Attribute> required = EnumSet.of(Attribute.CODE, Attribute.FLAG);
                    EnumSet<Attribute> notAllowed = EnumSet.of(Attribute.TYPE, Attribute.LOGIN_MODULE_STACK_REF);
                    this.parseCommonModule(reader, address, "trust-module", required, notAllowed, list);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseMapping(List<ModelNode> list, PathAddress parentAddress, XMLExtendedStreamReader reader) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        PathAddress address = parentAddress.append("mapping", "classic");
        ModelNode op = Util.createAddOperation((PathAddress)address);
        list.add(op);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case MAPPING_MODULE: {
                    EnumSet<Attribute> required = EnumSet.of(Attribute.CODE);
                    EnumSet<Attribute> notAllowed = EnumSet.of(Attribute.FLAG, Attribute.LOGIN_MODULE_STACK_REF);
                    this.parseCommonModule(reader, address, "mapping-module", required, notAllowed, list);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseCommonModule(XMLExtendedStreamReader reader, PathAddress parentAddress, String keyName, EnumSet<Attribute> required, EnumSet<Attribute> notAllowed, List<ModelNode> list) throws XMLStreamException {
        String key;
        ModelNode node = Util.createAddOperation((PathAddress)parentAddress);
        String code = null;
        String name = null;
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            if (notAllowed.contains((Object)attribute)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            required.remove((Object)attribute);
            switch (attribute) {
                case CODE: {
                    code = value;
                    LoginModuleResourceDefinition.CODE.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    continue block8;
                }
                case FLAG: {
                    LoginModuleResourceDefinition.FLAG.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    continue block8;
                }
                case TYPE: {
                    MappingModuleDefinition.TYPE.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    continue block8;
                }
                case MODULE: {
                    LoginModuleResourceDefinition.MODULE.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    continue block8;
                }
                case LOGIN_MODULE_STACK_REF: {
                    JASPIMappingModuleDefinition.LOGIN_MODULE_STACK_REF.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    continue block8;
                }
                case NAME: {
                    name = value;
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            name = code;
        }
        if (this.moduleNames.put(key = keyName + "-" + name, 1) != null) {
            int i = 2;
            while (true) {
                name = code + "-" + i;
                key = keyName + "-" + name;
                if (!this.moduleNames.containsKey(key)) {
                    this.moduleNames.put(key, i);
                    break;
                }
                ++i;
            }
        }
        node.get("address").set(parentAddress.append(keyName, name).toModelNode());
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        this.parseProperties(Element.MODULE_OPTION.getLocalName(), reader, node, LoginModuleResourceDefinition.MODULE_OPTIONS);
        list.add(node);
    }

    private void parseAuthenticationJaspi(List<ModelNode> list, PathAddress parentAddress, XMLExtendedStreamReader reader) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        PathAddress address = parentAddress.append("authentication", "jaspi");
        ModelNode op = Util.createAddOperation((PathAddress)address);
        list.add(op);
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case LOGIN_MODULE_STACK: {
                    this.parseLoginModuleStack(list, address, reader);
                    continue block4;
                }
                case AUTH_MODULE: {
                    this.parseAuthModule(list, reader, address);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseAuthModule(List<ModelNode> list, XMLExtendedStreamReader reader, PathAddress parentAddress) throws XMLStreamException {
        EnumSet<Attribute> notAllowed;
        Namespace schemaVer = Namespace.forUri(reader.getNamespaceURI());
        EnumSet<Attribute> required = EnumSet.of(Attribute.CODE);
        switch (schemaVer) {
            case SECURITY_1_0: 
            case SECURITY_1_1: {
                notAllowed = EnumSet.of(Attribute.TYPE, Attribute.FLAG);
                break;
            }
            default: {
                notAllowed = EnumSet.of(Attribute.TYPE);
            }
        }
        this.parseCommonModule(reader, parentAddress, "auth-module", required, notAllowed, list);
    }

    private void parseLoginModuleStack(List<ModelNode> list, PathAddress parentAddress, XMLExtendedStreamReader reader) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        String name = null;
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    if (value == null) {
                        throw ParseUtils.invalidAttributeValue((XMLExtendedStreamReader)reader, (int)i);
                    }
                    name = value;
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        PathAddress address = parentAddress.append("login-module-stack", name);
        ModelNode op = Util.createAddOperation((PathAddress)address);
        list.add(op);
        this.parseLoginModules(reader, address, list);
    }

    private void parseProperties(String childElementName, XMLExtendedStreamReader reader, ModelNode node, PropertiesAttributeDefinition attribute) throws XMLStreamException {
        while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!childElementName.equals(element.getLocalName())) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            String[] array = ParseUtils.requireAttributes((XMLExtendedStreamReader)reader, (String[])new String[]{org.jboss.as.controller.parsing.Attribute.NAME.getLocalName(), org.jboss.as.controller.parsing.Attribute.VALUE.getLocalName()});
            attribute.parseAndAddParameterElement(array[0], array[1], node, reader);
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        }
    }

    private void parseJSSE(List<ModelNode> list, PathAddress parentAddress, XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode op = this.appendAddOperation(list, parentAddress, "jsse", "classic");
        EnumSet<Attribute> visited = EnumSet.noneOf(Attribute.class);
        EnumSet<Attribute> required = EnumSet.noneOf(Attribute.class);
        int count = reader.getAttributeCount();
        block22: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case KEYSTORE_PASSWORD: {
                    ComplexAttributes.PASSWORD.parseAndSetParameter(value, op.get("keystore"), (XMLStreamReader)reader);
                    visited.add(attribute);
                    continue block22;
                }
                case KEYSTORE_TYPE: {
                    ComplexAttributes.TYPE.parseAndSetParameter(value, op.get("keystore"), (XMLStreamReader)reader);
                    required.add(Attribute.KEYSTORE_PASSWORD);
                    continue block22;
                }
                case KEYSTORE_URL: {
                    ComplexAttributes.URL.parseAndSetParameter(value, op.get("keystore"), (XMLStreamReader)reader);
                    required.add(Attribute.KEYSTORE_PASSWORD);
                    continue block22;
                }
                case KEYSTORE_PROVIDER: {
                    ComplexAttributes.PROVIDER.parseAndSetParameter(value, op.get("keystore"), (XMLStreamReader)reader);
                    required.add(Attribute.KEYSTORE_PASSWORD);
                    continue block22;
                }
                case KEYSTORE_PROVIDER_ARGUMENT: {
                    ComplexAttributes.PROVIDER_ARGUMENT.parseAndSetParameter(value, op.get("keystore"), (XMLStreamReader)reader);
                    required.add(Attribute.KEYSTORE_PASSWORD);
                    continue block22;
                }
                case KEY_MANAGER_FACTORY_PROVIDER: {
                    ComplexAttributes.PROVIDER.parseAndSetParameter(value, op.get("key-manager"), (XMLStreamReader)reader);
                    continue block22;
                }
                case KEY_MANAGER_FACTORY_ALGORITHM: {
                    ComplexAttributes.ALGORITHM.parseAndSetParameter(value, op.get("key-manager"), (XMLStreamReader)reader);
                    continue block22;
                }
                case TRUSTSTORE_PASSWORD: {
                    ComplexAttributes.PASSWORD.parseAndSetParameter(value, op.get("truststore"), (XMLStreamReader)reader);
                    visited.add(attribute);
                    continue block22;
                }
                case TRUSTSTORE_TYPE: {
                    ComplexAttributes.TYPE.parseAndSetParameter(value, op.get("truststore"), (XMLStreamReader)reader);
                    required.add(Attribute.TRUSTSTORE_PASSWORD);
                    continue block22;
                }
                case TRUSTSTORE_URL: {
                    ComplexAttributes.URL.parseAndSetParameter(value, op.get("truststore"), (XMLStreamReader)reader);
                    required.add(Attribute.TRUSTSTORE_PASSWORD);
                    continue block22;
                }
                case TRUSTSTORE_PROVIDER: {
                    ComplexAttributes.PROVIDER.parseAndSetParameter(value, op.get("truststore"), (XMLStreamReader)reader);
                    required.add(Attribute.TRUSTSTORE_PASSWORD);
                    continue block22;
                }
                case TRUSTSTORE_PROVIDER_ARGUMENT: {
                    ComplexAttributes.PROVIDER_ARGUMENT.parseAndSetParameter(value, op.get("truststore"), (XMLStreamReader)reader);
                    required.add(Attribute.TRUSTSTORE_PASSWORD);
                    continue block22;
                }
                case TRUST_MANAGER_FACTORY_PROVIDER: {
                    ComplexAttributes.PROVIDER.parseAndSetParameter(value, op.get("trust-manager"), (XMLStreamReader)reader);
                    continue block22;
                }
                case TRUST_MANAGER_FACTORY_ALGORITHM: {
                    ComplexAttributes.ALGORITHM.parseAndSetParameter(value, op.get("trust-manager"), (XMLStreamReader)reader);
                    continue block22;
                }
                case CLIENT_ALIAS: {
                    JSSEResourceDefinition.CLIENT_ALIAS.parseAndSetParameter(value, op, (XMLStreamReader)reader);
                    continue block22;
                }
                case SERVER_ALIAS: {
                    JSSEResourceDefinition.SERVER_ALIAS.parseAndSetParameter(value, op, (XMLStreamReader)reader);
                    continue block22;
                }
                case CLIENT_AUTH: {
                    JSSEResourceDefinition.CLIENT_AUTH.parseAndSetParameter(value, op, (XMLStreamReader)reader);
                    continue block22;
                }
                case SERVICE_AUTH_TOKEN: {
                    JSSEResourceDefinition.SERVICE_AUTH_TOKEN.parseAndSetParameter(value, op, (XMLStreamReader)reader);
                    continue block22;
                }
                case CIPHER_SUITES: {
                    JSSEResourceDefinition.CIPHER_SUITES.parseAndSetParameter(value, op, (XMLStreamReader)reader);
                    continue block22;
                }
                case PROTOCOLS: {
                    JSSEResourceDefinition.PROTOCOLS.parseAndSetParameter(value, op, (XMLStreamReader)reader);
                    continue block22;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!visited.containsAll(required)) {
            throw SecurityLogger.ROOT_LOGGER.xmlStreamExceptionMissingAttribute(Attribute.KEYSTORE_PASSWORD.getLocalName(), Attribute.TRUSTSTORE_PASSWORD.getLocalName(), reader.getLocation());
        }
        this.parseProperties(Element.PROPERTY.getLocalName(), reader, op, JSSEResourceDefinition.ADDITIONAL_PROPERTIES);
    }
}

