/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.remoting;

import java.security.Principal;
import java.util.Set;
import java.util.stream.StreamSupport;
import javax.security.auth.Subject;
import org.jboss.as.core.security.RealmGroup;
import org.jboss.as.core.security.RealmRole;
import org.jboss.as.core.security.RealmUser;
import org.jboss.remoting3.Connection;
import org.wildfly.security.auth.server.SecurityIdentity;

public final class RemotingConnectionCredential {
    private final Connection connection;
    private final Subject subject;

    public RemotingConnectionCredential(Connection connection) {
        this.connection = connection;
        Subject subject = new Subject();
        SecurityIdentity localIdentity = connection.getLocalIdentity();
        if (localIdentity != null) {
            Set<Principal> principals = subject.getPrincipals();
            principals.add((Principal)new RealmUser(localIdentity.getPrincipal().getName()));
            StreamSupport.stream(localIdentity.getRoles().spliterator(), true).forEach(role -> {
                principals.add((Principal)new RealmGroup(role));
                principals.add((Principal)new RealmRole(role));
            });
        }
        this.subject = subject;
    }

    Connection getConnection() {
        return this.connection;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public int hashCode() {
        return this.connection.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof RemotingConnectionCredential ? this.equals((RemotingConnectionCredential)obj) : false;
    }

    public boolean equals(RemotingConnectionCredential obj) {
        return this.connection.equals(obj.connection);
    }
}

