/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.service;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.acl.Group;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import org.jboss.as.core.security.ServerSecurityManager;
import org.jboss.as.security.logging.SecurityLogger;
import org.jboss.as.security.remoting.RemotingConnectionCredential;
import org.jboss.as.security.service.SecurityActions;
import org.jboss.as.security.service.ThreadLocalStack;
import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;
import org.jboss.remoting3.Connection;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.ISecurityManagement;
import org.jboss.security.RunAs;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SecurityContextFactory;
import org.jboss.security.SecurityContextUtil;
import org.jboss.security.SecurityRolesAssociation;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.SubjectInfo;
import org.jboss.security.audit.AuditEvent;
import org.jboss.security.audit.AuditManager;
import org.jboss.security.authorization.Resource;
import org.jboss.security.authorization.resources.EJBResource;
import org.jboss.security.identity.Identity;
import org.jboss.security.identity.RoleGroup;
import org.jboss.security.identity.plugins.SimpleIdentity;
import org.jboss.security.identity.plugins.SimpleRoleGroup;
import org.jboss.security.javaee.AbstractEJBAuthorizationHelper;
import org.jboss.security.javaee.SecurityHelperFactory;
import org.jboss.security.javaee.SecurityRoleRef;
import org.wildfly.security.auth.server.IdentityCredentials;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.password.interfaces.ClearPassword;

public class SimpleSecurityManager
implements ServerSecurityManager {
    private ThreadLocalStack<SecurityContext> contexts = new ThreadLocalStack();
    private boolean propagate = true;
    private ISecurityManagement securityManagement = null;

    public SimpleSecurityManager() {
    }

    public SimpleSecurityManager(SimpleSecurityManager delegate) {
        this.securityManagement = delegate.securityManagement;
        this.propagate = false;
    }

    private PrivilegedAction<SecurityContext> securityContext() {
        return new PrivilegedAction<SecurityContext>(){

            @Override
            public SecurityContext run() {
                return SecurityContextAssociation.getSecurityContext();
            }
        };
    }

    private SecurityContext establishSecurityContext(String securityDomain) {
        try {
            SecurityContext securityContext = SecurityContextFactory.createSecurityContext((String)securityDomain);
            if (this.securityManagement == null) {
                throw SecurityLogger.ROOT_LOGGER.securityManagementNotInjected();
            }
            securityContext.setSecurityManagement(this.securityManagement);
            SecurityContextAssociation.setSecurityContext((SecurityContext)securityContext);
            return securityContext;
        }
        catch (Exception e) {
            throw SecurityLogger.ROOT_LOGGER.securityException(e);
        }
    }

    public void setSecurityManagement(ISecurityManagement iSecurityManagement) {
        this.securityManagement = iSecurityManagement;
    }

    public Principal getCallerPrincipal() {
        SecurityContext securityContext = AccessController.doPrivileged(this.securityContext());
        if (securityContext == null) {
            return this.getUnauthenticatedIdentity().asPrincipal();
        }
        Object principal = securityContext.getIncomingRunAs();
        if (principal == null) {
            principal = this.getPrincipal(this.getSubjectInfo(securityContext).getAuthenticatedSubject());
        }
        if (principal == null) {
            return this.getUnauthenticatedIdentity().asPrincipal();
        }
        return principal;
    }

    public Subject getSubject() {
        SecurityContext securityContext = AccessController.doPrivileged(this.securityContext());
        if (securityContext != null) {
            return this.getSubjectInfo(securityContext).getAuthenticatedSubject();
        }
        return null;
    }

    private Principal getPrincipal(Subject subject) {
        Set<Principal> principals;
        Principal principal = null;
        Principal callerPrincipal = null;
        if (subject != null && (principals = subject.getPrincipals()) != null && !principals.isEmpty()) {
            for (Principal p : principals) {
                Enumeration e;
                Group g;
                if (!(p instanceof Group) && principal == null) {
                    principal = p;
                }
                if (!(p instanceof Group) || !(g = (Group)Group.class.cast(p)).getName().equals("CallerPrincipal") || callerPrincipal != null || !(e = g.members()).hasMoreElements()) continue;
                callerPrincipal = (Principal)e.nextElement();
            }
        }
        return callerPrincipal == null ? principal : callerPrincipal;
    }

    @Deprecated
    public boolean isCallerInRole(String ejbName, Object mappedRoles, Map<String, Collection<String>> roleLinks, String ... roleNames) {
        return this.isCallerInRole(ejbName, PolicyContext.getContextID(), mappedRoles, roleLinks, roleNames);
    }

    public boolean isCallerInRole(String ejbName, String policyContextID, Object incommingMappedRoles, Map<String, Collection<String>> roleLinks, String ... roleNames) {
        SecurityContext securityContext = AccessController.doPrivileged(this.securityContext());
        if (securityContext == null) {
            return false;
        }
        EJBResource resource = new EJBResource(new HashMap());
        resource.setEjbName(ejbName);
        resource.setPolicyContextID(policyContextID);
        resource.setCallerRunAsIdentity(securityContext.getIncomingRunAs());
        resource.setCallerSubject(securityContext.getUtil().getSubject());
        Principal userPrincipal = securityContext.getUtil().getUserPrincipal();
        resource.setPrincipal(userPrincipal);
        if (roleLinks != null) {
            HashSet<SecurityRoleRef> roleRefs = new HashSet<SecurityRoleRef>();
            for (String key : roleLinks.keySet()) {
                Collection<String> values = roleLinks.get(key);
                if (values == null) continue;
                for (String value : values) {
                    roleRefs.add(new SecurityRoleRef(key, value));
                }
            }
            resource.setSecurityRoleReferences(roleRefs);
        }
        Map<String, Set<String>> previousRolesAssociationMap = null;
        try {
            if (incommingMappedRoles != null) {
                SecurityRolesMetaData rolesMetaData = (SecurityRolesMetaData)incommingMappedRoles;
                previousRolesAssociationMap = this.setSecurityRolesAssociation(rolesMetaData.getPrincipalVersusRolesMap());
            }
            AbstractEJBAuthorizationHelper helper = SecurityHelperFactory.getEJBAuthorizationHelper((SecurityContext)securityContext);
            for (String roleName : roleNames) {
                if (!helper.isCallerInRole((Resource)resource, roleName)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (incommingMappedRoles != null) {
                this.setSecurityRolesAssociation(previousRolesAssociationMap);
            }
        }
    }

    public boolean authorize(String ejbName, CodeSource ejbCodeSource, String ejbMethodIntf, Method ejbMethod, Set<Principal> methodRoles, String contextID) {
        SecurityContext securityContext = AccessController.doPrivileged(this.securityContext());
        if (securityContext == null) {
            return false;
        }
        EJBResource resource = new EJBResource(new HashMap());
        resource.setEjbName(ejbName);
        resource.setEjbMethod(ejbMethod);
        resource.setEjbMethodInterface(ejbMethodIntf);
        resource.setEjbMethodRoles((RoleGroup)new SimpleRoleGroup(methodRoles));
        resource.setCodeSource(ejbCodeSource);
        resource.setPolicyContextID(contextID);
        resource.setCallerRunAsIdentity(securityContext.getIncomingRunAs());
        resource.setCallerSubject(securityContext.getUtil().getSubject());
        Principal userPrincipal = securityContext.getUtil().getUserPrincipal();
        resource.setPrincipal(userPrincipal);
        try {
            AbstractEJBAuthorizationHelper helper = SecurityHelperFactory.getEJBAuthorizationHelper((SecurityContext)securityContext);
            return helper.authorize((Resource)resource);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void push(String securityDomain) {
        RunAs currentRunAs;
        boolean trusted;
        SecurityContext previous = SecurityContextAssociation.getSecurityContext();
        this.contexts.push(previous);
        SecurityContext current = this.establishSecurityContext(securityDomain);
        if (this.propagate && previous != null) {
            current.setSubjectInfo(this.getSubjectInfo(previous));
            current.setIncomingRunAs(previous.getOutgoingRunAs());
        }
        boolean bl = trusted = (currentRunAs = current.getIncomingRunAs()) != null && currentRunAs instanceof RunAsIdentity;
        if (!trusted && SecurityActions.remotingContextIsSet()) {
            SecurityContextUtil util = current.getUtil();
            Connection connection = SecurityActions.remotingContextGetConnection();
            SimplePrincipal p = null;
            Object credential = null;
            SecurityIdentity localIdentity = connection.getLocalIdentity();
            if (localIdentity != null) {
                p = new SimplePrincipal(localIdentity.getPrincipal().getName());
                IdentityCredentials privateCredentials = localIdentity.getPrivateCredentials();
                PasswordCredential passwordCredential = (PasswordCredential)privateCredentials.getCredential(PasswordCredential.class, "clear");
                credential = passwordCredential != null ? new String(((ClearPassword)passwordCredential.getPassword(ClearPassword.class)).getPassword()) : new RemotingConnectionCredential(connection);
            } else {
                throw SecurityLogger.ROOT_LOGGER.noUserPrincipalFound();
            }
            SecurityActions.remotingContextClear();
            util.createSubjectInfo((Principal)p, credential, null);
        }
    }

    public void push(String securityDomain, String userName, char[] password, Subject subject) {
        RunAs currentRunAs;
        boolean trusted;
        SecurityContext previous = SecurityContextAssociation.getSecurityContext();
        this.contexts.push(previous);
        SecurityContext current = this.establishSecurityContext(securityDomain);
        if (this.propagate && previous != null) {
            current.setSubjectInfo(this.getSubjectInfo(previous));
            current.setIncomingRunAs(previous.getOutgoingRunAs());
        }
        boolean bl = trusted = (currentRunAs = current.getIncomingRunAs()) != null && currentRunAs instanceof RunAsIdentity;
        if (!trusted) {
            SecurityContextUtil util = current.getUtil();
            util.createSubjectInfo((Principal)new SimplePrincipal(userName), (Object)new String(password), subject);
        }
    }

    public void authenticate() {
        this.authenticate(null, null, null);
    }

    public void authenticate(String runAs, String runAsPrincipal, Set<String> extraRoles) {
        boolean skipReauthentication;
        SecurityContext current = SecurityContextAssociation.getSecurityContext();
        SecurityContext previous = this.contexts.peek();
        boolean bl = skipReauthentication = current.getSubjectInfo() != null && current.getSubjectInfo().getAuthenticatedSubject() != null && previous != null && current.getSecurityDomain().equals(previous.getSecurityDomain());
        if (!skipReauthentication) {
            SecurityContextUtil util = current.getUtil();
            Object credential = util.getCredential();
            Subject subject = null;
            if (credential instanceof RemotingConnectionCredential) {
                subject = ((RemotingConnectionCredential)credential).getSubject();
            }
            if (!this.authenticate(current, subject)) {
                throw SecurityLogger.ROOT_LOGGER.invalidUserException();
            }
        }
        if (runAs != null) {
            RunAsIdentity runAsIdentity = new RunAsIdentity(runAs, runAsPrincipal, extraRoles);
            current.setOutgoingRunAs((RunAs)runAsIdentity);
        } else if (this.propagate && previous != null && previous.getOutgoingRunAs() != null) {
            current.setOutgoingRunAs(previous.getOutgoingRunAs());
        }
    }

    private boolean authenticate(SecurityContext context, Subject subject) {
        AuditManager auditManager;
        Principal principal;
        SecurityContextUtil util = context.getUtil();
        SubjectInfo subjectInfo = this.getSubjectInfo(context);
        if (subject == null) {
            subject = new Subject();
        }
        Principal auditPrincipal = principal = util.getUserPrincipal();
        Object credential = util.getCredential();
        Identity unauthenticatedIdentity = null;
        boolean authenticated = false;
        if (principal == null) {
            unauthenticatedIdentity = this.getUnauthenticatedIdentity();
            subjectInfo.addIdentity(unauthenticatedIdentity);
            auditPrincipal = unauthenticatedIdentity.asPrincipal();
            subject.getPrincipals().add(auditPrincipal);
            authenticated = true;
        } else {
            subject.getPrincipals().add(principal);
        }
        if (!authenticated) {
            AuthenticationManager authenticationManager = context.getAuthenticationManager();
            authenticated = authenticationManager.isValid(principal, credential, subject);
        }
        if (authenticated) {
            subjectInfo.setAuthenticatedSubject(subject);
        }
        if ((auditManager = context.getAuditManager()) != null) {
            this.audit(authenticated ? "Success" : "Failure", auditManager, auditPrincipal);
        }
        return authenticated;
    }

    private Identity getUnauthenticatedIdentity() {
        return new SimpleIdentity("anonymous");
    }

    public void pop() {
        SecurityContext sc = this.contexts.pop();
        SecurityContextAssociation.setSecurityContext((SecurityContext)sc);
    }

    private void audit(String level, AuditManager auditManager, Principal userPrincipal) {
        AuditEvent auditEvent = new AuditEvent(level);
        HashMap<String, String> ctxMap = new HashMap<String, String>();
        ctxMap.put("principal", userPrincipal != null ? userPrincipal.getName() : "null");
        ctxMap.put("Source", this.getClass().getCanonicalName());
        ctxMap.put("Action", "authentication");
        auditEvent.setContextMap(ctxMap);
        auditManager.audit(auditEvent);
    }

    private SubjectInfo getSubjectInfo(final SecurityContext context) {
        if (System.getSecurityManager() == null) {
            return context.getSubjectInfo();
        }
        return AccessController.doPrivileged(new PrivilegedAction<SubjectInfo>(){

            @Override
            public SubjectInfo run() {
                return context.getSubjectInfo();
            }
        });
    }

    private Map<String, Set<String>> setSecurityRolesAssociation(Map<String, Set<String>> mappedRoles) {
        if (System.getSecurityManager() == null) {
            Map previousMappedRoles = SecurityRolesAssociation.getSecurityRoles();
            SecurityRolesAssociation.setSecurityRoles(mappedRoles);
            return previousMappedRoles;
        }
        SetSecurityRolesAssociationAction action = new SetSecurityRolesAssociationAction(mappedRoles);
        return AccessController.doPrivileged(action);
    }

    private static class SetSecurityRolesAssociationAction
    implements PrivilegedAction<Map<String, Set<String>>> {
        private final Map<String, Set<String>> mappedRoles;

        SetSecurityRolesAssociationAction(Map<String, Set<String>> mappedRoles) {
            this.mappedRoles = mappedRoles;
        }

        @Override
        public Map<String, Set<String>> run() {
            Map previousMappedRoles = SecurityRolesAssociation.getSecurityRoles();
            SecurityRolesAssociation.setSecurityRoles(this.mappedRoles);
            return previousMappedRoles;
        }
    }
}

