/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.discovery;

import java.util.Collection;
import java.util.Map;
import org.wildfly.discovery.AttributeValue;
import org.wildfly.discovery.FilterSpec;

class EqualsFilterSpec
extends FilterSpec {
    private final String attribute;
    private final AttributeValue value;

    EqualsFilterSpec(String attribute, AttributeValue value) {
        this.attribute = attribute;
        this.value = value;
    }

    @Override
    public boolean matchesSimple(Map<String, AttributeValue> attributes) {
        return this.value.equals(attributes.get(this.attribute));
    }

    @Override
    public boolean matchesMulti(Map<String, ? extends Collection<AttributeValue>> attributes) {
        Collection<AttributeValue> collection = attributes.get(this.attribute);
        return collection != null && collection.contains(this.value);
    }

    @Override
    void toString(StringBuilder builder) {
        builder.append('(');
        FilterSpec.escapeTo(this.attribute, builder);
        builder.append('=');
        builder.append(this.value);
        builder.append(')');
    }
}

