/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.DisallowedMethodsHandler;
import io.undertow.server.handlers.PeerNameResolvingHandler;
import io.undertow.servlet.handlers.MarkSecureHandler;
import io.undertow.util.HttpString;
import java.util.HashSet;
import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.network.SocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.io.OptionList;
import org.wildfly.extension.undertow.ListenerResourceDefinition;
import org.wildfly.extension.undertow.ListenerService;
import org.wildfly.extension.undertow.Server;
import org.wildfly.extension.undertow.UndertowListener;
import org.wildfly.extension.undertow.UndertowService;
import org.xnio.OptionMap;
import org.xnio.Pool;
import org.xnio.XnioWorker;

abstract class ListenerAdd
extends AbstractAddStepHandler {
    ListenerAdd(ListenerResourceDefinition definition) {
        super(definition.getAttributes());
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        List disallowedMethods;
        PathAddress address = context.getCurrentAddress();
        PathAddress parent = address.getParent();
        String name = context.getCurrentAddressValue();
        String bindingRef = ListenerResourceDefinition.SOCKET_BINDING.resolveModelAttribute(context, model).asString();
        String workerName = ListenerResourceDefinition.WORKER.resolveModelAttribute(context, model).asString();
        String bufferPoolName = ListenerResourceDefinition.BUFFER_POOL.resolveModelAttribute(context, model).asString();
        boolean enabled = ListenerResourceDefinition.ENABLED.resolveModelAttribute(context, model).asBoolean();
        boolean peerHostLookup = ListenerResourceDefinition.RESOLVE_PEER_ADDRESS.resolveModelAttribute(context, model).asBoolean();
        boolean secure = ListenerResourceDefinition.SECURE.resolveModelAttribute(context, model).asBoolean();
        OptionMap listenerOptions = OptionList.resolveOptions((ExpressionResolver)context, (ModelNode)model, ListenerResourceDefinition.LISTENER_OPTIONS);
        OptionMap socketOptions = OptionList.resolveOptions((ExpressionResolver)context, (ModelNode)model, ListenerResourceDefinition.SOCKET_OPTIONS);
        String serverName = parent.getLastElement().getValue();
        ServiceName listenerServiceName = UndertowService.listenerName(name);
        ListenerService service = this.createService(name, serverName, context, model, listenerOptions, socketOptions);
        if (peerHostLookup) {
            service.addWrapperHandler(new HandlerWrapper(){

                public HttpHandler wrap(HttpHandler handler) {
                    return new PeerNameResolvingHandler(handler);
                }
            });
        }
        service.setEnabled(enabled);
        if (secure) {
            service.addWrapperHandler(MarkSecureHandler.WRAPPER);
        }
        if (!(disallowedMethods = ListenerResourceDefinition.DISALLOWED_METHODS.unwrap((ExpressionResolver)context, model)).isEmpty()) {
            final HashSet<HttpString> methodSet = new HashSet<HttpString>();
            for (String i : disallowedMethods) {
                methodSet.add(new HttpString(i.trim()));
            }
            service.addWrapperHandler(new HandlerWrapper(){

                public HttpHandler wrap(HttpHandler handler) {
                    return new DisallowedMethodsHandler(handler, methodSet);
                }
            });
        }
        ServiceName socketBindingServiceName = context.getCapabilityServiceName("org.wildfly.network.socket-binding", bindingRef, SocketBinding.class);
        ServiceName workerServiceName = context.getCapabilityServiceName("org.wildfly.io.worker", workerName, XnioWorker.class);
        ServiceName bufferPoolServiceName = context.getCapabilityServiceName("org.wildfly.io.buffer-pool", bufferPoolName, Pool.class);
        ServiceBuilder serviceBuilder = context.getServiceTarget().addService(listenerServiceName, (Service)service);
        serviceBuilder.addDependency(workerServiceName, XnioWorker.class, service.getWorker()).addDependency(socketBindingServiceName, SocketBinding.class, service.getBinding()).addDependency(bufferPoolServiceName, service.getBufferPool()).addDependency(UndertowService.SERVER.append(new String[]{serverName}), Server.class, service.getServerService()).addAliases(new ServiceName[]{ListenerResourceDefinition.LISTENER_CAPABILITY.getCapabilityServiceName(new String[]{name})});
        this.configureAdditionalDependencies(context, (ServiceBuilder<? extends UndertowListener>)serviceBuilder, model, service);
        serviceBuilder.install();
    }

    abstract ListenerService createService(String var1, String var2, OperationContext var3, ModelNode var4, OptionMap var5, OptionMap var6) throws OperationFailedException;

    abstract void configureAdditionalDependencies(OperationContext var1, ServiceBuilder<? extends UndertowListener> var2, ModelNode var3, ListenerService var4) throws OperationFailedException;
}

