/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.repository.logging;

import java.io.Serializable;
import java.nio.file.Path;
import java.util.Arrays;
import org.jboss.as.repository.ExplodedContentException;
import org.jboss.as.repository.logging.DeploymentRepositoryLogger;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class DeploymentRepositoryLogger_$logger
extends DelegatingBasicLogger
implements DeploymentRepositoryLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = DeploymentRepositoryLogger_$logger.class.getName();
    private static final String contentAdded = "WFLYDR0001: Content added at location %s";
    private static final String contentRemoved = "WFLYDR0002: Content removed from location %s";
    private static final String cannotDeleteTempFile = "WFLYDR0003: Cannot delete temp file %s, will be deleted on exit";
    private static final String cannotCreateDirectory = "WFLYDR0004: Cannot create directory %s";
    private static final String cannotObtainSha1 = "WFLYDR0005: Cannot obtain SHA-1 %s";
    private static final String directoryNotWritable = "WFLYDR0006: Directory %s is not writable";
    private static final String notADirectory = "WFLYDR0007: %s is not a directory";
    private static final String obsoleteContentCleaned = "WFLYDR0009: Content %s is obsolete and will be removed";
    private static final String contentDeletionError = "WFLYDR0010: Couldn't delete content %s";
    private static final String localContentListError = "WFLYDR0011: Couldn't list directory files for %s";
    private static final String hashingError = "WFLYDR0012: Cannot hash current deployment content %s";
    private static final String forbiddenPath = "WFLYDR0013: Access denied to the content at %s in the deployment";
    private static final String couldNotDeleteDeployment = "WFLYDR0014: Error deleting deployment %s";
    private static final String notAnArchive = "WFLYDR0015: %s is not an archive file";
    private static final String archiveNotFound = "WFLYDR0016: Achive file %s not found";
    private static final String contentExploded = "WFLYDR0017: Content exploded at location %s";
    private static final String errorExplodingContent = "WFLYDR0018: Error exploding content for %s";
    private static final String errorLockingDeployment = "WFLYDR0019: Deployment is locked by another operation";
    private static final String errorAccessingDeployment = "WFLYDR0020: Error accessing deployment files";
    private static final String errorUpdatingDeployment = "WFLYDR0021: Error updating content of exploded deployment";
    private static final String errorCopyingDeployment = "WFLYDR0022: Error copying files of exploded deployment to %s";
    private static final String cannotDeleteFile = "WFLYDR0023: Error deleting file %s";
    private static final String cannotCopyFile = "WFLYDR0024: Error copying file %s";

    public DeploymentRepositoryLogger_$logger(Logger log) {
        super(log);
    }

    @Override
    public final void contentAdded(String path) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.contentAdded$str(), (Object)path);
    }

    protected String contentAdded$str() {
        return contentAdded;
    }

    @Override
    public final void contentRemoved(String path) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.contentRemoved$str(), (Object)path);
    }

    protected String contentRemoved$str() {
        return contentRemoved;
    }

    @Override
    public final void cannotDeleteTempFile(Throwable cause, String path) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.cannotDeleteTempFile$str(), (Object)path);
    }

    protected String cannotDeleteTempFile$str() {
        return cannotDeleteTempFile;
    }

    protected String cannotCreateDirectory$str() {
        return cannotCreateDirectory;
    }

    @Override
    public final IllegalStateException cannotCreateDirectory(Throwable cause, String path) {
        IllegalStateException result = new IllegalStateException(String.format(this.cannotCreateDirectory$str(), path), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotObtainSha1$str() {
        return cannotObtainSha1;
    }

    @Override
    public final IllegalStateException cannotObtainSha1(Throwable cause, String name) {
        IllegalStateException result = new IllegalStateException(String.format(this.cannotObtainSha1$str(), name), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String directoryNotWritable$str() {
        return directoryNotWritable;
    }

    @Override
    public final IllegalStateException directoryNotWritable(String path) {
        IllegalStateException result = new IllegalStateException(String.format(this.directoryNotWritable$str(), path));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String notADirectory$str() {
        return notADirectory;
    }

    @Override
    public final IllegalStateException notADirectory(String path) {
        IllegalStateException result = new IllegalStateException(String.format(this.notADirectory$str(), path));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void obsoleteContentCleaned(String contentIdentifier) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.obsoleteContentCleaned$str(), (Object)contentIdentifier);
    }

    protected String obsoleteContentCleaned$str() {
        return obsoleteContentCleaned;
    }

    @Override
    public final void contentDeletionError(Throwable cause, String name) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.contentDeletionError$str(), (Object)name);
    }

    protected String contentDeletionError$str() {
        return contentDeletionError;
    }

    @Override
    public final void localContentListError(String name) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.localContentListError$str(), (Object)name);
    }

    protected String localContentListError$str() {
        return localContentListError;
    }

    protected String hashingError$str() {
        return hashingError;
    }

    @Override
    public final RuntimeException hashingError(Throwable cause, Path path) {
        RuntimeException result = new RuntimeException(String.format(this.hashingError$str(), path), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String forbiddenPath$str() {
        return forbiddenPath;
    }

    @Override
    public final IllegalArgumentException forbiddenPath(String path) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.forbiddenPath$str(), path));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void couldNotDeleteDeployment(Exception ex, String path) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)ex, this.couldNotDeleteDeployment$str(), (Object)path);
    }

    protected String couldNotDeleteDeployment$str() {
        return couldNotDeleteDeployment;
    }

    protected String notAnArchive$str() {
        return notAnArchive;
    }

    @Override
    public final IllegalStateException notAnArchive(String path) {
        IllegalStateException result = new IllegalStateException(String.format(this.notAnArchive$str(), path));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String archiveNotFound$str() {
        return archiveNotFound;
    }

    @Override
    public final ExplodedContentException archiveNotFound(String path) {
        ExplodedContentException result = new ExplodedContentException(String.format(this.archiveNotFound$str(), path));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void contentExploded(String path) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.contentExploded$str(), (Object)path);
    }

    protected String contentExploded$str() {
        return contentExploded;
    }

    protected String errorExplodingContent$str() {
        return errorExplodingContent;
    }

    @Override
    public final ExplodedContentException errorExplodingContent(Exception ex, String path) {
        ExplodedContentException result = new ExplodedContentException(String.format(this.errorExplodingContent$str(), path), ex);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorLockingDeployment$str() {
        return errorLockingDeployment;
    }

    @Override
    public final ExplodedContentException errorLockingDeployment() {
        ExplodedContentException result = new ExplodedContentException(String.format(this.errorLockingDeployment$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorAccessingDeployment$str() {
        return errorAccessingDeployment;
    }

    @Override
    public final ExplodedContentException errorAccessingDeployment(Exception ex) {
        ExplodedContentException result = new ExplodedContentException(String.format(this.errorAccessingDeployment$str(), new Object[0]), ex);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorUpdatingDeployment$str() {
        return errorUpdatingDeployment;
    }

    @Override
    public final ExplodedContentException errorUpdatingDeployment(Exception ex) {
        ExplodedContentException result = new ExplodedContentException(String.format(this.errorUpdatingDeployment$str(), new Object[0]), ex);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorCopyingDeployment$str() {
        return errorCopyingDeployment;
    }

    @Override
    public final ExplodedContentException errorCopyingDeployment(Exception ex, String target) {
        ExplodedContentException result = new ExplodedContentException(String.format(this.errorCopyingDeployment$str(), target), ex);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void cannotDeleteFile(Exception ex, Path path) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)ex, this.cannotDeleteFile$str(), (Object)path);
    }

    protected String cannotDeleteFile$str() {
        return cannotDeleteFile;
    }

    @Override
    public final void cannotCopyFile(Exception ex, Path path) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)ex, this.cannotCopyFile$str(), (Object)path);
    }

    protected String cannotCopyFile$str() {
        return cannotCopyFile;
    }
}

