/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistryException;
import org.jboss.msc.service.StabilityMonitor;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.InjectorDependency;
import org.wildfly.clustering.service.SimpleDependency;
import org.wildfly.clustering.service.ValueDependency;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.security.credential.source.CredentialSource;

public class CredentialSourceDependency
implements ValueDependency<CredentialSource> {
    private final ExceptionSupplier<CredentialSource, Exception> supplier;
    private final Iterable<Dependency> dependencies;

    public CredentialSourceDependency(OperationContext context, ModelNode model) throws OperationFailedException {
        DependencyCollectingServiceBuilder builder = new DependencyCollectingServiceBuilder();
        this.supplier = CredentialReference.getCredentialSourceSupplier((OperationContext)context, (ObjectTypeAttributeDefinition)CredentialReference.getAttributeDefinition(), (ModelNode)model, (ServiceBuilder)builder);
        this.dependencies = builder;
    }

    public <T> ServiceBuilder<T> register(ServiceBuilder<T> builder) {
        this.dependencies.forEach(dependency -> dependency.register(builder));
        return builder;
    }

    public CredentialSource getValue() {
        try {
            return (CredentialSource)this.supplier.get();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    static class DependencyCollectingServiceBuilder
    implements ServiceBuilder<Object>,
    Iterable<Dependency> {
        private final List<Dependency> dependencies = new LinkedList<Dependency>();

        DependencyCollectingServiceBuilder() {
        }

        @Override
        public Iterator<Dependency> iterator() {
            return this.dependencies.iterator();
        }

        public ServiceBuilder<Object> addAliases(ServiceName ... aliases) {
            throw new IllegalStateException();
        }

        public ServiceBuilder<Object> setInitialMode(ServiceController.Mode mode) {
            throw new IllegalStateException();
        }

        public ServiceBuilder<Object> addDependencies(ServiceName ... serviceNames) {
            Stream.of(serviceNames).forEach(serviceName -> this.dependencies.add((Dependency)new SimpleDependency(serviceName)));
            return this;
        }

        public ServiceBuilder<Object> addDependencies(ServiceBuilder.DependencyType dependencyType, ServiceName ... serviceNames) {
            if (dependencyType != ServiceBuilder.DependencyType.REQUIRED) {
                throw new UnsupportedOperationException();
            }
            return this.addDependencies(serviceNames);
        }

        public ServiceBuilder<Object> addDependencies(Iterable<ServiceName> serviceNames) {
            serviceNames.forEach(serviceName -> this.dependencies.add((Dependency)new SimpleDependency(serviceName)));
            return this;
        }

        public ServiceBuilder<Object> addDependencies(ServiceBuilder.DependencyType dependencyType, Iterable<ServiceName> serviceNames) {
            if (dependencyType != ServiceBuilder.DependencyType.REQUIRED) {
                throw new UnsupportedOperationException();
            }
            return this.addDependencies(serviceNames);
        }

        public ServiceBuilder<Object> addDependency(ServiceName serviceName) {
            this.dependencies.add((Dependency)new SimpleDependency(serviceName));
            return this;
        }

        public ServiceBuilder<Object> addDependency(ServiceBuilder.DependencyType dependencyType, ServiceName serviceName) {
            if (dependencyType != ServiceBuilder.DependencyType.REQUIRED) {
                throw new UnsupportedOperationException();
            }
            return this.addDependency(serviceName);
        }

        public ServiceBuilder<Object> addDependency(ServiceName serviceName, Injector<Object> target) {
            return this.addDependency(serviceName, Object.class, target);
        }

        public ServiceBuilder<Object> addDependency(ServiceBuilder.DependencyType dependencyType, ServiceName serviceName, Injector<Object> target) {
            return this.addDependency(dependencyType, serviceName, Object.class, target);
        }

        public <I> ServiceBuilder<Object> addDependency(ServiceName serviceName, Class<I> type, Injector<I> target) {
            this.dependencies.add((Dependency)new InjectorDependency(serviceName, type, target));
            return this;
        }

        public <I> ServiceBuilder<Object> addDependency(ServiceBuilder.DependencyType dependencyType, ServiceName serviceName, Class<I> type, Injector<I> target) {
            if (dependencyType != ServiceBuilder.DependencyType.REQUIRED) {
                throw new UnsupportedOperationException();
            }
            return this.addDependency(serviceName, type, target);
        }

        public <I> ServiceBuilder<Object> addInjection(Injector<? super I> target, I value) {
            throw new IllegalStateException();
        }

        public <I> ServiceBuilder<Object> addInjectionValue(Injector<? super I> target, Value<I> value) {
            throw new IllegalStateException();
        }

        public ServiceBuilder<Object> addInjection(Injector<? super Object> target) {
            throw new IllegalStateException();
        }

        public ServiceBuilder<Object> addMonitor(StabilityMonitor monitor) {
            throw new IllegalStateException();
        }

        public ServiceBuilder<Object> addMonitors(StabilityMonitor ... monitors) {
            throw new IllegalStateException();
        }

        @Deprecated
        public ServiceBuilder<Object> addListener(ServiceListener<? super Object> listener) {
            throw new IllegalStateException();
        }

        @Deprecated
        public ServiceBuilder<Object> addListener(ServiceListener<? super Object> ... listeners) {
            throw new IllegalStateException();
        }

        @Deprecated
        public ServiceBuilder<Object> addListener(Collection<? extends ServiceListener<? super Object>> listeners) {
            throw new IllegalStateException();
        }

        public ServiceController<Object> install() throws ServiceRegistryException, IllegalStateException {
            throw new IllegalStateException();
        }
    }
}

