/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.callback.MechanismInformationCallback;
import org.wildfly.security.auth.server.MechanismInformation;
import org.wildfly.security.sasl.util.AbstractDelegatingSaslServerFactory;

public final class SetMechanismInformationSaslServerFactory
extends AbstractDelegatingSaslServerFactory {
    public SetMechanismInformationSaslServerFactory(SaslServerFactory delegate) {
        super(delegate);
    }

    @Override
    public SaslServer createSaslServer(final String mechanism, final String protocol, final String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        try {
            MechanismInformationCallback mechanismInformationCallback = new MechanismInformationCallback(new MechanismInformation(){

                @Override
                public String getProtocol() {
                    return protocol;
                }

                @Override
                public String getMechanismType() {
                    return "SASL";
                }

                @Override
                public String getMechanismName() {
                    return mechanism;
                }

                @Override
                public String getHostName() {
                    return serverName;
                }
            });
            cbh.handle(new Callback[]{mechanismInformationCallback});
        }
        catch (Throwable e) {
            ElytronMessages.log.trace(e);
            return null;
        }
        return super.createSaslServer(mechanism, protocol, serverName, props, cbh);
    }
}

