/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.services.path.PathResourceDefinition;
import org.jboss.as.logging.AbstractHandlerDefinition;
import org.jboss.as.logging.AsyncHandlerResourceDefinition;
import org.jboss.as.logging.Attribute;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.ConsoleHandlerResourceDefinition;
import org.jboss.as.logging.Element;
import org.jboss.as.logging.LoggerResourceDefinition;
import org.jboss.as.logging.LoggingSubsystemParser;
import org.jboss.as.logging.PatternFormatterResourceDefinition;
import org.jboss.as.logging.PeriodicHandlerResourceDefinition;
import org.jboss.as.logging.SizeRotatingHandlerResourceDefinition;
import org.jboss.as.logging.SyslogHandlerResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;

class LoggingSubsystemParser_1_3
extends LoggingSubsystemParser
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>> {
    LoggingSubsystemParser_1_3() {
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        operations.add(Util.createAddOperation((PathAddress)SUBSYSTEM_ADDRESS));
        ArrayList<ModelNode> loggerOperations = new ArrayList<ModelNode>();
        ArrayList<ModelNode> asyncHandlerOperations = new ArrayList<ModelNode>();
        ArrayList<ModelNode> handlerOperations = new ArrayList<ModelNode>();
        HashSet<String> loggerNames = new HashSet<String>();
        HashSet<String> handlerNames = new HashSet<String>();
        boolean rootDefined = false;
        block12: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case LOGGER: {
                    LoggingSubsystemParser_1_3.parseLoggerElement(reader, SUBSYSTEM_ADDRESS, loggerOperations, loggerNames);
                    continue block12;
                }
                case ROOT_LOGGER: {
                    if (rootDefined) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    rootDefined = true;
                    LoggingSubsystemParser_1_3.parseRootLoggerElement(reader, SUBSYSTEM_ADDRESS, loggerOperations);
                    continue block12;
                }
                case CONSOLE_HANDLER: {
                    LoggingSubsystemParser_1_3.parseConsoleHandlerElement(reader, SUBSYSTEM_ADDRESS, handlerOperations, handlerNames);
                    continue block12;
                }
                case FILE_HANDLER: {
                    LoggingSubsystemParser_1_3.parseFileHandlerElement(reader, SUBSYSTEM_ADDRESS, handlerOperations, handlerNames);
                    continue block12;
                }
                case CUSTOM_HANDLER: {
                    LoggingSubsystemParser_1_3.parseCustomHandlerElement(reader, SUBSYSTEM_ADDRESS, handlerOperations, handlerNames);
                    continue block12;
                }
                case PERIODIC_ROTATING_FILE_HANDLER: {
                    LoggingSubsystemParser_1_3.parsePeriodicRotatingFileHandlerElement(reader, SUBSYSTEM_ADDRESS, handlerOperations, handlerNames);
                    continue block12;
                }
                case SIZE_ROTATING_FILE_HANDLER: {
                    LoggingSubsystemParser_1_3.parseSizeRotatingHandlerElement(reader, SUBSYSTEM_ADDRESS, handlerOperations, handlerNames);
                    continue block12;
                }
                case ASYNC_HANDLER: {
                    LoggingSubsystemParser_1_3.parseAsyncHandlerElement(reader, SUBSYSTEM_ADDRESS, asyncHandlerOperations, handlerNames);
                    continue block12;
                }
                case SYSLOG_HANDLER: {
                    LoggingSubsystemParser_1_3.parseSyslogHandler(reader, SUBSYSTEM_ADDRESS, handlerOperations, handlerNames);
                    continue block12;
                }
                case LOGGING_PROFILES: {
                    LoggingSubsystemParser_1_3.parseLoggingProfilesElement(reader, operations);
                    continue block12;
                }
            }
            reader.handleAny(operations);
        }
        operations.addAll(handlerOperations);
        operations.addAll(asyncHandlerOperations);
        operations.addAll(loggerOperations);
    }

    private static void parseLoggerElement(XMLExtendedStreamReader reader, PathAddress address, List<ModelNode> operations, Set<String> names) throws XMLStreamException {
        ModelNode operation = Util.createAddOperation();
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.CATEGORY);
        int count = reader.getAttributeCount();
        block9: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case CATEGORY: {
                    if (value == null || value.trim().isEmpty()) {
                        throw ParseUtils.invalidAttributeValue((XMLExtendedStreamReader)reader, (int)i);
                    }
                    name = value;
                    continue block9;
                }
                case USE_PARENT_HANDLERS: {
                    LoggerResourceDefinition.USE_PARENT_HANDLERS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        assert (name != null);
        if (!names.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        LoggingSubsystemParser_1_3.addOperationAddress(operation, address, "logger", name);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)reader.getLocalName());
            }
            switch (element) {
                case LEVEL: {
                    CommonAttributes.LEVEL.parseAndSetParameter(LoggingSubsystemParser_1_3.readNameAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block10;
                }
                case HANDLERS: {
                    LoggingSubsystemParser_1_3.parseHandlersElement(operation.get(CommonAttributes.HANDLERS.getName()), reader);
                    continue block10;
                }
                case FILTER_SPEC: {
                    CommonAttributes.FILTER_SPEC.parseAndSetParameter(LoggingSubsystemParser_1_3.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block10;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        operations.add(operation);
    }

    private static void parseAsyncHandlerElement(XMLExtendedStreamReader reader, PathAddress address, List<ModelNode> operations, Set<String> names) throws XMLStreamException {
        ModelNode operation = Util.createAddOperation();
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block12: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block12;
                }
                case ENABLED: {
                    CommonAttributes.ENABLED.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block12;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        if (!names.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        LoggingSubsystemParser_1_3.addOperationAddress(operation, address, "async-handler", name);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block13: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case LEVEL: {
                    CommonAttributes.LEVEL.parseAndSetParameter(LoggingSubsystemParser_1_3.readNameAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block13;
                }
                case SUBHANDLERS: {
                    LoggingSubsystemParser_1_3.parseHandlersElement(operation.get(AsyncHandlerResourceDefinition.SUBHANDLERS.getName()), reader);
                    continue block13;
                }
                case FILTER_SPEC: {
                    CommonAttributes.FILTER_SPEC.parseAndSetParameter(LoggingSubsystemParser_1_3.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block13;
                }
                case FORMATTER: {
                    LoggingSubsystemParser_1_3.parseHandlerFormatterElement(reader, operation);
                    continue block13;
                }
                case QUEUE_LENGTH: {
                    AsyncHandlerResourceDefinition.QUEUE_LENGTH.parseAndSetParameter(LoggingSubsystemParser_1_3.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block13;
                }
                case OVERFLOW_ACTION: {
                    AsyncHandlerResourceDefinition.OVERFLOW_ACTION.parseAndSetParameter(LoggingSubsystemParser_1_3.readValueAttribute(reader).toUpperCase(Locale.US), operation, (XMLStreamReader)reader);
                    continue block13;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        operations.add(operation);
    }

    private static void parseRootLoggerElement(XMLExtendedStreamReader reader, PathAddress address, List<ModelNode> operations) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)0);
        }
        ModelNode operation = Util.createAddOperation((PathAddress)address.append("root-logger", "ROOT"));
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (encountered.contains((Object)element)) {
                throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)reader.getLocalName());
            }
            encountered.add(element);
            switch (element) {
                case FILTER_SPEC: {
                    CommonAttributes.FILTER_SPEC.parseAndSetParameter(LoggingSubsystemParser_1_3.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block5;
                }
                case LEVEL: {
                    CommonAttributes.LEVEL.parseAndSetParameter(LoggingSubsystemParser_1_3.readNameAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block5;
                }
                case HANDLERS: {
                    LoggingSubsystemParser_1_3.parseHandlersElement(operation.get(CommonAttributes.HANDLERS.getName()), reader);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        operations.add(operation);
    }

    private static void parseConsoleHandlerElement(XMLExtendedStreamReader reader, PathAddress address, List<ModelNode> operations, Set<String> names) throws XMLStreamException {
        ModelNode operation = Util.createAddOperation();
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block12: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block12;
                }
                case AUTOFLUSH: {
                    CommonAttributes.AUTOFLUSH.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block12;
                }
                case ENABLED: {
                    CommonAttributes.ENABLED.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block12;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        if (!names.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        LoggingSubsystemParser_1_3.addOperationAddress(operation, address, "console-handler", name);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block13: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case LEVEL: {
                    CommonAttributes.LEVEL.parseAndSetParameter(LoggingSubsystemParser_1_3.readNameAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block13;
                }
                case ENCODING: {
                    CommonAttributes.ENCODING.parseAndSetParameter(LoggingSubsystemParser_1_3.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block13;
                }
                case FILTER_SPEC: {
                    CommonAttributes.FILTER_SPEC.parseAndSetParameter(LoggingSubsystemParser_1_3.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block13;
                }
                case FORMATTER: {
                    LoggingSubsystemParser_1_3.parseHandlerFormatterElement(reader, operation);
                    continue block13;
                }
                case TARGET: {
                    String target = LoggingSubsystemParser_1_3.readNameAttribute(reader);
                    ConsoleHandlerResourceDefinition.TARGET.parseAndSetParameter(target, operation, (XMLStreamReader)reader);
                    continue block13;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        operations.add(operation);
    }

    private static void parseFileHandlerElement(XMLExtendedStreamReader reader, PathAddress address, List<ModelNode> operations, Set<String> names) throws XMLStreamException {
        ModelNode operation = Util.createAddOperation();
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block13: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block13;
                }
                case AUTOFLUSH: {
                    CommonAttributes.AUTOFLUSH.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block13;
                }
                case ENABLED: {
                    CommonAttributes.ENABLED.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block13;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        if (!names.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        LoggingSubsystemParser_1_3.addOperationAddress(operation, address, "file-handler", name);
        EnumSet<Element> requiredElem = EnumSet.of(Element.FILE);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block14: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            requiredElem.remove((Object)element);
            switch (element) {
                case LEVEL: {
                    CommonAttributes.LEVEL.parseAndSetParameter(LoggingSubsystemParser_1_3.readNameAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block14;
                }
                case ENCODING: {
                    CommonAttributes.ENCODING.parseAndSetParameter(LoggingSubsystemParser_1_3.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block14;
                }
                case FILTER_SPEC: {
                    CommonAttributes.FILTER_SPEC.parseAndSetParameter(LoggingSubsystemParser_1_3.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block14;
                }
                case FORMATTER: {
                    LoggingSubsystemParser_1_3.parseHandlerFormatterElement(reader, operation);
                    continue block14;
                }
                case FILE: {
                    LoggingSubsystemParser_1_3.parseFileElement(operation.get(CommonAttributes.FILE.getName()), reader);
                    continue block14;
                }
                case APPEND: {
                    CommonAttributes.APPEND.parseAndSetParameter(LoggingSubsystemParser_1_3.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block14;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!requiredElem.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredElem);
        }
        operations.add(operation);
    }

    private static void parseCustomHandlerElement(XMLExtendedStreamReader reader, PathAddress address, List<ModelNode> operations, Set<String> names) throws XMLStreamException {
        ModelNode operation = Util.createAddOperation();
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.CLASS, Attribute.MODULE);
        int count = reader.getAttributeCount();
        block13: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block13;
                }
                case CLASS: {
                    CommonAttributes.CLASS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block13;
                }
                case MODULE: {
                    CommonAttributes.MODULE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block13;
                }
                case ENABLED: {
                    CommonAttributes.ENABLED.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block13;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        if (!names.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        LoggingSubsystemParser_1_3.addOperationAddress(operation, address, "custom-handler", name);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block14: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case LEVEL: {
                    CommonAttributes.LEVEL.parseAndSetParameter(LoggingSubsystemParser_1_3.readNameAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block14;
                }
                case ENCODING: {
                    CommonAttributes.ENCODING.parseAndSetParameter(LoggingSubsystemParser_1_3.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block14;
                }
                case FILTER_SPEC: {
                    CommonAttributes.FILTER_SPEC.parseAndSetParameter(LoggingSubsystemParser_1_3.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block14;
                }
                case FORMATTER: {
                    LoggingSubsystemParser_1_3.parseHandlerFormatterElement(reader, operation);
                    continue block14;
                }
                case PROPERTIES: {
                    LoggingSubsystemParser_1_3.parsePropertyElement(operation, reader);
                    continue block14;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        operations.add(operation);
    }

    private static void parsePeriodicRotatingFileHandlerElement(XMLExtendedStreamReader reader, PathAddress address, List<ModelNode> operations, Set<String> names) throws XMLStreamException {
        ModelNode operation = Util.createAddOperation();
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block14: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block14;
                }
                case AUTOFLUSH: {
                    CommonAttributes.AUTOFLUSH.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block14;
                }
                case ENABLED: {
                    CommonAttributes.ENABLED.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block14;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        if (!names.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        LoggingSubsystemParser_1_3.addOperationAddress(operation, address, "periodic-rotating-file-handler", name);
        EnumSet<Element> requiredElem = EnumSet.of(Element.FILE, Element.SUFFIX);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block15: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            requiredElem.remove((Object)element);
            switch (element) {
                case LEVEL: {
                    CommonAttributes.LEVEL.parseAndSetParameter(LoggingSubsystemParser_1_3.readNameAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block15;
                }
                case ENCODING: {
                    CommonAttributes.ENCODING.parseAndSetParameter(LoggingSubsystemParser_1_3.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block15;
                }
                case FILTER_SPEC: {
                    CommonAttributes.FILTER_SPEC.parseAndSetParameter(LoggingSubsystemParser_1_3.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block15;
                }
                case FORMATTER: {
                    LoggingSubsystemParser_1_3.parseHandlerFormatterElement(reader, operation);
                    continue block15;
                }
                case FILE: {
                    LoggingSubsystemParser_1_3.parseFileElement(operation.get(CommonAttributes.FILE.getName()), reader);
                    continue block15;
                }
                case APPEND: {
                    CommonAttributes.APPEND.parseAndSetParameter(LoggingSubsystemParser_1_3.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block15;
                }
                case SUFFIX: {
                    PeriodicHandlerResourceDefinition.SUFFIX.parseAndSetParameter(LoggingSubsystemParser_1_3.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block15;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!requiredElem.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredElem);
        }
        operations.add(operation);
    }

    private static void parseSizeRotatingHandlerElement(XMLExtendedStreamReader reader, PathAddress address, List<ModelNode> operations, Set<String> names) throws XMLStreamException {
        ModelNode operation = Util.createAddOperation();
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block16: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block16;
                }
                case AUTOFLUSH: {
                    CommonAttributes.AUTOFLUSH.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block16;
                }
                case ENABLED: {
                    CommonAttributes.ENABLED.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block16;
                }
                case ROTATE_ON_BOOT: {
                    SizeRotatingHandlerResourceDefinition.ROTATE_ON_BOOT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block16;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        if (!names.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        LoggingSubsystemParser_1_3.addOperationAddress(operation, address, "size-rotating-file-handler", name);
        EnumSet<Element> requiredElem = EnumSet.of(Element.FILE);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block17: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            requiredElem.remove((Object)element);
            switch (element) {
                case LEVEL: {
                    CommonAttributes.LEVEL.parseAndSetParameter(LoggingSubsystemParser_1_3.readNameAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block17;
                }
                case ENCODING: {
                    CommonAttributes.ENCODING.parseAndSetParameter(LoggingSubsystemParser_1_3.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block17;
                }
                case FILTER_SPEC: {
                    CommonAttributes.FILTER_SPEC.parseAndSetParameter(LoggingSubsystemParser_1_3.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block17;
                }
                case FORMATTER: {
                    LoggingSubsystemParser_1_3.parseHandlerFormatterElement(reader, operation);
                    continue block17;
                }
                case FILE: {
                    LoggingSubsystemParser_1_3.parseFileElement(operation.get(CommonAttributes.FILE.getName()), reader);
                    continue block17;
                }
                case APPEND: {
                    CommonAttributes.APPEND.parseAndSetParameter(LoggingSubsystemParser_1_3.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block17;
                }
                case ROTATE_SIZE: {
                    SizeRotatingHandlerResourceDefinition.ROTATE_SIZE.parseAndSetParameter(LoggingSubsystemParser_1_3.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block17;
                }
                case MAX_BACKUP_INDEX: {
                    SizeRotatingHandlerResourceDefinition.MAX_BACKUP_INDEX.parseAndSetParameter(LoggingSubsystemParser_1_3.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block17;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        operations.add(operation);
    }

    private static void parseSyslogHandler(XMLExtendedStreamReader reader, PathAddress address, List<ModelNode> operations, Set<String> names) throws XMLStreamException {
        ModelNode operation = Util.createAddOperation();
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block16: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block16;
                }
                case ENABLED: {
                    CommonAttributes.ENABLED.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block16;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        if (!names.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        LoggingSubsystemParser_1_3.addOperationAddress(operation, address, "syslog-handler", name);
        EnumSet<Element> requiredElem = EnumSet.noneOf(Element.class);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block17: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            requiredElem.remove((Object)element);
            switch (element) {
                case APP_NAME: {
                    SyslogHandlerResourceDefinition.APP_NAME.parseAndSetParameter(LoggingSubsystemParser_1_3.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block17;
                }
                case FACILITY: {
                    SyslogHandlerResourceDefinition.FACILITY.parseAndSetParameter(LoggingSubsystemParser_1_3.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block17;
                }
                case HOSTNAME: {
                    SyslogHandlerResourceDefinition.HOSTNAME.parseAndSetParameter(LoggingSubsystemParser_1_3.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block17;
                }
                case LEVEL: {
                    CommonAttributes.LEVEL.parseAndSetParameter(LoggingSubsystemParser_1_3.readNameAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block17;
                }
                case FORMATTER: {
                    if (reader.nextTag() != 1) {
                        throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, Collections.singleton(Element.SYSLOG_FORMATTER.getLocalName()));
                    }
                    switch (Element.forName(reader.getLocalName())) {
                        case SYSLOG_FORMATTER: {
                            ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)Attribute.SYSLOG_TYPE.getLocalName());
                            operation.get(SyslogHandlerResourceDefinition.SYSLOG_FORMATTER.getName()).set(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.SYSLOG_TYPE.getLocalName()));
                            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                            continue block17;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                case PORT: {
                    SyslogHandlerResourceDefinition.PORT.parseAndSetParameter(LoggingSubsystemParser_1_3.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block17;
                }
                case SERVER_ADDRESS: {
                    SyslogHandlerResourceDefinition.SERVER_ADDRESS.parseAndSetParameter(LoggingSubsystemParser_1_3.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block17;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        operations.add(operation);
    }

    private static void parseFileElement(ModelNode operation, XMLExtendedStreamReader reader) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.PATH);
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case PATH: {
                    PathResourceDefinition.PATH.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block4;
                }
                case RELATIVE_TO: {
                    PathResourceDefinition.RELATIVE_TO.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private static void parseHandlerFormatterElement(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)0);
        }
        boolean formatterDefined = false;
        block3: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PATTERN_FORMATTER: {
                    if (formatterDefined) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)PatternFormatterResourceDefinition.PATTERN.getName());
                    formatterDefined = true;
                    AbstractHandlerDefinition.FORMATTER.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)PatternFormatterResourceDefinition.PATTERN.getName()), operation, (XMLStreamReader)reader);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private static void parseHandlersElement(ModelNode operation, XMLExtendedStreamReader reader) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)0);
        }
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case HANDLER: {
                    operation.add(LoggingSubsystemParser_1_3.readNameAttribute(reader));
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    static void parseLoggingProfilesElement(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        HashSet<String> profileNames = new HashSet<String>();
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case LOGGING_PROFILE: {
                    LoggingSubsystemParser_1_3.parseLoggingProfileElement(reader, operations, profileNames);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    static void parseLoggingProfileElement(XMLExtendedStreamReader reader, List<ModelNode> operations, Set<String> profileNames) throws XMLStreamException {
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block14: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block14;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        if (!profileNames.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        PathAddress profileAddress = SUBSYSTEM_ADDRESS.append("logging-profile", name);
        operations.add(Util.createAddOperation((PathAddress)profileAddress));
        ArrayList<ModelNode> loggerOperations = new ArrayList<ModelNode>();
        ArrayList<ModelNode> asyncHandlerOperations = new ArrayList<ModelNode>();
        ArrayList<ModelNode> handlerOperations = new ArrayList<ModelNode>();
        HashSet<String> loggerNames = new HashSet<String>();
        HashSet<String> handlerNames = new HashSet<String>();
        boolean gotRoot = false;
        block15: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case LOGGER: {
                    LoggingSubsystemParser_1_3.parseLoggerElement(reader, profileAddress, loggerOperations, loggerNames);
                    continue block15;
                }
                case ROOT_LOGGER: {
                    if (gotRoot) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    gotRoot = true;
                    LoggingSubsystemParser_1_3.parseRootLoggerElement(reader, profileAddress, loggerOperations);
                    continue block15;
                }
                case CONSOLE_HANDLER: {
                    LoggingSubsystemParser_1_3.parseConsoleHandlerElement(reader, profileAddress, handlerOperations, handlerNames);
                    continue block15;
                }
                case FILE_HANDLER: {
                    LoggingSubsystemParser_1_3.parseFileHandlerElement(reader, profileAddress, handlerOperations, handlerNames);
                    continue block15;
                }
                case CUSTOM_HANDLER: {
                    LoggingSubsystemParser_1_3.parseCustomHandlerElement(reader, profileAddress, handlerOperations, handlerNames);
                    continue block15;
                }
                case PERIODIC_ROTATING_FILE_HANDLER: {
                    LoggingSubsystemParser_1_3.parsePeriodicRotatingFileHandlerElement(reader, profileAddress, handlerOperations, handlerNames);
                    continue block15;
                }
                case SIZE_ROTATING_FILE_HANDLER: {
                    LoggingSubsystemParser_1_3.parseSizeRotatingHandlerElement(reader, profileAddress, handlerOperations, handlerNames);
                    continue block15;
                }
                case ASYNC_HANDLER: {
                    LoggingSubsystemParser_1_3.parseAsyncHandlerElement(reader, profileAddress, asyncHandlerOperations, handlerNames);
                    continue block15;
                }
                case SYSLOG_HANDLER: {
                    LoggingSubsystemParser_1_3.parseSyslogHandler(reader, profileAddress, handlerOperations, handlerNames);
                    continue block15;
                }
            }
            reader.handleAny(operations);
        }
        operations.addAll(handlerOperations);
        operations.addAll(asyncHandlerOperations);
        operations.addAll(loggerOperations);
    }
}

