/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.wildfly.common.Assert;

public abstract class AbstractWriteAttributeHandler<T>
implements OperationStepHandler {
    private final ParametersValidator nameValidator = new ParametersValidator();
    private final Map<String, AttributeDefinition> attributeDefinitions;

    protected AbstractWriteAttributeHandler(AttributeDefinition ... definitions) {
        Assert.assertNotNull((Object)definitions);
        this.attributeDefinitions = new HashMap<String, AttributeDefinition>();
        for (AttributeDefinition def : definitions) {
            this.attributeDefinitions.put(def.getName(), def);
        }
    }

    protected AbstractWriteAttributeHandler(Collection<AttributeDefinition> definitions) {
        this(definitions.toArray(new AttributeDefinition[definitions.size()]));
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode defaultValue;
        this.nameValidator.validate(operation);
        final String attributeName = operation.require("name").asString();
        ModelNode newValue = operation.hasDefined("value") ? operation.get("value") : new ModelNode();
        Resource resource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
        final ModelNode submodel = resource.getModel();
        final ModelNode currentValue = submodel.get(attributeName).clone();
        final AttributeDefinition attributeDefinition = this.getAttributeDefinition(attributeName);
        if (attributeDefinition != null) {
            defaultValue = attributeDefinition.getDefaultValue();
            ModelNode syntheticOp = new ModelNode();
            syntheticOp.get(attributeName).set(newValue);
            attributeDefinition.validateAndSet(syntheticOp, submodel);
            newValue = submodel.get(attributeName);
            this.recordCapabilitiesAndRequirements(context, attributeDefinition, newValue, currentValue);
        } else {
            defaultValue = null;
            submodel.get(attributeName).set(newValue);
        }
        this.finishModelStage(context, operation, attributeName, newValue, currentValue, resource);
        if (this.requiresRuntime(context)) {
            final ModelNode updatedValue = newValue;
            context.addStep(operation, new OperationStepHandler(){

                @Override
                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    HandbackHolder handback;
                    final ModelNode resolvedValue = attributeDefinition != null ? attributeDefinition.resolveModelAttribute(context, submodel) : updatedValue.resolve();
                    final boolean reloadRequired = AbstractWriteAttributeHandler.this.applyUpdateToRuntime(context, operation, attributeName, resolvedValue, currentValue, handback = new HandbackHolder());
                    if (reloadRequired) {
                        if (attributeDefinition != null && attributeDefinition.getImmutableFlags().contains((Object)AttributeAccess.Flag.RESTART_JVM)) {
                            context.restartRequired();
                        } else {
                            context.reloadRequired();
                        }
                    }
                    context.completeStep(new OperationContext.RollbackHandler(){

                        @Override
                        public void handleRollback(OperationContext context, ModelNode operation) {
                            ModelNode valueToRestore = currentValue.resolve();
                            if (!valueToRestore.isDefined() && defaultValue != null) {
                                valueToRestore = defaultValue;
                            }
                            try {
                                AbstractWriteAttributeHandler.this.revertUpdateToRuntime(context, operation, attributeName, valueToRestore, resolvedValue, handback.handback);
                            }
                            catch (Exception e) {
                                ControllerLogger.MGMT_OP_LOGGER.errorRevertingOperation(e, this.getClass().getSimpleName(), operation.require("operation").asString(), context.getCurrentAddress());
                            }
                            if (reloadRequired) {
                                if (attributeDefinition != null && attributeDefinition.getImmutableFlags().contains((Object)AttributeAccess.Flag.RESTART_JVM)) {
                                    context.revertRestartRequired();
                                } else {
                                    context.revertReloadRequired();
                                }
                            }
                        }
                    });
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    protected abstract boolean applyUpdateToRuntime(OperationContext var1, ModelNode var2, String var3, ModelNode var4, ModelNode var5, HandbackHolder<T> var6) throws OperationFailedException;

    protected abstract void revertUpdateToRuntime(OperationContext var1, ModelNode var2, String var3, ModelNode var4, ModelNode var5, T var6) throws OperationFailedException;

    protected void recordCapabilitiesAndRequirements(OperationContext context, AttributeDefinition attributeDefinition, ModelNode newValue, ModelNode oldValue) {
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        attributeDefinition.removeCapabilityRequirements(context, resource, oldValue);
        attributeDefinition.addCapabilityRequirements(context, resource, newValue);
    }

    protected void finishModelStage(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode oldValue, Resource model) throws OperationFailedException {
        this.validateUpdatedModel(context, model);
    }

    protected void validateUpdatedModel(OperationContext context, Resource model) throws OperationFailedException {
    }

    protected boolean requiresRuntime(OperationContext context) {
        return context.isDefaultRequiresRuntime() && !context.isBooting();
    }

    protected AttributeDefinition getAttributeDefinition(String attributeName) {
        return this.attributeDefinitions == null ? null : this.attributeDefinitions.get(attributeName);
    }

    public static class HandbackHolder<T> {
        private T handback;

        public void setHandback(T handback) {
            this.handback = handback;
        }
    }
}

