/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl.aesh.cmd.deployment.security;

import java.util.HashSet;
import java.util.Set;
import org.aesh.command.activator.OptionActivator;
import org.aesh.command.impl.internal.ParsedCommand;
import org.jboss.as.cli.impl.aesh.cmd.deployment.security.CommandWithPermissions;
import org.wildfly.core.cli.command.aesh.activator.AbstractDependRejectOptionActivator;
import org.wildfly.core.cli.command.aesh.activator.AbstractRejectOptionActivator;
import org.wildfly.core.cli.command.aesh.activator.DomainOptionActivator;
import org.wildfly.core.cli.command.aesh.activator.StandaloneOptionActivator;

public interface OptionActivators {

    public static class UndeployServerGroupsActivator
    extends AbstractRejectOptionActivator
    implements DomainOptionActivator {
        public UndeployServerGroupsActivator() {
            super("all-relevant-server-groups");
        }

        @Override
        public boolean isActivated(ParsedCommand processedCommand) {
            CommandWithPermissions cmd = (CommandWithPermissions)processedCommand.command();
            if (!cmd.getPermissions().getUndeployPermission().isSatisfied(cmd.getCommandContext())) {
                return false;
            }
            if (!cmd.getCommandContext().isDomainMode()) {
                return false;
            }
            return super.isActivated(processedCommand);
        }
    }

    public static class AllRelevantServerGroupsActivator
    extends AbstractRejectOptionActivator
    implements DomainOptionActivator {
        public AllRelevantServerGroupsActivator() {
            super("server-groups");
        }

        @Override
        public boolean isActivated(ParsedCommand processedCommand) {
            CommandWithPermissions cmd = (CommandWithPermissions)processedCommand.command();
            if (!cmd.getPermissions().getUndeployPermission().isSatisfied(cmd.getCommandContext())) {
                return false;
            }
            if (!cmd.getCommandContext().isDomainMode()) {
                return false;
            }
            return super.isActivated(processedCommand);
        }
    }

    public static class AllServerGroupsActivator
    extends AbstractRejectOptionActivator
    implements DomainOptionActivator {
        public AllServerGroupsActivator() {
            super("server-groups", "replace");
        }

        @Override
        public boolean isActivated(ParsedCommand processedCommand) {
            CommandWithPermissions cmd = (CommandWithPermissions)processedCommand.command();
            if (!cmd.getPermissions().getDeployPermission().isSatisfied(cmd.getCommandContext())) {
                return false;
            }
            if (!cmd.getCommandContext().isDomainMode()) {
                return false;
            }
            return super.isActivated(processedCommand);
        }
    }

    public static class InfoNameActivator
    extends AbstractRejectOptionActivator {
        public InfoNameActivator() {
            super("server-group");
        }
    }

    public static class InfoServerGroupActivator
    extends AbstractRejectOptionActivator
    implements DomainOptionActivator {
        public InfoServerGroupActivator() {
            super("");
        }

        @Override
        public boolean isActivated(ParsedCommand processedCommand) {
            CommandWithPermissions cmd = (CommandWithPermissions)processedCommand.command();
            if (!cmd.getCommandContext().isDomainMode()) {
                return false;
            }
            return super.isActivated(processedCommand);
        }
    }

    public static class ServerGroupsActivator
    extends AbstractRejectOptionActivator
    implements DomainOptionActivator {
        public ServerGroupsActivator() {
            super("all-server-groups", "replace");
        }

        @Override
        public boolean isActivated(ParsedCommand processedCommand) {
            CommandWithPermissions cmd = (CommandWithPermissions)processedCommand.command();
            if (!cmd.getPermissions().getDeployPermission().isSatisfied(cmd.getCommandContext())) {
                return false;
            }
            if (!cmd.getCommandContext().isDomainMode()) {
                return false;
            }
            return super.isActivated(processedCommand);
        }
    }

    public static class DisabledActivator
    extends AbstractDependRejectOptionActivator
    implements StandaloneOptionActivator {
        private static final Set<String> EXPECTED = new HashSet<String>();
        private static final Set<String> NOT_EXPECTED = new HashSet<String>();

        public DisabledActivator() {
            super(false, EXPECTED, NOT_EXPECTED);
        }

        @Override
        public boolean isActivated(ParsedCommand processedCommand) {
            CommandWithPermissions cmd = (CommandWithPermissions)processedCommand.command();
            if (!cmd.getPermissions().getMainAddPermission().isSatisfied(cmd.getCommandContext())) {
                return false;
            }
            if (cmd.getCommandContext().isDomainMode()) {
                return false;
            }
            return super.isActivated(processedCommand);
        }

        static {
            EXPECTED.add("");
            NOT_EXPECTED.add("enabled");
        }
    }

    public static class EnabledActivator
    extends AbstractDependRejectOptionActivator
    implements StandaloneOptionActivator {
        private static final Set<String> EXPECTED = new HashSet<String>();
        private static final Set<String> NOT_EXPECTED = new HashSet<String>();

        public EnabledActivator() {
            super(false, EXPECTED, NOT_EXPECTED);
        }

        @Override
        public boolean isActivated(ParsedCommand processedCommand) {
            CommandWithPermissions cmd = (CommandWithPermissions)processedCommand.command();
            if (!cmd.getPermissions().getMainAddPermission().isSatisfied(cmd.getCommandContext())) {
                return false;
            }
            if (cmd.getCommandContext().isDomainMode()) {
                return false;
            }
            return super.isActivated(processedCommand);
        }

        static {
            EXPECTED.add("");
            NOT_EXPECTED.add("disabled");
        }
    }

    public static class ReplaceActivator
    extends AbstractDependRejectOptionActivator {
        private static final Set<String> EXPECTED = new HashSet<String>();
        private static final Set<String> NOT_EXPECTED = new HashSet<String>();

        public ReplaceActivator() {
            super(false, EXPECTED, NOT_EXPECTED);
        }

        @Override
        public boolean isActivated(ParsedCommand processedCommand) {
            CommandWithPermissions cmd = (CommandWithPermissions)processedCommand.command();
            if (!cmd.getPermissions().getFullReplacePermission().isSatisfied(cmd.getCommandContext())) {
                return false;
            }
            return super.isActivated(processedCommand);
        }

        static {
            EXPECTED.add("");
            NOT_EXPECTED.add("all-server-groups");
            NOT_EXPECTED.add("server-groups");
        }
    }

    public static class RuntimeNameActivator
    implements OptionActivator {
        public boolean isActivated(ParsedCommand pc) {
            CommandWithPermissions cmd = (CommandWithPermissions)pc.command();
            return cmd.getPermissions().getAddOrReplacePermission().isSatisfied(cmd.getCommandContext());
        }
    }

    public static class UnmanagedActivator
    implements OptionActivator {
        public boolean isActivated(ParsedCommand pc) {
            CommandWithPermissions cmd = (CommandWithPermissions)pc.command();
            return cmd.getPermissions().getMainAddPermission().isSatisfied(cmd.getCommandContext());
        }
    }

    public static class FileActivator
    implements OptionActivator {
        public boolean isActivated(ParsedCommand pc) {
            CommandWithPermissions cmd = (CommandWithPermissions)pc.command();
            return cmd.getPermissions().getAddOrReplacePermission().isSatisfied(cmd.getCommandContext());
        }
    }

    public static class UndeployArchiveActivator
    extends UndeployNameActivator {
    }

    public static class UndeployNameActivator
    implements OptionActivator {
        public boolean isActivated(ParsedCommand pc) {
            CommandWithPermissions cmd = (CommandWithPermissions)pc.command();
            return cmd.getPermissions().getRemoveOrUndeployPermission().isSatisfied(cmd.getCommandContext());
        }
    }

    public static class NameActivator
    implements OptionActivator {
        public boolean isActivated(ParsedCommand pc) {
            CommandWithPermissions cmd = (CommandWithPermissions)pc.command();
            return cmd.getPermissions().getDeployPermission().isSatisfied(cmd.getCommandContext());
        }
    }

    public static class UrlActivator
    implements OptionActivator {
        public boolean isActivated(ParsedCommand pc) {
            CommandWithPermissions cmd = (CommandWithPermissions)pc.command();
            return cmd.getPermissions().getAddOrReplacePermission().isSatisfied(cmd.getCommandContext());
        }
    }
}

