/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import javax.json.bind.serializer.JsonbSerializer;
import javax.json.bind.serializer.SerializationContext;
import javax.json.stream.JsonGenerator;
import org.eclipse.yasson.internal.Marshaller;
import org.eclipse.yasson.internal.ReflectionUtils;
import org.eclipse.yasson.internal.model.JsonContext;
import org.eclipse.yasson.internal.serializer.AbstractContainerSerializer;
import org.eclipse.yasson.internal.serializer.ContainerModel;
import org.eclipse.yasson.internal.serializer.EmbeddedItem;
import org.eclipse.yasson.internal.serializer.SerializerBuilder;

public class MapSerializer<T extends Map>
extends AbstractContainerSerializer<T>
implements EmbeddedItem {
    private Type mapValueRuntimeType = this.getRuntimeType() instanceof ParameterizedType ? ReflectionUtils.resolveType(this, ((ParameterizedType)this.getRuntimeType()).getActualTypeArguments()[1]) : Object.class;

    protected MapSerializer(SerializerBuilder builder) {
        super(builder);
    }

    @Override
    protected void serializeInternal(T obj, JsonGenerator generator, SerializationContext ctx) {
        Marshaller marshaller = (Marshaller)ctx;
        obj.keySet().forEach(key -> {
            String keysString = String.valueOf(key);
            Object value = obj.get(key);
            if (value == null) {
                generator.writeNull(keysString);
                return;
            }
            JsonbSerializer<?> serializer = ((SerializerBuilder)new SerializerBuilder(marshaller.getJsonbContext()).withObjectClass(value.getClass()).withModel(new ContainerModel(this.mapValueRuntimeType, this.resolveContainerModelCustomization(this.mapValueRuntimeType, marshaller.getJsonbContext()), JsonContext.JSON_OBJECT, keysString))).build();
            this.serializerCaptor(serializer, value, generator, ctx);
        });
    }

    @Override
    protected void writeStart(JsonGenerator generator) {
        generator.writeStartObject();
    }

    @Override
    protected void writeStart(String key, JsonGenerator generator) {
        generator.writeStartObject(key);
    }
}

