/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.command.settings;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintStream;
import org.aesh.command.Command;
import org.aesh.command.CommandNotFoundHandler;
import org.aesh.command.activator.CommandActivator;
import org.aesh.command.activator.CommandActivatorProvider;
import org.aesh.command.activator.OptionActivator;
import org.aesh.command.activator.OptionActivatorProvider;
import org.aesh.command.completer.CompleterInvocation;
import org.aesh.command.completer.CompleterInvocationProvider;
import org.aesh.command.converter.ConverterInvocation;
import org.aesh.command.converter.ConverterInvocationProvider;
import org.aesh.command.export.ExportChangeListener;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.invocation.CommandInvocationProvider;
import org.aesh.command.invocation.InvocationProviders;
import org.aesh.command.registry.CommandRegistry;
import org.aesh.command.settings.FileAccessPermission;
import org.aesh.command.settings.ManProvider;
import org.aesh.command.settings.QuitHandler;
import org.aesh.command.settings.Settings;
import org.aesh.command.validator.ValidatorInvocation;
import org.aesh.command.validator.ValidatorInvocationProvider;
import org.aesh.io.FileResource;
import org.aesh.io.Resource;
import org.aesh.readline.AeshContext;
import org.aesh.readline.DefaultAeshContext;
import org.aesh.readline.editing.EditMode;
import org.aesh.readline.editing.EditModeBuilder;
import org.aesh.terminal.Connection;
import org.aesh.utils.Config;

public class SettingsImpl<C extends Command<CI>, CI extends CommandInvocation, CI3 extends ConverterInvocation, CI2 extends CompleterInvocation, VI extends ValidatorInvocation, OA extends OptionActivator, CA extends CommandActivator>
implements Settings {
    private EditMode.Mode editMode = EditMode.Mode.EMACS;
    private File historyFile;
    private FileAccessPermission historyFilePermission;
    private int historySize = 500;
    private boolean historyDisabled = false;
    private boolean historyPersistent = true;
    private String bellStyle;
    private InputStream inputStream;
    private PrintStream stdOut;
    private PrintStream stdErr;
    private boolean readInputrc = true;
    private File inputrc;
    private boolean isLogging = false;
    private String logFile;
    private boolean disableCompletion = false;
    private QuitHandler quitHandler;
    private File aliasFile;
    private boolean aliasEnabled = true;
    private boolean persistAlias = true;
    private boolean enableOperatorParser = true;
    private boolean manEnabled = true;
    private AeshContext aeshContext;
    private boolean exportEnabled = true;
    private File exportFile;
    private boolean persistExport = true;
    private boolean exportUsesSystemEnvironment = false;
    private Resource resource;
    private String execute;
    private Resource executeFileAtStart;
    private CommandActivatorProvider<CA> commandActivatorProvider;
    private OptionActivatorProvider<OA> optionActivatorProvider;
    private CommandRegistry<C, CI> commandRegistry;
    private CommandInvocationProvider<CI> commandInvocationProvider;
    private CommandNotFoundHandler commandNotFoundHandler;
    private CompleterInvocationProvider<CI2> completerInvocationProvider;
    private ConverterInvocationProvider<CI3> converterInvocationProvider;
    private ValidatorInvocationProvider<VI> validatorInvocationProvider;
    private ManProvider manProvider;
    private Connection connection;
    private InvocationProviders<CA, CI3, CI2, VI, OA> invocationProviders;
    private ExportChangeListener exportListener;

    SettingsImpl() {
    }

    protected SettingsImpl(Settings<C, CI, CI3, CI2, VI, OA, CA> baseSettings) {
        this.setMode(baseSettings.mode());
        this.setHistoryFile(baseSettings.historyFile());
        this.setHistoryFilePermission(baseSettings.historyFilePermission());
        this.setHistorySize(baseSettings.historySize());
        this.setBellStyle(baseSettings.bellStyle());
        this.setStdIn(baseSettings.stdIn());
        this.setStdOut(baseSettings.stdOut());
        this.setStdErr(baseSettings.stdErr());
        this.setInputrc(baseSettings.inputrc());
        this.setLogging(baseSettings.logging());
        this.setDisableCompletion(baseSettings.completionDisabled());
        this.setLogFile(baseSettings.logFile());
        this.setReadInputrc(baseSettings.readInputrc());
        this.setHistoryDisabled(baseSettings.historyDisabled());
        this.setHistoryPersistent(baseSettings.historyPersistent());
        this.setAliasFile(baseSettings.aliasFile());
        this.setAliasEnabled(baseSettings.aliasEnabled());
        this.setPersistAlias(baseSettings.persistAlias());
        this.setQuitHandler(baseSettings.quitHandler());
        this.enableOperatorParser(baseSettings.operatorParserEnabled());
        this.setManEnabled(baseSettings.manEnabled());
        this.setAeshContext(baseSettings.aeshContext());
        this.setExportEnabled(baseSettings.exportEnabled());
        this.setExportFile(baseSettings.exportFile());
        this.setPersistExport(baseSettings.persistExport());
        this.setResource(baseSettings.resource());
        this.setExportUsesSystemEnvironment(baseSettings.exportUsesSystemEnvironment());
        this.setExecuteAtStart(baseSettings.executeAtStart());
        this.setCommandActivatorProvider(baseSettings.commandActivatorProvider());
        this.setOptionActivatorProvider(baseSettings.optionActivatorProvider());
        this.setCommandRegistry(baseSettings.commandRegistry());
        this.setCommandInvocationProvider(baseSettings.commandInvocationProvider());
        this.setCommandNotFoundHandler(baseSettings.commandNotFoundHandler());
        this.setCompleterInvocationProvider(baseSettings.completerInvocationProvider());
        this.setConverterInvocationProvider(baseSettings.converterInvocationProvider());
        this.setValidatorInvocationProvider(baseSettings.validatorInvocationProvider());
        this.setManProvider(baseSettings.manProvider());
        this.setConnection(baseSettings.connection());
        this.setInvocationProviders(baseSettings.invocationProviders());
        this.setExportListener(baseSettings.exportListener());
    }

    public void resetToDefaults() {
        this.editMode = EditMode.Mode.EMACS;
        this.historyFile = null;
        this.historyFilePermission = null;
        this.historySize = 500;
        this.historyDisabled = false;
        this.historyPersistent = true;
        this.bellStyle = null;
        this.inputStream = null;
        this.setStdOut(null);
        this.setStdErr(null);
        this.readInputrc = true;
        this.isLogging = false;
        this.logFile = null;
        this.disableCompletion = false;
        this.setQuitHandler(null);
        this.setAliasEnabled(true);
    }

    @Override
    public EditMode.Mode mode() {
        return this.editMode;
    }

    public void setMode(EditMode.Mode editMode) {
        this.editMode = editMode;
    }

    @Override
    public EditMode editMode() {
        if (this.readInputrc) {
            try {
                return EditModeBuilder.builder().parseInputrc((InputStream)new FileInputStream(this.inputrc())).create();
            }
            catch (FileNotFoundException e) {
                return EditModeBuilder.builder((EditMode.Mode)this.mode()).create();
            }
        }
        return EditModeBuilder.builder((EditMode.Mode)this.mode()).create();
    }

    @Override
    public FileAccessPermission historyFilePermission() {
        return this.historyFilePermission;
    }

    public void setHistoryFilePermission(FileAccessPermission historyFilePermission) {
        this.historyFilePermission = historyFilePermission;
    }

    @Override
    public File historyFile() {
        if (this.historyFile == null) {
            return new File(System.getProperty("user.home") + Config.getPathSeparator() + ".aesh_history");
        }
        return this.historyFile;
    }

    public void setHistoryFile(File historyFile) {
        this.historyFile = historyFile;
    }

    @Override
    public int historySize() {
        return this.historySize;
    }

    public void setHistorySize(int historySize) {
        this.historySize = historySize;
    }

    @Override
    public String bellStyle() {
        return this.bellStyle;
    }

    public void setBellStyle(String bellStyle) {
        this.bellStyle = bellStyle;
    }

    @Override
    public InputStream stdIn() {
        if (this.inputStream == null) {
            this.inputStream = System.in;
        }
        return this.inputStream;
    }

    public void setStdIn(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    @Override
    public PrintStream stdOut() {
        if (this.stdOut == null) {
            return System.out;
        }
        return this.stdOut;
    }

    public void setStdOut(PrintStream stdOut) {
        this.stdOut = stdOut;
    }

    @Override
    public PrintStream stdErr() {
        if (this.stdErr == null) {
            return System.err;
        }
        return this.stdErr;
    }

    public void setStdErr(PrintStream stdErr) {
        this.stdErr = stdErr;
    }

    @Override
    public File inputrc() {
        if (this.inputrc == null) {
            this.inputrc = new File(System.getProperty("user.home") + Config.getPathSeparator() + ".inputrc");
        }
        return this.inputrc;
    }

    public void setInputrc(File inputrc) {
        this.inputrc = inputrc;
    }

    @Override
    public boolean logging() {
        return this.isLogging;
    }

    public void setLogging(boolean logging) {
        this.isLogging = logging;
    }

    @Override
    public boolean completionDisabled() {
        return this.disableCompletion;
    }

    public void setDisableCompletion(boolean disableCompletion) {
        this.disableCompletion = disableCompletion;
    }

    @Override
    public String logFile() {
        if (this.logFile == null) {
            this.logFile = Config.getTmpDir() + Config.getPathSeparator() + "aesh.log";
        }
        return this.logFile;
    }

    public void setLogFile(String logFile) {
        this.logFile = logFile;
    }

    @Override
    public boolean readInputrc() {
        return this.readInputrc;
    }

    public void setReadInputrc(boolean readInputrc) {
        this.readInputrc = readInputrc;
    }

    @Override
    public boolean historyDisabled() {
        return this.historyDisabled;
    }

    public void setHistoryDisabled(boolean historyDisabled) {
        this.historyDisabled = historyDisabled;
    }

    @Override
    public boolean historyPersistent() {
        return this.historyPersistent;
    }

    public void setHistoryPersistent(boolean historyPersistent) {
        this.historyPersistent = historyPersistent;
    }

    public void setAliasFile(File file) {
        this.aliasFile = file;
    }

    @Override
    public File aliasFile() {
        if (this.aliasFile == null) {
            this.aliasFile = new File(Config.getHomeDir() + Config.getPathSeparator() + ".aesh_aliases");
        }
        return this.aliasFile;
    }

    @Override
    public boolean aliasEnabled() {
        return this.aliasEnabled;
    }

    public void setAliasEnabled(boolean enabled) {
        this.aliasEnabled = enabled;
    }

    public void setPersistAlias(boolean persist) {
        this.persistAlias = persist;
    }

    @Override
    public boolean persistAlias() {
        return this.persistAlias;
    }

    public void setQuitHandler(QuitHandler qh) {
        this.quitHandler = qh;
    }

    @Override
    public QuitHandler quitHandler() {
        return this.quitHandler;
    }

    public void enableOperatorParser(boolean enable) {
        this.enableOperatorParser = enable;
    }

    @Override
    public boolean operatorParserEnabled() {
        return this.enableOperatorParser;
    }

    @Override
    public boolean manEnabled() {
        return this.manEnabled;
    }

    public void setManEnabled(boolean enabled) {
        this.manEnabled = enabled;
    }

    @Override
    public AeshContext aeshContext() {
        if (this.aeshContext == null) {
            this.aeshContext = new DefaultAeshContext(this.resource().newInstance(Config.getUserDir()));
        }
        return this.aeshContext;
    }

    public void setAeshContext(AeshContext aeshContext) {
        this.aeshContext = aeshContext;
    }

    @Override
    public File exportFile() {
        if (this.exportFile == null) {
            this.exportFile = new File(Config.getHomeDir() + Config.getPathSeparator() + ".aesh_export");
        }
        return this.exportFile;
    }

    public void setExportFile(File exportFile) {
        if (exportFile != null) {
            this.exportFile = exportFile;
        }
    }

    @Override
    public boolean exportEnabled() {
        return this.exportEnabled;
    }

    public void setExportEnabled(boolean exportEnabled) {
        this.exportEnabled = exportEnabled;
    }

    @Override
    public void setPersistExport(boolean persistExport) {
        this.persistExport = persistExport;
    }

    @Override
    public boolean persistExport() {
        return this.persistExport;
    }

    @Override
    public void setExportUsesSystemEnvironment(boolean isLoad) {
        this.exportUsesSystemEnvironment = isLoad;
    }

    @Override
    public boolean exportUsesSystemEnvironment() {
        return this.exportUsesSystemEnvironment;
    }

    @Override
    public void setResource(Resource resource) {
        this.resource = resource;
    }

    @Override
    public void setExecuteAtStart(String execute) {
        this.execute = execute.endsWith(Config.getLineSeparator()) ? execute : execute + Config.getLineSeparator();
    }

    @Override
    public String executeAtStart() {
        return this.execute;
    }

    @Override
    public void setExecuteFileAtStart(Resource executeFileAtStart) {
        this.executeFileAtStart = executeFileAtStart;
    }

    @Override
    public Resource executeFileAtStart() {
        return this.executeFileAtStart;
    }

    @Override
    public Resource resource() {
        if (this.resource == null) {
            this.resource = new FileResource("");
        }
        return this.resource;
    }

    @Override
    public CommandRegistry<C, CI> commandRegistry() {
        return this.commandRegistry;
    }

    public CommandInvocationProvider<? extends CommandInvocation> commandInvocationProvider() {
        return this.commandInvocationProvider;
    }

    @Override
    public CommandNotFoundHandler commandNotFoundHandler() {
        return this.commandNotFoundHandler;
    }

    public CompleterInvocationProvider<? extends CompleterInvocation> completerInvocationProvider() {
        return this.completerInvocationProvider;
    }

    public ConverterInvocationProvider<? extends ConverterInvocation> converterInvocationProvider() {
        return this.converterInvocationProvider;
    }

    public ValidatorInvocationProvider<? extends ValidatorInvocation> validatorInvocationProvider() {
        return this.validatorInvocationProvider;
    }

    public OptionActivatorProvider<? extends OptionActivator> optionActivatorProvider() {
        return this.optionActivatorProvider;
    }

    @Override
    public ManProvider manProvider() {
        return this.manProvider;
    }

    public CommandActivatorProvider<? extends CommandActivator> commandActivatorProvider() {
        return this.commandActivatorProvider;
    }

    @Override
    public Connection connection() {
        return this.connection;
    }

    public void setCommandActivatorProvider(CommandActivatorProvider<CA> commandActivatorProvider) {
        this.commandActivatorProvider = commandActivatorProvider;
    }

    public void setOptionActivatorProvider(OptionActivatorProvider<OA> optionActivatorProvider) {
        this.optionActivatorProvider = optionActivatorProvider;
    }

    public void setCommandRegistry(CommandRegistry<C, CI> commandRegistry) {
        this.commandRegistry = commandRegistry;
    }

    public void setCommandInvocationProvider(CommandInvocationProvider<CI> commandInvocationProvider) {
        this.commandInvocationProvider = commandInvocationProvider;
    }

    public void setCommandNotFoundHandler(CommandNotFoundHandler commandNotFoundHandler) {
        this.commandNotFoundHandler = commandNotFoundHandler;
    }

    public void setCompleterInvocationProvider(CompleterInvocationProvider<CI2> completerInvocationProvider) {
        this.completerInvocationProvider = completerInvocationProvider;
    }

    public void setConverterInvocationProvider(ConverterInvocationProvider<CI3> converterInvocationProvider) {
        this.converterInvocationProvider = converterInvocationProvider;
    }

    public void setValidatorInvocationProvider(ValidatorInvocationProvider<VI> validatorInvocationProvider) {
        this.validatorInvocationProvider = validatorInvocationProvider;
    }

    public void setManProvider(ManProvider manProvider) {
        this.manProvider = manProvider;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public InvocationProviders<CA, CI3, CI2, VI, OA> invocationProviders() {
        return this.invocationProviders;
    }

    @Override
    public ExportChangeListener exportListener() {
        return this.exportListener;
    }

    public void setExportListener(ExportChangeListener listener) {
        this.exportListener = listener;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public void setInvocationProviders(InvocationProviders<CA, CI3, CI2, VI, OA> invocationProviders) {
        this.invocationProviders = invocationProviders;
    }
}

