/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.server.ListenerRegistry;
import javax.net.ssl.SSLContext;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.undertow.HttpListenerAdd;
import org.wildfly.extension.undertow.HttpListenerResourceDefinition;
import org.wildfly.extension.undertow.HttpListenerService;
import org.wildfly.extension.undertow.HttpsListenerResourceDefinition;
import org.wildfly.extension.undertow.HttpsListenerService;
import org.wildfly.extension.undertow.ListenerAdd;
import org.wildfly.extension.undertow.ListenerService;
import org.wildfly.extension.undertow.UndertowListener;
import org.wildfly.extension.undertow.logging.UndertowLogger;
import org.xnio.OptionMap;

public class HttpsListenerAdd
extends ListenerAdd {
    HttpsListenerAdd(HttpsListenerResourceDefinition def) {
        super(def);
    }

    @Override
    ListenerService createService(String name, String serverName, OperationContext context, ModelNode model, OptionMap listenerOptions, OptionMap socketOptions) throws OperationFailedException {
        OptionMap.Builder builder = OptionMap.builder().addAll(socketOptions);
        ModelNode securityRealmModel = HttpsListenerResourceDefinition.SECURITY_REALM.resolveModelAttribute(context, model);
        String cipherSuites = null;
        if (securityRealmModel.isDefined()) {
            HttpsListenerResourceDefinition.VERIFY_CLIENT.resolveOption((ExpressionResolver)context, model, builder);
            ModelNode value = HttpsListenerResourceDefinition.ENABLED_CIPHER_SUITES.resolveModelAttribute(context, model);
            cipherSuites = value.isDefined() ? value.asString() : null;
            HttpsListenerResourceDefinition.ENABLED_PROTOCOLS.resolveOption((ExpressionResolver)context, model, builder);
            HttpsListenerResourceDefinition.SSL_SESSION_CACHE_SIZE.resolveOption((ExpressionResolver)context, model, builder);
            HttpsListenerResourceDefinition.SSL_SESSION_TIMEOUT.resolveOption((ExpressionResolver)context, model, builder);
        }
        OptionMap.Builder listenerBuilder = OptionMap.builder().addAll(listenerOptions);
        HttpsListenerResourceDefinition.ENABLE_HTTP2.resolveOption((ExpressionResolver)context, model, listenerBuilder);
        HttpListenerAdd.handleHttp2Options(context, model, listenerBuilder);
        HttpListenerResourceDefinition.REQUIRE_HOST_HTTP11.resolveOption((ExpressionResolver)context, model, listenerBuilder);
        boolean certificateForwarding = HttpListenerResourceDefinition.CERTIFICATE_FORWARDING.resolveModelAttribute(context, model).asBoolean();
        boolean proxyAddressForwarding = HttpListenerResourceDefinition.PROXY_ADDRESS_FORWARDING.resolveModelAttribute(context, model).asBoolean();
        return new HttpsListenerService(name, serverName, listenerBuilder.getMap(), cipherSuites, builder.getMap(), certificateForwarding, proxyAddressForwarding);
    }

    @Override
    void configureAdditionalDependencies(OperationContext context, CapabilityServiceBuilder<? extends UndertowListener> serviceBuilder, ModelNode model, ListenerService service) throws OperationFailedException {
        serviceBuilder.addDependency(HttpListenerAdd.REGISTRY_SERVICE_NAME, ListenerRegistry.class, ((HttpListenerService)service).getHttpListenerRegistry());
        ModelNode sslContextModel = HttpsListenerResourceDefinition.SSL_CONTEXT.resolveModelAttribute(context, model);
        ModelNode securityRealmModel = HttpsListenerResourceDefinition.SECURITY_REALM.resolveModelAttribute(context, model);
        String sslContextRef = sslContextModel.isDefined() ? sslContextModel.asString() : null;
        String securityRealmRef = securityRealmModel.isDefined() ? securityRealmModel.asString() : null;
        InjectedValue sslContextInjector = new InjectedValue();
        InjectedValue securityRealmInjector = new InjectedValue();
        if (securityRealmRef != null) {
            SecurityRealm.ServiceUtil.addDependency(serviceBuilder, (Injector)securityRealmInjector, (String)securityRealmRef);
        }
        if (sslContextRef != null) {
            serviceBuilder.addCapabilityRequirement("org.wildfly.security.ssl-context", SSLContext.class, (Injector)sslContextInjector, new String[]{sslContextRef});
        }
        ((HttpsListenerService)service).setSSLContextSupplier(() -> {
            if (sslContextRef != null) {
                return (SSLContext)sslContextInjector.getValue();
            }
            if (securityRealmRef != null) {
                SSLContext sslContext = ((SecurityRealm)securityRealmInjector.getValue()).getSSLContext();
                if (sslContext == null) {
                    throw UndertowLogger.ROOT_LOGGER.noSslContextInSecurityRealm(securityRealmRef);
                }
                return sslContext;
            }
            try {
                return SSLContext.getDefault();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        });
    }
}

