/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl.aesh.cmd.security.model;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.impl.aesh.cmd.security.model.ElytronUtil;
import org.jboss.as.cli.operation.OperationFormatException;

public class DefaultResourceNames {
    public static String buildDefaultKeyStoreName(String name, CommandContext ctx) throws OperationFormatException, IOException {
        int i = 1;
        String computedName = name;
        while (ElytronUtil.keyStoreExists(ctx, computedName)) {
            computedName = name + "_" + i;
            ++i;
        }
        return computedName;
    }

    public static String buildDefaultKeyStoreName(File path, CommandContext ctx) throws OperationFormatException, IOException {
        return DefaultResourceNames.buildDefaultKeyStoreName(path.getName(), ctx);
    }

    public static String buildDefaultKeyStorePath(File path, CommandContext ctx) throws OperationFormatException, IOException {
        return DefaultResourceNames.buildDefaultKeyStoreName(path.getName(), ctx);
    }

    public static String buildDefaultKeyStoreAlias(String dn, CommandContext ctx) throws OperationFormatException, IOException {
        return dn.substring(0, dn.indexOf("="));
    }

    static String buildDefaultKeyStoreType(String type, CommandContext ctx) {
        return "JKS";
    }

    static String buildDefaultKeyManagerName(CommandContext ctx, String keystoreName) throws IOException, OperationFormatException {
        int i = 1;
        String computedName = "key-manager-" + keystoreName;
        while (ElytronUtil.keyManagerExists(ctx, computedName)) {
            computedName = "key-manager-" + keystoreName + "_" + i;
            ++i;
        }
        return computedName;
    }

    static String buildDefaultSSLContextName(CommandContext ctx, String keystoreName) throws IOException, OperationFormatException {
        int i = 1;
        String computedName = "ssl-context-" + keystoreName;
        while (ElytronUtil.serverSSLContextExists(ctx, computedName)) {
            computedName = "ssl-context-" + keystoreName + "_" + i;
            ++i;
        }
        return computedName;
    }

    public static String getDefaultManagementInterfaceName(CommandContext ctx) {
        return "http-interface";
    }

    static List<String> getDefaultProtocols(CommandContext ctx) {
        return Arrays.asList("TLSv1.2");
    }

    static String getDefaultHttpSecureSocketBindingName(String managementInterface, CommandContext ctx) {
        return "management-https";
    }

    public static String getDefaultServerName(CommandContext context) {
        return "default-server";
    }

    static String getDefaultApplicationLegacyRealm() {
        return "ApplicationRealm";
    }
}

