/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.jboss.as.controller.services.path.PathEntry;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.domain.management.SubjectIdentity;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.as.domain.management.security.KeytabIdentityFactoryService;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class KeytabService
implements Service<KeytabService> {
    private static final boolean IS_IBM = System.getProperty("java.vendor").contains("IBM");
    private static final String KRB5LoginModule = "com.sun.security.auth.module.Krb5LoginModule";
    private static final String IBMKRB5LoginModule = "com.ibm.security.auth.module.Krb5LoginModule";
    private static final CallbackHandler NO_CALLBACK_HANDLER = new CallbackHandler(){

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            throw new UnsupportedCallbackException(callbacks[0]);
        }
    };
    private final String principal;
    private final String path;
    private final String relativeTo;
    private final String[] forHosts;
    private final boolean debug;
    private final InjectedValue<PathManager> pathManager = new InjectedValue();
    private PathManager.Callback.Handle pathHandle = null;
    private Configuration clientConfiguration;
    private Configuration serverConfiguration;

    KeytabService(String principal, String path, String relativeTo, String[] forHosts, boolean debug) {
        this.principal = principal;
        this.path = path;
        this.relativeTo = relativeTo;
        this.forHosts = forHosts;
        this.debug = debug;
    }

    public KeytabService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public void start(StartContext context) throws StartException {
        File keyTabFile;
        String file = this.path;
        if (this.relativeTo != null) {
            PathManager pm = (PathManager)this.pathManager.getValue();
            file = pm.resolveRelativePathEntry(file, this.relativeTo);
            this.pathHandle = pm.registerCallback(this.relativeTo, new PathManager.Callback(){

                public void pathModelEvent(PathManager.PathEventContext eventContext, String name) {
                    if (!eventContext.isResourceServiceRestartAllowed()) {
                        eventContext.reloadRequired();
                    }
                }

                public void pathEvent(PathManager.Event event, PathEntry pathEntry) {
                }
            }, new PathManager.Event[]{PathManager.Event.REMOVED, PathManager.Event.UPDATED});
        }
        if (!(keyTabFile = new File(file)).exists()) {
            throw DomainManagementLogger.SECURITY_LOGGER.keyTabFileNotFound(file);
        }
        try {
            this.clientConfiguration = this.createConfiguration(false, keyTabFile);
            this.serverConfiguration = this.createConfiguration(true, keyTabFile);
        }
        catch (MalformedURLException e) {
            throw DomainManagementLogger.SECURITY_LOGGER.invalidKeytab(e);
        }
    }

    private Configuration createConfiguration(boolean isServer, File keyTabFile) throws MalformedURLException {
        AppConfigurationEntry ace;
        HashMap<String, String> options = new HashMap<String, String>();
        if (this.debug) {
            options.put("debug", "true");
        }
        options.put("principal", this.principal);
        if (IS_IBM) {
            options.put("noAddress", "true");
            options.put("credsType", isServer ? "acceptor" : "initiator");
            options.put("useKeytab", keyTabFile.toURI().toURL().toString());
            ace = new AppConfigurationEntry(IBMKRB5LoginModule, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
        } else {
            options.put("storeKey", "true");
            options.put("useKeyTab", "true");
            options.put("keyTab", keyTabFile.getAbsolutePath());
            options.put("isInitiator", isServer ? "false" : "true");
            ace = new AppConfigurationEntry(KRB5LoginModule, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
        }
        final AppConfigurationEntry[] aceArray = new AppConfigurationEntry[]{ace};
        return new Configuration(){

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                assert ("KDC".equals(name));
                return aceArray;
            }
        };
    }

    public void stop(StopContext context) {
        this.clientConfiguration = null;
        this.serverConfiguration = null;
        if (this.pathHandle != null) {
            this.pathHandle.remove();
            this.pathHandle = null;
        }
    }

    Injector<PathManager> getPathManagerInjector() {
        return this.pathManager;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public String[] getForHosts() {
        return (String[])this.forHosts.clone();
    }

    public SubjectIdentity createSubjectIdentity(boolean isClient) throws LoginException {
        final Subject theSubject = new Subject();
        final LoginContext lc = new LoginContext("KDC", theSubject, NO_CALLBACK_HANDLER, isClient ? this.clientConfiguration : this.serverConfiguration);
        lc.login();
        return new SubjectIdentity(){
            volatile boolean available = true;

            @Override
            public Subject getSubject() {
                this.assertAvailable();
                return theSubject;
            }

            @Override
            public void logout() {
                this.assertAvailable();
                try {
                    lc.logout();
                }
                catch (LoginException e) {
                    DomainManagementLogger.SECURITY_LOGGER.trace("Unable to logout.", e);
                }
            }

            private void assertAvailable() {
                if (!this.available) {
                    throw DomainManagementLogger.SECURITY_LOGGER.subjectIdentityLoggedOut();
                }
            }
        };
    }

    public static final class ServiceUtil {
        private ServiceUtil() {
        }

        public static ServiceName createServiceName(String realmName, String principal) {
            return KeytabIdentityFactoryService.ServiceUtil.createServiceName(realmName).append(new String[]{principal});
        }

        public static ServiceBuilder<?> addDependency(ServiceBuilder<?> sb, Injector<KeytabService> injector, String realmName, String principal) {
            sb.addDependency(ServiceUtil.createServiceName(realmName, principal), KeytabService.class, injector);
            return sb;
        }
    }
}

